/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.peermanager;

import java.util.Set;
import net.i2p.data.Hash;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.peermanager.PeerManager;
import net.i2p.router.peermanager.PersistProfileJob;

class PersistProfilesJob
extends JobImpl {
    private PeerManager _mgr;
    private static final long PERSIST_DELAY = 600000L;

    public PersistProfilesJob(RouterContext ctx, PeerManager mgr) {
        super(ctx);
        this._mgr = mgr;
        this.getTiming().setStartAfter(this.getContext().clock().now() + 600000L);
    }

    public String getName() {
        return "Persist profiles";
    }

    public void runJob() {
        Set peers = this._mgr.selectPeers();
        this.getContext().jobQueue().addJob(new PersistProfileJob(this.getContext(), this, peers));
    }

    void persist(Hash peer) {
        this._mgr.storeProfile(peer);
    }

    void requeue() {
        this.requeue(600000L);
    }
}

