/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.peermanager;

import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.RouterInfo;
import net.i2p.router.RouterContext;
import net.i2p.router.peermanager.DBHistory;
import net.i2p.router.peermanager.PeerProfile;
import net.i2p.router.peermanager.ProfileOrganizer;
import net.i2p.stat.Rate;
import net.i2p.stat.RateStat;

class ProfileOrganizerRenderer {
    private RouterContext _context;
    private ProfileOrganizer _organizer;
    private ProfileComparator _comparator;
    private static final DecimalFormat _fmt = new DecimalFormat("###,##0.00");
    private static final String na = "n/a";

    public ProfileOrganizerRenderer(ProfileOrganizer organizer, RouterContext context) {
        this._context = context;
        this._organizer = organizer;
        this._comparator = new ProfileComparator();
    }

    public void renderStatusHTML(Writer out) throws IOException {
        Hash peer;
        Set peers = this._organizer.selectAllPeers();
        long now = this._context.clock().now();
        long hideBefore = now - 10800000L;
        TreeSet<PeerProfile> order = new TreeSet<PeerProfile>(this._comparator);
        TreeSet<PeerProfile> integratedPeers = new TreeSet<PeerProfile>(this._comparator);
        for (Hash peer2 : peers) {
            if (this._organizer.getUs().equals((Object)peer2)) continue;
            PeerProfile prof = this._organizer.getProfile(peer2);
            if (this._organizer.isWellIntegrated(peer2)) {
                integratedPeers.add(prof);
            } else {
                RouterInfo info = this._context.netDb().lookupRouterInfoLocally(peer2);
                if (info != null && info.getCapabilities().indexOf("f") >= 0) {
                    integratedPeers.add(prof);
                }
            }
            if (prof.getLastSendSuccessful() <= hideBefore) continue;
            order.add(prof);
        }
        int fast = 0;
        int reliable = 0;
        int integrated = 0;
        int failing = 0;
        StringBuffer buf = new StringBuffer(16384);
        buf.append("<h2>Peer Profiles</h2>\n");
        buf.append("<table border=\"1\">");
        buf.append("<tr>");
        buf.append("<td><b>Peer</b> (").append(order.size()).append(", hiding ").append(peers.size() - order.size()).append(")</td>");
        buf.append("<td><b>Groups (Caps)</b></td>");
        buf.append("<td><b>Speed</b></td>");
        buf.append("<td><b>Capacity</b></td>");
        buf.append("<td><b>Integration</b></td>");
        buf.append("<td><b>Failing?</b></td>");
        buf.append("<td>&nbsp;</td>");
        buf.append("</tr>");
        int prevTier = 1;
        for (PeerProfile prof : order) {
            Rate accepted;
            long total;
            Rate failed;
            long fails;
            RouterInfo info;
            peer = prof.getPeer();
            int tier = 0;
            boolean isIntegrated = false;
            if (this._organizer.isFast(peer)) {
                tier = 1;
                ++fast;
                ++reliable;
            } else if (this._organizer.isHighCapacity(peer)) {
                tier = 2;
                ++reliable;
            } else if (this._organizer.isFailing(peer)) {
                ++failing;
            } else {
                tier = 3;
            }
            if (this._organizer.isWellIntegrated(peer)) {
                isIntegrated = true;
                ++integrated;
            }
            if (tier != prevTier) {
                buf.append("<tr><td colspan=\"7\"><hr /></td></tr>\n");
            }
            prevTier = tier;
            buf.append("<tr>");
            buf.append("<td><code>");
            if (prof.getIsFailing()) {
                buf.append("<font color=\"red\">-- ").append(peer.toBase64().substring(0, 6)).append("</font>");
            } else if (prof.getIsActive()) {
                buf.append("<font color=\"blue\">++ ").append(peer.toBase64().substring(0, 6)).append("</font>");
            } else {
                buf.append("&nbsp;&nbsp;&nbsp;").append(peer.toBase64().substring(0, 6));
            }
            buf.append("</code></td>");
            buf.append("<td>");
            switch (tier) {
                case 1: {
                    buf.append("Fast, High Capacity");
                    break;
                }
                case 2: {
                    buf.append("High Capacity");
                    break;
                }
                case 3: {
                    buf.append("Not Failing");
                    break;
                }
                default: {
                    buf.append("Failing");
                }
            }
            if (isIntegrated) {
                buf.append(", Integrated");
            }
            if ((info = this._context.netDb().lookupRouterInfoLocally(peer)) != null) {
                buf.append(" (").append(info.getCapabilities());
                String v = info.getOption("router.version");
                if (v != null) {
                    buf.append(' ').append(v);
                }
                buf.append(')');
            }
            buf.append("<td align=\"right\">").append(ProfileOrganizerRenderer.num(prof.getSpeedValue()));
            long bonus = prof.getSpeedBonus();
            if (bonus != 0L) {
                if (bonus > 0L) {
                    buf.append(" (+");
                } else {
                    buf.append(" (");
                }
                buf.append(bonus).append(')');
            }
            buf.append("</td><td align=\"right\">").append(ProfileOrganizerRenderer.num(prof.getCapacityValue()));
            bonus = prof.getCapacityBonus();
            if (bonus != 0L) {
                if (bonus > 0L) {
                    buf.append(" (+");
                } else {
                    buf.append(" (");
                }
                buf.append(bonus).append(')');
            }
            buf.append("</td><td align=\"right\">").append(ProfileOrganizerRenderer.num(prof.getIntegrationValue()));
            buf.append("</td><td>");
            if (this._context.shitlist().isShitlisted(peer)) {
                buf.append("Shitlist");
            }
            if (prof.getIsFailing()) {
                buf.append(" Failing");
            }
            if (this._context.commSystem().wasUnreachable(peer)) {
                buf.append(" Unreachable");
            }
            if ((fails = (failed = prof.getTunnelHistory().getFailedRate().getRate(1800000L)).getCurrentEventCount() + failed.getLastEventCount()) > 0L && (total = fails + (accepted = prof.getTunnelCreateResponseTime().getRate(1800000L)).getCurrentEventCount() + accepted.getLastEventCount()) / fails <= 10L) {
                buf.append(' ').append(fails).append('/').append(total).append(" Test Fails");
            }
            buf.append("&nbsp</td>");
            buf.append("<td nowrap><a href=\"netdb.jsp?r=").append(peer.toBase64().substring(0, 6)).append("\">netDb</a>");
            buf.append("/<a href=\"dumpprofile.jsp?peer=").append(peer.toBase64().substring(0, 6)).append("\">profile</a>");
            buf.append("/<a href=\"configpeer.jsp?peer=").append(peer.toBase64()).append("\">+-</a></td>\n");
            buf.append("</tr>");
        }
        buf.append("</table>");
        buf.append("<h2>Floodfill and Integrated Peers</h2>\n");
        buf.append("<table border=\"1\">");
        buf.append("<tr>");
        buf.append("<td><b>Peer</b></td>");
        buf.append("<td><b>Caps</b></td>");
        buf.append("<td><b>Integ. Value</b></td>");
        buf.append("<td><b>Last Heard About</b></td>");
        buf.append("<td><b>Last Heard From</b></td>");
        buf.append("<td><b>Last Successful Send</b></td>");
        buf.append("<td><b>Last Failed Send</b></td>");
        buf.append("<td><b>10m Resp. Time</b></td>");
        buf.append("<td><b>1h Resp. Time</b></td>");
        buf.append("<td><b>1d Resp. Time</b></td>");
        buf.append("<td><b>Successful Lookups</b></td>");
        buf.append("<td><b>Failed Lookups</b></td>");
        buf.append("<td><b>New Stores</b></td>");
        buf.append("<td><b>Old Stores</b></td>");
        buf.append("<td><b>1m Fail Rate</b></td>");
        buf.append("<td><b>1h Fail Rate</b></td>");
        buf.append("<td><b>1d Fail Rate</b></td>");
        buf.append("</tr>");
        for (PeerProfile prof : integratedPeers) {
            peer = prof.getPeer();
            buf.append("<tr>");
            buf.append("<td><code>");
            if (prof.getIsFailing()) {
                buf.append("<font color=\"red\">-- ").append(peer.toBase64().substring(0, 6)).append("</font>");
            } else if (prof.getIsActive()) {
                buf.append("<font color=\"blue\">++ ").append(peer.toBase64().substring(0, 6)).append("</font>");
            } else {
                buf.append("&nbsp;&nbsp;&nbsp;").append(peer.toBase64().substring(0, 6));
            }
            RouterInfo info = this._context.netDb().lookupRouterInfoLocally(peer);
            if (info != null) {
                buf.append("<td align=\"center\">" + info.getCapabilities() + "</td>");
            } else {
                buf.append("<td>&nbsp;</td>");
            }
            buf.append("</code></td>");
            buf.append("<td align=\"right\">").append(ProfileOrganizerRenderer.num(prof.getIntegrationValue())).append("</td>");
            long time = now - prof.getLastHeardAbout();
            buf.append("<td align=\"right\">").append(DataHelper.formatDuration((long)time)).append("</td>");
            time = now - prof.getLastHeardFrom();
            buf.append("<td align=\"right\">").append(DataHelper.formatDuration((long)time)).append("</td>");
            time = now - prof.getLastSendSuccessful();
            buf.append("<td align=\"right\">").append(DataHelper.formatDuration((long)time)).append("</td>");
            time = now - prof.getLastSendFailed();
            buf.append("<td align=\"right\">").append(DataHelper.formatDuration((long)time)).append("</td>");
            buf.append("<td align=\"right\">").append(this.avg(prof, 600000L)).append("</td>");
            buf.append("<td align=\"right\">").append(this.avg(prof, 3600000L)).append("</td>");
            buf.append("<td align=\"right\">").append(this.avg(prof, 86400000L)).append("</td>");
            DBHistory dbh = prof.getDBHistory();
            if (dbh == null) continue;
            buf.append("<td align=\"right\">").append(dbh.getSuccessfulLookups()).append("</td>");
            buf.append("<td align=\"right\">").append(dbh.getFailedLookups()).append("</td>");
            buf.append("<td align=\"right\">").append(dbh.getUnpromptedDbStoreNew()).append("</td>");
            buf.append("<td align=\"right\">").append(dbh.getUnpromptedDbStoreOld()).append("</td>");
            buf.append("<td align=\"right\">").append(this.davg(dbh, 60000L)).append("</td>");
            buf.append("<td align=\"right\">").append(this.davg(dbh, 3600000L)).append("</td>");
            buf.append("<td align=\"right\">").append(this.davg(dbh, 86400000L)).append("</td>");
        }
        buf.append("</table>");
        buf.append("<p><i>Definitions:<ul>");
        buf.append("<li><b>groups</b>: as determined by the profile organizer</li>");
        buf.append("<li><b>caps</b>: capabilities in the netDb, not used to determine profiles</li>");
        buf.append("<li><b>speed</b>: peak throughput (bytes per second) over a 1 minute period that the peer has sustained in a single tunnel</li>");
        buf.append("<li><b>capacity</b>: how many tunnels can we ask them to join in an hour?</li>");
        buf.append("<li><b>integration</b>: how many new peers have they told us about lately?</li>");
        buf.append("<li><b>failing?</b>: is the peer currently swamped (and if possible we should avoid nagging them)?</li>");
        buf.append("</ul></i>");
        buf.append("Red peers prefixed with '--' means the peer is failing, and blue peers prefixed ");
        buf.append("with '++' means we've sent or received a message from them ");
        buf.append("in the last five minutes.</i><br />");
        buf.append("<p><b>Thresholds:</b><br />");
        buf.append("<b>Speed:</b> ").append(ProfileOrganizerRenderer.num(this._organizer.getSpeedThreshold())).append(" (").append(fast).append(" fast peers)<br />");
        buf.append("<b>Capacity:</b> ").append(ProfileOrganizerRenderer.num(this._organizer.getCapacityThreshold())).append(" (").append(reliable).append(" high capacity peers)<br />");
        buf.append("<b>Integration:</b> ").append(ProfileOrganizerRenderer.num(this._organizer.getIntegrationThreshold())).append(" (").append(integrated).append(" well integrated peers)<br />");
        out.write(buf.toString());
        out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String num(double num) {
        DecimalFormat decimalFormat = _fmt;
        synchronized (decimalFormat) {
            return _fmt.format(num);
        }
    }

    String avg(PeerProfile prof, long rate) {
        RateStat rs = prof.getDbResponseTime();
        if (rs == null) {
            return na;
        }
        Rate r = rs.getRate(rate);
        if (r == null) {
            return na;
        }
        long c = r.getCurrentEventCount() + r.getLastEventCount();
        if (c == 0L) {
            return na;
        }
        double d = r.getCurrentTotalValue() + r.getLastTotalValue();
        return Math.round(d / (double)c) + "ms";
    }

    String davg(DBHistory dbh, long rate) {
        RateStat rs = dbh.getFailedLookupRate();
        if (rs == null) {
            return na;
        }
        Rate r = rs.getRate(rate);
        if (r == null) {
            return na;
        }
        long c = r.getCurrentEventCount() + r.getLastEventCount();
        return "" + c;
    }

    private class ProfileComparator
    implements Comparator {
        private ProfileComparator() {
        }

        public int compare(Object lhs, Object rhs) {
            if (lhs == null || rhs == null) {
                throw new NullPointerException("lhs=" + lhs + " rhs=" + rhs);
            }
            if (!(lhs instanceof PeerProfile) || !(rhs instanceof PeerProfile)) {
                throw new ClassCastException("lhs=" + lhs.getClass().getName() + " rhs=" + rhs.getClass().getName());
            }
            PeerProfile left = (PeerProfile)lhs;
            PeerProfile right = (PeerProfile)rhs;
            if (ProfileOrganizerRenderer.this._context.profileOrganizer().isFast(left.getPeer())) {
                if (ProfileOrganizerRenderer.this._context.profileOrganizer().isFast(right.getPeer())) {
                    return this.compareHashes(left, right);
                }
                return -1;
            }
            if (ProfileOrganizerRenderer.this._context.profileOrganizer().isHighCapacity(left.getPeer())) {
                if (ProfileOrganizerRenderer.this._context.profileOrganizer().isFast(right.getPeer())) {
                    return 1;
                }
                if (ProfileOrganizerRenderer.this._context.profileOrganizer().isHighCapacity(right.getPeer())) {
                    return this.compareHashes(left, right);
                }
                return -1;
            }
            if (ProfileOrganizerRenderer.this._context.profileOrganizer().isFailing(left.getPeer())) {
                if (ProfileOrganizerRenderer.this._context.profileOrganizer().isFailing(right.getPeer())) {
                    return this.compareHashes(left, right);
                }
                return 1;
            }
            if (ProfileOrganizerRenderer.this._context.profileOrganizer().isFast(right.getPeer())) {
                return 1;
            }
            if (ProfileOrganizerRenderer.this._context.profileOrganizer().isHighCapacity(right.getPeer())) {
                return 1;
            }
            if (ProfileOrganizerRenderer.this._context.profileOrganizer().isFailing(right.getPeer())) {
                return -1;
            }
            return this.compareHashes(left, right);
        }

        private int compareHashes(PeerProfile left, PeerProfile right) {
            return left.getPeer().toBase64().compareTo(right.getPeer().toBase64());
        }
    }
}

