/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.peermanager;

import net.i2p.router.RouterContext;
import net.i2p.router.peermanager.Calculator;
import net.i2p.router.peermanager.PeerProfile;
import net.i2p.stat.RateStat;
import net.i2p.util.Log;

public class ReliabilityCalculator
extends Calculator {
    private Log _log;
    private RouterContext _context;

    public ReliabilityCalculator(RouterContext context) {
        this._context = context;
        this._log = context.logManager().getLog(ReliabilityCalculator.class);
    }

    public double calc(PeerProfile profile) {
        if (profile.getSendSuccessSize().getRate(3600000L).getLifetimeEventCount() < 0L) {
            return profile.getReliabilityBonus();
        }
        long val = 0L;
        val += profile.getSendSuccessSize().getRate(60000L).getCurrentEventCount() * 20L;
        val += profile.getSendSuccessSize().getRate(60000L).getLastEventCount() * 10L;
        val += profile.getSendSuccessSize().getRate(3600000L).getLastEventCount() * 1L;
        val += profile.getSendSuccessSize().getRate(3600000L).getCurrentEventCount() * 5L;
        val += profile.getTunnelCreateResponseTime().getRate(600000L).getLastEventCount() * 5L;
        val += profile.getTunnelCreateResponseTime().getRate(3600000L).getCurrentEventCount();
        val += profile.getTunnelCreateResponseTime().getRate(3600000L).getLastEventCount();
        RateStat rejRate = profile.getTunnelHistory().getRejectionRate();
        if (rejRate.getRate(60000L).getCurrentEventCount() > 0L) {
            val -= 200L;
        }
        if (rejRate.getRate(60000L).getLastEventCount() > 0L) {
            val -= 100L;
        }
        if (rejRate.getRate(600000L).getCurrentEventCount() > 0L) {
            val -= 10L;
        }
        if (rejRate.getRate(600000L).getCurrentEventCount() > 0L) {
            val -= 5L;
        }
        if (profile.getDBHistory().getFailedLookupRate().getRate(60000L).getCurrentEventCount() > 0L) {
            val -= 10L;
        }
        if (profile.getDBHistory().getFailedLookupRate().getRate(60000L).getLastEventCount() > 0L) {
            val -= 5L;
        }
        if (profile.getCommError().getRate(60000L).getCurrentEventCount() > 0L) {
            val -= 200L;
        }
        if (profile.getCommError().getRate(60000L).getLastEventCount() > 0L) {
            val -= 200L;
        }
        if (profile.getCommError().getRate(3600000L).getCurrentEventCount() > 0L) {
            val -= 10L;
        }
        if (profile.getCommError().getRate(3600000L).getLastEventCount() > 0L) {
            val -= 10L;
        }
        val -= profile.getCommError().getRate(86400000L).getCurrentEventCount() * 1L;
        long timeSinceRejection = 3660000L;
        if (timeSinceRejection <= 3600000L) {
            val = timeSinceRejection > 600000L ? (val -= 10L) : (timeSinceRejection > 60000L ? (val -= 50L) : (val -= 100L));
        }
        return val += profile.getReliabilityBonus();
    }
}

