/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.startup;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Properties;
import net.i2p.data.Certificate;
import net.i2p.data.DataFormatException;
import net.i2p.data.PrivateKey;
import net.i2p.data.PublicKey;
import net.i2p.data.RouterIdentity;
import net.i2p.data.RouterInfo;
import net.i2p.data.SigningPrivateKey;
import net.i2p.data.SigningPublicKey;
import net.i2p.router.Job;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.util.Log;

public class CreateRouterInfoJob
extends JobImpl {
    private static Log _log = new Log(CreateRouterInfoJob.class);
    private Job _next;

    public CreateRouterInfoJob(RouterContext ctx, Job next) {
        super(ctx);
        this._next = next;
    }

    public String getName() {
        return "Create New Router Info";
    }

    public void runJob() {
        _log.debug("Creating the new router info");
        this.createRouterInfo();
        this.getContext().jobQueue().addJob(this._next);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RouterInfo createRouterInfo() {
        RouterInfo info = new RouterInfo();
        FileOutputStream fos1 = null;
        FileOutputStream fos2 = null;
        try {
            info.setAddresses(this.getContext().commSystem().createAddresses());
            Properties stats = this.getContext().statPublisher().publishStatistics();
            stats.setProperty("netId", "2");
            this.getContext().router().addCapabilities(info);
            info.setOptions(stats);
            info.setPeers(new HashSet());
            info.setPublished(CreateRouterInfoJob.getCurrentPublishDate(this.getContext()));
            RouterIdentity ident = new RouterIdentity();
            Certificate cert = this.getContext().router().createCertificate();
            ident.setCertificate(cert);
            PublicKey pubkey = null;
            PrivateKey privkey = null;
            SigningPublicKey signingPubKey = null;
            SigningPrivateKey signingPrivKey = null;
            Object[] keypair = this.getContext().keyGenerator().generatePKIKeypair();
            pubkey = (PublicKey)keypair[0];
            privkey = (PrivateKey)keypair[1];
            Object[] signingKeypair = this.getContext().keyGenerator().generateSigningKeypair();
            signingPubKey = (SigningPublicKey)signingKeypair[0];
            signingPrivKey = (SigningPrivateKey)signingKeypair[1];
            ident.setPublicKey(pubkey);
            ident.setSigningPublicKey(signingPubKey);
            info.setIdentity(ident);
            info.sign(signingPrivKey);
            String infoFilename = this.getContext().router().getConfigSetting("router.info.location");
            if (infoFilename == null) {
                infoFilename = "router.info";
            }
            fos1 = new FileOutputStream(infoFilename);
            info.writeBytes((OutputStream)fos1);
            String keyFilename = this.getContext().router().getConfigSetting("router.keys.location");
            if (keyFilename == null) {
                keyFilename = "router.keys";
            }
            fos2 = new FileOutputStream(keyFilename);
            privkey.writeBytes((OutputStream)fos2);
            signingPrivKey.writeBytes((OutputStream)fos2);
            pubkey.writeBytes((OutputStream)fos2);
            signingPubKey.writeBytes((OutputStream)fos2);
            this.getContext().keyManager().setSigningPrivateKey(signingPrivKey);
            this.getContext().keyManager().setSigningPublicKey(signingPubKey);
            this.getContext().keyManager().setPrivateKey(privkey);
            this.getContext().keyManager().setPublicKey(pubkey);
            _log.info("Router info created and stored at " + infoFilename + " with private keys stored at " + keyFilename + " [" + info + "]");
        }
        catch (DataFormatException dfe) {
            _log.error("Error building the new router information", (Throwable)dfe);
        }
        catch (IOException ioe) {
            _log.error("Error writing out the new router information", (Throwable)ioe);
        }
        finally {
            if (fos1 != null) {
                try {
                    fos1.close();
                }
                catch (IOException ioe) {}
            }
            if (fos2 != null) {
                try {
                    fos2.close();
                }
                catch (IOException ioe) {}
            }
        }
        return info;
    }

    static long getCurrentPublishDate(RouterContext context) {
        _log.info("Setting published date to /now/");
        return context.clock().now();
    }
}

