/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport;

import net.i2p.data.Hash;
import net.i2p.router.JobImpl;
import net.i2p.router.MessageSelector;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.CommSystemFacadeImpl;
import net.i2p.router.transport.TransportBid;
import net.i2p.util.Log;

public class GetBidsJob
extends JobImpl {
    private Log _log;
    private CommSystemFacadeImpl _facade;
    private OutNetMessage _msg;

    public GetBidsJob(RouterContext ctx, CommSystemFacadeImpl facade, OutNetMessage msg) {
        super(ctx);
        this._log = ctx.logManager().getLog(GetBidsJob.class);
        this._facade = facade;
        this._msg = msg;
    }

    public String getName() {
        return "Fetch bids for a message to be delivered";
    }

    public void runJob() {
        GetBidsJob.getBids(this.getContext(), this._facade, this._msg);
    }

    static void getBids(RouterContext context, CommSystemFacadeImpl facade, OutNetMessage msg) {
        Log log = context.logManager().getLog(GetBidsJob.class);
        Hash to = msg.getTarget().getIdentity().getHash();
        msg.timestamp("bid");
        if (context.shitlist().isShitlisted(to)) {
            if (log.shouldLog(30)) {
                log.warn("Attempt to send a message to a shitlisted peer - " + to);
            }
            context.statManager().addRateData("transport.bidFailShitlisted", msg.getLifetime(), 0L);
            GetBidsJob.fail(context, msg);
            return;
        }
        Hash us = context.routerHash();
        if (to.equals((Object)us)) {
            if (log.shouldLog(40)) {
                log.error("wtf, send a message to ourselves?  nuh uh. msg = " + msg);
            }
            context.statManager().addRateData("transport.bidFailSelf", msg.getLifetime(), 0L);
            GetBidsJob.fail(context, msg);
            return;
        }
        TransportBid bid = facade.getNextBid(msg);
        if (bid == null) {
            int failedCount = msg.getFailedTransports().size();
            if (failedCount == 0) {
                context.statManager().addRateData("transport.bidFailNoTransports", msg.getLifetime(), 0L);
                context.shitlist().shitlistRouter(to, "We share no common transports with them");
            } else if (failedCount >= facade.getTransportCount()) {
                context.statManager().addRateData("transport.bidFailAllTransports", msg.getLifetime(), 0L);
                context.netDb().fail(to);
            }
            GetBidsJob.fail(context, msg);
        } else {
            if (log.shouldLog(20)) {
                log.info("Attempting to send on transport " + bid.getTransport().getStyle() + ": " + bid);
            }
            bid.getTransport().send(msg);
        }
    }

    private static void fail(RouterContext context, OutNetMessage msg) {
        MessageSelector selector;
        if (msg.getOnFailedSendJob() != null) {
            context.jobQueue().addJob(msg.getOnFailedSendJob());
        }
        if (msg.getOnFailedReplyJob() != null) {
            context.jobQueue().addJob(msg.getOnFailedReplyJob());
        }
        if ((selector = msg.getReplySelector()) != null) {
            context.messageRegistry().unregisterPending(msg);
        }
        context.profileManager().messageFailed(msg.getTarget().getIdentity().getHash());
        msg.discardData();
    }
}

