/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.router.Job;
import net.i2p.router.MessageSelector;
import net.i2p.router.OutNetMessage;
import net.i2p.router.ReplyJob;
import net.i2p.router.RouterContext;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer;

public class OutboundMessageRegistry {
    private Log _log;
    private List _selectors;
    private Map _selectorToMessage;
    private Set _activeMessages;
    private CleanupTask _cleanupTask;
    private RouterContext _context;

    public OutboundMessageRegistry(RouterContext context) {
        this._context = context;
        this._log = this._context.logManager().getLog(OutboundMessageRegistry.class);
        this._selectors = new ArrayList(64);
        this._selectorToMessage = new HashMap(64);
        this._activeMessages = new HashSet(64);
        this._cleanupTask = new CleanupTask();
    }

    public void shutdown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getOriginalMessages(I2NPMessage message) {
        MessageSelector sel;
        int i;
        ArrayList<MessageSelector> matchedSelectors = null;
        ArrayList<MessageSelector> removedSelectors = null;
        List list = this._selectors;
        synchronized (list) {
            for (i = 0; i < this._selectors.size(); ++i) {
                boolean isMatch;
                sel = (MessageSelector)this._selectors.get(i);
                if (sel == null || !(isMatch = sel.isMatch(message))) continue;
                if (matchedSelectors == null) {
                    matchedSelectors = new ArrayList<MessageSelector>(1);
                }
                matchedSelectors.add(sel);
                if (sel.continueMatching()) continue;
                if (removedSelectors == null) {
                    removedSelectors = new ArrayList<MessageSelector>(1);
                }
                removedSelectors.add(sel);
                this._selectors.remove(i);
                --i;
            }
        }
        ArrayList<OutNetMessage> rv = null;
        if (matchedSelectors != null) {
            rv = new ArrayList<OutNetMessage>(matchedSelectors.size());
            for (i = 0; i < matchedSelectors.size(); ++i) {
                sel = (MessageSelector)matchedSelectors.get(i);
                boolean removed = false;
                OutNetMessage msg = null;
                List msgs = null;
                Object object = this._selectorToMessage;
                synchronized (object) {
                    Object o = null;
                    if (removedSelectors != null && removedSelectors.contains(sel)) {
                        o = this._selectorToMessage.remove(sel);
                        removed = true;
                    } else {
                        o = this._selectorToMessage.get(sel);
                    }
                    if (o instanceof OutNetMessage) {
                        msg = o;
                        if (msg != null) {
                            rv.add(msg);
                        }
                    } else if (o instanceof List && (msgs = (List)o) != null) {
                        rv.addAll(msgs);
                    }
                }
                if (!removed) continue;
                if (msg != null) {
                    object = this._activeMessages;
                    synchronized (object) {
                        this._activeMessages.remove(msg);
                        continue;
                    }
                }
                if (msgs == null) continue;
                object = this._activeMessages;
                synchronized (object) {
                    this._activeMessages.removeAll(msgs);
                    continue;
                }
            }
        } else {
            rv = Collections.EMPTY_LIST;
        }
        return rv;
    }

    public OutNetMessage registerPending(MessageSelector replySelector, ReplyJob onReply, Job onTimeout, int timeoutMs) {
        OutNetMessage msg = new OutNetMessage(this._context);
        msg.setExpiration(this._context.clock().now() + (long)timeoutMs);
        msg.setOnFailedReplyJob(onTimeout);
        msg.setOnFailedSendJob(onTimeout);
        msg.setOnReplyJob(onReply);
        msg.setReplySelector(replySelector);
        this.registerPending(msg, true);
        return msg;
    }

    public void registerPending(OutNetMessage msg) {
        this.registerPending(msg, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerPending(OutNetMessage msg, boolean allowEmpty) {
        if (!allowEmpty && msg.getMessage() == null) {
            throw new IllegalArgumentException("OutNetMessage doesn't contain an I2NPMessage? wtf");
        }
        MessageSelector sel = msg.getReplySelector();
        if (sel == null) {
            throw new IllegalArgumentException("No reply selector?  wtf");
        }
        boolean alreadyPending = false;
        Object object = this._activeMessages;
        synchronized (object) {
            if (!this._activeMessages.add(msg)) {
                return;
            }
        }
        object = this._selectorToMessage;
        synchronized (object) {
            OutNetMessage oldMsg = this._selectorToMessage.put(sel, msg);
            if (oldMsg != null) {
                List<OutNetMessage> multi = null;
                if (oldMsg instanceof OutNetMessage) {
                    multi = new ArrayList<OutNetMessage>(4);
                    multi.add(oldMsg);
                    multi.add(msg);
                    this._selectorToMessage.put(sel, multi);
                } else if (oldMsg instanceof List) {
                    multi = (List)((Object)oldMsg);
                    multi.add(msg);
                    this._selectorToMessage.put(sel, multi);
                }
                if (this._log.shouldLog(30)) {
                    this._log.warn("a single message selector [" + sel + "] with multiple messages (" + multi + ")");
                }
            }
        }
        object = this._selectors;
        synchronized (object) {
            this._selectors.add(sel);
        }
        this._cleanupTask.scheduleExpiration(sel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterPending(OutNetMessage msg) {
        if (msg == null) {
            return;
        }
        MessageSelector sel = msg.getReplySelector();
        boolean stillActive = false;
        Object object = this._selectorToMessage;
        synchronized (object) {
            Object old = this._selectorToMessage.remove(sel);
            if (old != null && old instanceof List) {
                List l = (List)old;
                l.remove(msg);
                if (l.size() > 0) {
                    this._selectorToMessage.put(sel, l);
                    stillActive = true;
                }
            }
        }
        if (!stillActive) {
            object = this._selectors;
            synchronized (object) {
                this._selectors.remove(sel);
            }
        }
        object = this._activeMessages;
        synchronized (object) {
            this._activeMessages.remove(msg);
        }
    }

    public void renderStatusHTML(Writer out) throws IOException {
    }

    private class CleanupTask
    implements SimpleTimer.TimedEvent {
        private long _nextExpire = -1L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void timeReached() {
            long now = OutboundMessageRegistry.this._context.clock().now();
            ArrayList<MessageSelector> removing = new ArrayList<MessageSelector>(1);
            List list = OutboundMessageRegistry.this._selectors;
            synchronized (list) {
                for (int i = 0; i < OutboundMessageRegistry.this._selectors.size(); ++i) {
                    MessageSelector sel = (MessageSelector)OutboundMessageRegistry.this._selectors.get(i);
                    if (sel == null) continue;
                    long expiration = sel.getExpiration();
                    if (expiration <= now) {
                        removing.add(sel);
                        OutboundMessageRegistry.this._selectors.remove(i);
                        --i;
                        continue;
                    }
                    if (expiration >= this._nextExpire && this._nextExpire >= now) continue;
                    this._nextExpire = expiration;
                }
            }
            if (removing.size() > 0) {
                for (int i = 0; i < removing.size(); ++i) {
                    Object fail;
                    MessageSelector sel = (MessageSelector)removing.get(i);
                    OutNetMessage msg = null;
                    List msgs = null;
                    Object object = OutboundMessageRegistry.this._selectorToMessage;
                    synchronized (object) {
                        Object o = OutboundMessageRegistry.this._selectorToMessage.remove(sel);
                        if (o instanceof OutNetMessage) {
                            msg = (OutNetMessage)o;
                        } else if (o instanceof List) {
                            msgs = (List)o;
                        }
                    }
                    if (msg != null) {
                        object = OutboundMessageRegistry.this._activeMessages;
                        synchronized (object) {
                            OutboundMessageRegistry.this._activeMessages.remove(msg);
                        }
                        fail = msg.getOnFailedReplyJob();
                        if (fail == null) continue;
                        OutboundMessageRegistry.this._context.jobQueue().addJob((Job)fail);
                        continue;
                    }
                    if (msgs == null) continue;
                    fail = OutboundMessageRegistry.this._activeMessages;
                    synchronized (fail) {
                        OutboundMessageRegistry.this._activeMessages.removeAll(msgs);
                    }
                    for (int j = 0; j < msgs.size(); ++j) {
                        msg = (OutNetMessage)msgs.get(j);
                        Job fail2 = msg.getOnFailedReplyJob();
                        if (fail2 == null) continue;
                        OutboundMessageRegistry.this._context.jobQueue().addJob(fail2);
                    }
                }
            }
            if (this._nextExpire <= now) {
                this._nextExpire = now + 10000L;
            }
            SimpleTimer.getInstance().addEvent((SimpleTimer.TimedEvent)this, this._nextExpire - now);
        }

        public void scheduleExpiration(MessageSelector sel) {
            long now = OutboundMessageRegistry.this._context.clock().now();
            if (this._nextExpire <= now || sel.getExpiration() < this._nextExpire) {
                this._nextExpire = sel.getExpiration();
                SimpleTimer.getInstance().addEvent((SimpleTimer.TimedEvent)this, this._nextExpire - now);
            }
        }
    }
}

