/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import net.i2p.data.Hash;
import net.i2p.data.RouterAddress;
import net.i2p.data.RouterIdentity;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.Transport;
import net.i2p.router.transport.TransportBid;
import net.i2p.router.transport.TransportEventListener;
import net.i2p.router.transport.ntcp.NTCPTransport;
import net.i2p.router.transport.udp.UDPTransport;
import net.i2p.util.Log;

public class TransportManager
implements TransportEventListener {
    private Log _log;
    private List _transports;
    private RouterContext _context;
    private static final String PROP_DISABLE_TCP = "i2np.tcp.disable";
    private static final String PROP_ENABLE_UDP = "i2np.udp.enable";
    private static final String PROP_ENABLE_NTCP = "i2np.ntcp.enable";
    private static final String DEFAULT_ENABLE_NTCP = "true";
    private static final String DEFAULT_ENABLE_UDP = "true";
    static final boolean ALLOW_TCP = false;

    public TransportManager(RouterContext context) {
        this._context = context;
        this._log = this._context.logManager().getLog(TransportManager.class);
        this._context.statManager().createRateStat("transport.shitlistOnUnreachable", "Add a peer to the shitlist since none of the transports can reach them", "Transport", new long[]{60000L, 600000L, 3600000L});
        this._context.statManager().createRateStat("transport.noBidsYetNotAllUnreachable", "Add a peer to the shitlist since none of the transports can reach them", "Transport", new long[]{60000L, 600000L, 3600000L});
        this._context.statManager().createRateStat("transport.bidFailShitlisted", "Could not attempt to bid on message, as they were shitlisted", "Transport", new long[]{60000L, 600000L, 3600000L});
        this._context.statManager().createRateStat("transport.bidFailSelf", "Could not attempt to bid on message, as it targeted ourselves", "Transport", new long[]{60000L, 600000L, 3600000L});
        this._context.statManager().createRateStat("transport.bidFailNoTransports", "Could not attempt to bid on message, as none of the transports could attempt it", "Transport", new long[]{60000L, 600000L, 3600000L});
        this._context.statManager().createRateStat("transport.bidFailAllTransports", "Could not attempt to bid on message, as all of the transports had failed", "Transport", new long[]{60000L, 600000L, 3600000L});
        this._transports = new ArrayList();
    }

    public void addTransport(Transport transport) {
        if (transport == null) {
            return;
        }
        this._transports.add(transport);
        transport.setListener(this);
    }

    public void removeTransport(Transport transport) {
        if (transport == null) {
            return;
        }
        this._transports.remove(transport);
        transport.setListener(null);
    }

    private void configTransports() {
        String enableUDP = this._context.router().getConfigSetting(PROP_ENABLE_UDP);
        if (enableUDP == null) {
            enableUDP = "true";
        }
        if ("true".equalsIgnoreCase(enableUDP)) {
            UDPTransport udp = new UDPTransport(this._context);
            udp.setListener(this);
            this._transports.add(udp);
        }
        TransportManager.enableNTCP(this._context);
        NTCPTransport ntcp = new NTCPTransport(this._context);
        ntcp.setListener(this);
        this._transports.add(ntcp);
    }

    static boolean enableNTCP(RouterContext ctx) {
        String enableNTCP = ctx.router().getConfigSetting(PROP_ENABLE_NTCP);
        if (enableNTCP == null) {
            enableNTCP = "true";
        }
        return "true".equalsIgnoreCase(enableNTCP);
    }

    public void startListening() {
        this.configTransports();
        this._log.debug("Starting up the transport manager");
        for (int i = 0; i < this._transports.size(); ++i) {
            Transport t = (Transport)this._transports.get(i);
            RouterAddress addr = t.startListening();
            this._log.debug("Transport " + i + " (" + t.getStyle() + ") started");
        }
        this._log.debug("Done start listening on transports");
        this._context.router().rebuildRouterInfo();
    }

    public void restart() {
        this.stopListening();
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.startListening();
    }

    public void stopListening() {
        for (int i = 0; i < this._transports.size(); ++i) {
            ((Transport)this._transports.get(i)).stopListening();
        }
        this._transports.clear();
    }

    public Transport getNTCPTransport() {
        for (int i = 0; i < this._transports.size(); ++i) {
            Transport t = (Transport)this._transports.get(i);
            if (!"NTCP".equals(t.getStyle())) continue;
            return t;
        }
        return null;
    }

    int getTransportCount() {
        return this._transports.size();
    }

    private boolean isSupported(Set addresses, Transport t) {
        for (RouterAddress addr : addresses) {
            if (!addr.getTransportStyle().equals(t.getStyle())) continue;
            return true;
        }
        return false;
    }

    public int countActivePeers() {
        int peers = 0;
        for (int i = 0; i < this._transports.size(); ++i) {
            peers += ((Transport)this._transports.get(i)).countActivePeers();
        }
        return peers;
    }

    public int countActiveSendPeers() {
        int peers = 0;
        for (int i = 0; i < this._transports.size(); ++i) {
            peers += ((Transport)this._transports.get(i)).countActiveSendPeers();
        }
        return peers;
    }

    public Vector getClockSkews() {
        Vector skews = new Vector();
        for (int i = 0; i < this._transports.size(); ++i) {
            Vector tempSkews = ((Transport)this._transports.get(i)).getClockSkews();
            if (tempSkews == null || tempSkews.size() <= 0) continue;
            skews.addAll(tempSkews);
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Transport manager returning " + skews.size() + " peer clock skews.");
        }
        return skews;
    }

    public short getReachabilityStatus() {
        if (this._transports.size() <= 0) {
            return 4;
        }
        short[] status = new short[this._transports.size()];
        for (int i = 0; i < this._transports.size(); ++i) {
            status[i] = ((Transport)this._transports.get(i)).getReachabilityStatus();
        }
        Arrays.sort(status);
        return status[0];
    }

    public void recheckReachability() {
        for (int i = 0; i < this._transports.size(); ++i) {
            ((Transport)this._transports.get(i)).recheckReachability();
        }
    }

    public boolean isBacklogged(Hash dest) {
        for (int i = 0; i < this._transports.size(); ++i) {
            Transport t = (Transport)this._transports.get(i);
            if (!t.isBacklogged(dest)) continue;
            return true;
        }
        return false;
    }

    public boolean isEstablished(Hash dest) {
        for (int i = 0; i < this._transports.size(); ++i) {
            Transport t = (Transport)this._transports.get(i);
            if (!t.isEstablished(dest)) continue;
            return true;
        }
        return false;
    }

    public boolean wasUnreachable(Hash dest) {
        for (int i = 0; i < this._transports.size(); ++i) {
            Transport t = (Transport)this._transports.get(i);
            if (t.wasUnreachable(dest)) continue;
            return false;
        }
        return true;
    }

    Map getAddresses() {
        HashMap<String, RouterAddress> rv = new HashMap<String, RouterAddress>(this._transports.size());
        for (int i = 0; i < this._transports.size(); ++i) {
            Transport t = (Transport)this._transports.get(i);
            if (t.getCurrentAddress() == null) continue;
            rv.put(t.getStyle(), t.getCurrentAddress());
        }
        return rv;
    }

    public TransportBid getBid(OutNetMessage msg) {
        List bids = this.getBids(msg);
        if (bids == null || bids.size() <= 0) {
            return null;
        }
        return (TransportBid)bids.get(0);
    }

    public List getBids(OutNetMessage msg) {
        if (msg == null) {
            throw new IllegalArgumentException("Null message?  no bidding on a null outNetMessage!");
        }
        if (this._context.router().getRouterInfo().equals((Object)msg.getTarget())) {
            throw new IllegalArgumentException("WTF, bids for a message bound to ourselves?");
        }
        ArrayList<TransportBid> rv = new ArrayList<TransportBid>(this._transports.size());
        Set failedTransports = msg.getFailedTransports();
        for (int i = 0; i < this._transports.size(); ++i) {
            Transport t = (Transport)this._transports.get(i);
            if (failedTransports.contains(t.getStyle())) {
                if (!this._log.shouldLog(10)) continue;
                this._log.debug("Skipping transport " + t.getStyle() + " as it already failed");
                continue;
            }
            TransportBid bid = t.bid(msg.getTarget(), msg.getMessageSize());
            if (bid != null) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Transport " + t.getStyle() + " bid: " + bid);
                }
                rv.add(bid);
                continue;
            }
            if (!this._log.shouldLog(10)) continue;
            this._log.debug("Transport " + t.getStyle() + " did not produce a bid");
        }
        return rv;
    }

    public TransportBid getNextBid(OutNetMessage msg) {
        int unreachableTransports = 0;
        Hash peer = msg.getTarget().getIdentity().calculateHash();
        Set failedTransports = msg.getFailedTransports();
        TransportBid rv = null;
        for (int i = 0; i < this._transports.size(); ++i) {
            Transport t = (Transport)this._transports.get(i);
            if (t.isUnreachable(peer)) {
                ++unreachableTransports;
                msg.transportFailed(t.getStyle());
                continue;
            }
            if (failedTransports.contains(t.getStyle())) {
                if (!this._log.shouldLog(10)) continue;
                this._log.debug("Skipping transport " + t.getStyle() + " as it already failed");
                continue;
            }
            TransportBid bid = t.bid(msg.getTarget(), msg.getMessageSize());
            if (bid != null) {
                if (rv == null || rv.getLatencyMs() > bid.getLatencyMs()) {
                    rv = bid;
                }
                if (!this._log.shouldLog(10)) continue;
                this._log.debug("Transport " + t.getStyle() + " bid: " + bid + " currently winning? " + (rv == bid) + " (winning latency: " + rv.getLatencyMs() + " / " + rv + ")");
                continue;
            }
            if (this._log.shouldLog(10)) {
                this._log.debug("Transport " + t.getStyle() + " did not produce a bid");
            }
            if (!t.isUnreachable(peer)) continue;
            ++unreachableTransports;
        }
        if (unreachableTransports >= this._transports.size()) {
            if (unreachableTransports >= this._transports.size() && this.countActivePeers() > 0) {
                this._context.statManager().addRateData("transport.shitlistOnUnreachable", msg.getLifetime(), msg.getLifetime());
                this._context.shitlist().shitlistRouter(peer, "Unreachable on any transport");
            }
        } else if (rv == null) {
            this._context.statManager().addRateData("transport.noBidsYetNotAllUnreachable", (long)unreachableTransports, msg.getLifetime());
        }
        return rv;
    }

    public void messageReceived(I2NPMessage message, RouterIdentity fromRouter, Hash fromRouterHash) {
        block4: {
            if (this._log.shouldLog(10)) {
                this._log.debug("I2NPMessage received: " + message.getClass().getName(), (Throwable)new Exception("Where did I come from again?"));
            }
            try {
                int num = this._context.inNetMessagePool().add(message, fromRouter, fromRouterHash);
                if (this._log.shouldLog(10)) {
                    this._log.debug("Added to in pool: " + num);
                }
            }
            catch (IllegalArgumentException iae) {
                if (!this._log.shouldLog(30)) break block4;
                this._log.warn("Error receiving message", (Throwable)iae);
            }
        }
    }

    public List getMostRecentErrorMessages() {
        ArrayList rv = new ArrayList(16);
        for (int i = 0; i < this._transports.size(); ++i) {
            Transport t = (Transport)this._transports.get(i);
            rv.addAll(t.getMostRecentErrorMessages());
        }
        return rv;
    }

    public void renderStatusHTML(Writer out, String urlBase, int sortFlags) throws IOException {
        TreeMap<String, Transport> transports = new TreeMap<String, Transport>();
        for (int i = 0; i < this._transports.size(); ++i) {
            Transport t = (Transport)this._transports.get(i);
            transports.put(t.getStyle(), t);
        }
        for (Transport t : transports.values()) {
            t.renderStatusHTML(out, urlBase, sortFlags);
        }
        StringBuffer buf = new StringBuffer(4096);
        buf.append("Listening on: <br /><pre>\n");
        for (int i = 0; i < this._transports.size(); ++i) {
            Transport t = (Transport)this._transports.get(i);
            if (t.getCurrentAddress() != null) {
                buf.append(t.getCurrentAddress()).append("\n\n");
                continue;
            }
            buf.append(t.getStyle()).append(" is used for outbound connections only\n\n");
        }
        buf.append("</pre>\n");
        out.write(buf.toString());
        out.flush();
    }
}

