/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.ntcp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.RouterAddress;
import net.i2p.data.RouterIdentity;
import net.i2p.data.RouterInfo;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.CommSystemFacadeImpl;
import net.i2p.router.transport.Transport;
import net.i2p.router.transport.TransportBid;
import net.i2p.router.transport.TransportImpl;
import net.i2p.router.transport.ntcp.EventPumper;
import net.i2p.router.transport.ntcp.NTCPAddress;
import net.i2p.router.transport.ntcp.NTCPConnection;
import net.i2p.router.transport.ntcp.Reader;
import net.i2p.router.transport.ntcp.Writer;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer;

public class NTCPTransport
extends TransportImpl {
    private Log _log;
    private SharedBid _fastBid;
    private SharedBid _slowBid;
    private Object _conLock;
    private Map _conByIdent;
    private NTCPAddress _myAddress;
    private EventPumper _pumper;
    private Reader _reader;
    private Writer _writer;
    private List _establishing;
    private List _sent;
    private SendFinisher _finisher;
    private static final int DEFAULT_MAX_CONNECTIONS = 500;
    private static final int NUM_CONCURRENT_READERS = 3;
    private static final int NUM_CONCURRENT_WRITERS = 3;
    public static final int ESTABLISH_TIMEOUT = 10000;
    public static final String STYLE = "NTCP";
    private static NumberFormat _rateFmt = new DecimalFormat("#,#0.00");

    public NTCPTransport(RouterContext ctx) {
        super(ctx);
        this._log = ctx.logManager().getLog(this.getClass());
        this._context.statManager().createRateStat("ntcp.sendTime", "Total message lifetime when sent completely", "ntcp", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("ntcp.transmitTime", "How long after message preparation before the message was fully sent", "ntcp", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("ntcp.sendQueueSize", "How many messages were ahead of the current one on the connection's queue when it was first added", "ntcp", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("ntcp.receiveTime", "How long it takes to receive an inbound message", "ntcp", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("ntcp.receiveSize", "How large the received message was", "ntcp", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("ntcp.sendBacklogTime", "How long the head of the send queue has been waiting when we fail to add a new one to the queue (period is the number of messages queued)", "ntcp", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("ntcp.failsafeWrites", "How many times do we need to proactively add in an extra nio write to a peer at any given failsafe pass?", "ntcp", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("ntcp.failsafeCloses", "How many times do we need to proactively close an idle connection to a peer at any given failsafe pass?", "ntcp", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("ntcp.failsafeInvalid", "How many times do we close a connection to a peer to work around a JVM bug?", "ntcp", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("ntcp.accept", "", "ntcp", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("ntcp.attemptShitlistedPeer", "", "ntcp", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("ntcp.attemptUnreachablePeer", "", "ntcp", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("ntcp.closeOnBacklog", "", "ntcp", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("ntcp.connectFailedIOE", "", "ntcp", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("ntcp.connectFailedInvalidPort", "", "ntcp", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("ntcp.bidRejectedLocalAddress", "", "ntcp", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("ntcp.bidRejectedNoNTCPAddress", "", "ntcp", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("ntcp.connectFailedTimeout", "", "ntcp", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("ntcp.connectFailedTimeoutIOE", "", "ntcp", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("ntcp.connectFailedUnresolved", "", "ntcp", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("ntcp.connectImmediate", "", "ntcp", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("ntcp.connectSuccessful", "", "ntcp", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("ntcp.corruptDecryptedI2NP", "", "ntcp", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("ntcp.corruptI2NPCRC", "", "ntcp", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("ntcp.corruptI2NPIME", "", "ntcp", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("ntcp.corruptI2NPIOE", "", "ntcp", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("ntcp.corruptMetaCRC", "", "ntcp", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("ntcp.corruptSkew", "", "ntcp", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("ntcp.corruptTooLargeI2NP", "", "ntcp", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("ntcp.dontSendOnBacklog", "", "ntcp", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("ntcp.inboundCheckConnection", "", "ntcp", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("ntcp.inboundEstablished", "", "ntcp", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("ntcp.inboundEstablishedDuplicate", "", "ntcp", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("ntcp.infoMessageEnqueued", "", "ntcp", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("ntcp.floodInfoMessageEnqueued", "", "ntcp", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("ntcp.invalidDH", "", "ntcp", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("ntcp.invalidHXY", "", "ntcp", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("ntcp.invalidHXxorBIH", "", "ntcp", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("ntcp.invalidInboundDFE", "", "ntcp", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("ntcp.invalidInboundIOE", "", "ntcp", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("ntcp.invalidInboundSignature", "", "ntcp", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("ntcp.invalidInboundSize", "", "ntcp", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("ntcp.invalidInboundSkew", "", "ntcp", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("ntcp.invalidSignature", "", "ntcp", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("ntcp.liveReadBufs", "", "ntcp", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("ntcp.multipleCloseOnRemove", "", "ntcp", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("ntcp.outboundEstablishFailed", "", "ntcp", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("ntcp.outboundFailedIOEImmediate", "", "ntcp", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("ntcp.invalidOutboundSkew", "", "ntcp", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("ntcp.prepBufCache", "", "ntcp", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("ntcp.queuedRecv", "", "ntcp", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("ntcp.read", "", "ntcp", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("ntcp.readEOF", "", "ntcp", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("ntcp.readError", "", "ntcp", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("ntcp.receiveCorruptEstablishment", "", "ntcp", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("ntcp.receiveMeta", "", "ntcp", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("ntcp.registerConnect", "", "ntcp", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("ntcp.throttledReadComplete", "", "ntcp", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("ntcp.throttledWriteComplete", "", "ntcp", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("ntcp.wantsQueuedWrite", "", "ntcp", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("ntcp.write", "", "ntcp", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("ntcp.writeError", "", "ntcp", new long[]{60000L, 600000L});
        this._establishing = new ArrayList(4);
        this._conLock = new Object();
        this._conByIdent = new HashMap(64);
        this._sent = new ArrayList(4);
        this._finisher = new SendFinisher();
        this._pumper = new EventPumper(ctx, this);
        this._reader = new Reader(ctx);
        this._writer = new Writer(ctx);
        this._fastBid = new SharedBid(25);
        this._slowBid = new SharedBid(70);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void inboundEstablished(NTCPConnection con) {
        this._context.statManager().addRateData("ntcp.inboundEstablished", 1L, 0L);
        this.markReachable(con.getRemotePeer().calculateHash(), true);
        NTCPConnection old = null;
        Object object = this._conLock;
        synchronized (object) {
            old = this._conByIdent.put(con.getRemotePeer().calculateHash(), con);
        }
        if (old != null) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Old connection closed: " + old + " replaced by " + con);
            }
            this._context.statManager().addRateData("ntcp.inboundEstablishedDuplicate", old.getUptime(), 0L);
            old.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void outboundMessageReady() {
        OutNetMessage msg = this.getNextMessage();
        if (msg != null) {
            RouterIdentity ident = msg.getTarget().getIdentity();
            Hash ih = ident.calculateHash();
            NTCPConnection con = null;
            boolean isNew = false;
            Object object = this._conLock;
            synchronized (object) {
                con = (NTCPConnection)this._conByIdent.get(ih);
                if (con == null) {
                    isNew = true;
                    RouterAddress addr = msg.getTarget().getTargetAddress(STYLE);
                    if (addr != null) {
                        NTCPAddress naddr = new NTCPAddress(addr);
                        con = new NTCPConnection(this._context, this, ident, naddr);
                        if (this._log.shouldLog(10)) {
                            this._log.debug("Send on a new con: " + con + " at " + addr + " for " + ih.toBase64());
                        }
                        this._conByIdent.put(ih, con);
                    } else {
                        this._log.error("we bid on a peer who doesn't have an ntcp address? " + msg.getTarget());
                        return;
                    }
                }
            }
            if (isNew) {
                con.enqueueInfoMessage();
                con.send(msg);
                try {
                    SocketChannel channel = SocketChannel.open();
                    con.setChannel(channel);
                    channel.configureBlocking(false);
                    this._pumper.registerConnect(con);
                }
                catch (IOException ioe) {
                    if (this._log.shouldLog(40)) {
                        this._log.error("Error opening a channel", (Throwable)ioe);
                    }
                    this._context.statManager().addRateData("ntcp.outboundFailedIOEImmediate", 1L, 0L);
                    con.close();
                }
            } else {
                con.send(msg);
            }
        }
    }

    public void afterSend(OutNetMessage msg, boolean sendSuccessful, boolean allowRequeue, long msToSend) {
        super.afterSend(msg, sendSuccessful, allowRequeue, msToSend);
    }

    public TransportBid bid(RouterInfo toAddress, long dataSize) {
        Hash peer = toAddress.getIdentity().calculateHash();
        if (this._context.shitlist().isShitlisted(peer, STYLE)) {
            this._context.statManager().addRateData("ntcp.attemptShitlistedPeer", 1L, 0L);
            return null;
        }
        if (this.isUnreachable(peer)) {
            this._context.statManager().addRateData("ntcp.attemptUnreachablePeer", 1L, 0L);
            return null;
        }
        boolean established = this.isEstablished(toAddress.getIdentity());
        if (established) {
            if (this._log.shouldLog(10)) {
                this._log.debug("fast bid when trying to send to " + toAddress.getIdentity().calculateHash().toBase64() + " as its already established");
            }
            return this._fastBid;
        }
        RouterAddress addr = toAddress.getTargetAddress(STYLE);
        if (addr == null) {
            this.markUnreachable(peer);
            this._context.statManager().addRateData("ntcp.bidRejectedNoNTCPAddress", 1L, 0L);
            if (this._log.shouldLog(10)) {
                this._log.debug("no bid when trying to send to " + toAddress.getIdentity().calculateHash().toBase64() + " as they don't have an ntcp address");
            }
            return null;
        }
        NTCPAddress naddr = new NTCPAddress(addr);
        if (naddr.getPort() <= 0 || naddr.getHost() == null) {
            this._context.statManager().addRateData("ntcp.connectFailedInvalidPort", 1L, 0L);
            this.markUnreachable(peer);
            if (this._log.shouldLog(10)) {
                this._log.debug("no bid when trying to send to " + toAddress.getIdentity().calculateHash().toBase64() + " as they don't have a valid ntcp address");
            }
            return null;
        }
        if (!naddr.isPubliclyRoutable() && !this._context.getProperty("i2np.ntcp.allowLocal", "false").equals("true")) {
            this._context.statManager().addRateData("ntcp.bidRejectedLocalAddress", 1L, 0L);
            this.markUnreachable(peer);
            if (this._log.shouldLog(10)) {
                this._log.debug("no bid when trying to send to " + toAddress.getIdentity().calculateHash().toBase64() + " as they have a private ntcp address");
            }
            return null;
        }
        if (!this.allowConnection()) {
            if (this._log.shouldLog(30)) {
                this._log.warn("no bid when trying to send to " + toAddress.getIdentity().calculateHash().toBase64() + ", max connection limit reached");
            }
            return null;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("slow bid when trying to send to " + toAddress.getIdentity().calculateHash().toBase64());
        }
        return this._slowBid;
    }

    public boolean allowConnection() {
        int max = 500;
        String mc = this._context.getProperty("i2np.ntcp.maxConnections");
        if (mc != null) {
            try {
                max = Integer.parseInt(mc);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return this.countActivePeers() < max;
    }

    void sendComplete(OutNetMessage msg) {
        this._finisher.add(msg);
    }

    private boolean isEstablished(RouterIdentity peer) {
        return this.isEstablished(peer.calculateHash());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEstablished(Hash dest) {
        Object object = this._conLock;
        synchronized (object) {
            NTCPConnection con = (NTCPConnection)this._conByIdent.get(dest);
            return con != null && con.isEstablished() && !con.isClosed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBacklogged(Hash dest) {
        Object object = this._conLock;
        synchronized (object) {
            NTCPConnection con = (NTCPConnection)this._conByIdent.get(dest);
            return con != null && con.isEstablished() && con.tooBacklogged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeCon(NTCPConnection con) {
        NTCPConnection removed = null;
        Object object = this._conLock;
        synchronized (object) {
            RouterIdentity ident = con.getRemotePeer();
            if (ident != null) {
                removed = (NTCPConnection)this._conByIdent.remove(ident.calculateHash());
            }
        }
        if (removed != null && removed != con) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Multiple connections on remove, closing " + removed + " (already closed " + con + ")");
            }
            this._context.statManager().addRateData("ntcp.multipleCloseOnRemove", removed.getUptime(), 0L);
            removed.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countActivePeers() {
        Object object = this._conLock;
        synchronized (object) {
            return this._conByIdent.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countActiveSendPeers() {
        int active = 0;
        Object object = this._conLock;
        synchronized (object) {
            for (NTCPConnection con : this._conByIdent.values()) {
                if (con.getTimeSinceSend() > 60000L && con.getTimeSinceReceive() > 60000L) continue;
                ++active;
            }
        }
        return active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getClockSkews() {
        Vector peers = new Vector();
        Vector<Long> skews = new Vector<Long>();
        Object object = this._conLock;
        synchronized (object) {
            peers.addAll(this._conByIdent.values());
        }
        for (NTCPConnection con : peers) {
            skews.addElement(new Long(con.getClockSkew()));
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("NTCP transport returning " + skews.size() + " peer clock skews.");
        }
        return skews;
    }

    public RouterAddress startListening() {
        if (this._log.shouldLog(10)) {
            this._log.debug("Starting ntcp transport listening");
        }
        this._pumper.startPumping();
        this._reader.startReading(3);
        this._writer.startWriting(3);
        this.configureLocalAddress();
        return this.bindAddress();
    }

    public RouterAddress restartListening(RouterAddress addr) {
        if (this._log.shouldLog(10)) {
            this._log.debug("Restarting ntcp transport listening");
        }
        this._pumper.startPumping();
        this._reader.startReading(3);
        this._writer.startWriting(3);
        this._myAddress = new NTCPAddress(addr);
        return this.bindAddress();
    }

    private RouterAddress bindAddress() {
        if (this._myAddress != null) {
            try {
                ServerSocketChannel chan = ServerSocketChannel.open();
                chan.configureBlocking(false);
                InetSocketAddress addr = null;
                addr = new InetSocketAddress(this._myAddress.getPort());
                chan.socket().bind(addr);
                if (this._log.shouldLog(20)) {
                    this._log.info("Listening on " + addr);
                }
                this._pumper.register(chan);
            }
            catch (IOException ioe) {
                this._log.error("Error listening", (Throwable)ioe);
            }
        } else if (this._log.shouldLog(20)) {
            this._log.info("Outbound NTCP connections only - no listener configured");
        }
        if (this._myAddress != null) {
            RouterAddress rv = this._myAddress.toRouterAddress();
            if (rv != null) {
                this.replaceAddress(rv);
            }
            return rv;
        }
        return null;
    }

    Reader getReader() {
        return this._reader;
    }

    Writer getWriter() {
        return this._writer;
    }

    public String getStyle() {
        return STYLE;
    }

    EventPumper getPumper() {
        return this._pumper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void establishing(NTCPConnection con) {
        List list = this._establishing;
        synchronized (list) {
            this._establishing.add(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void expireTimedOut() {
        ArrayList<NTCPConnection> expired = null;
        List list = this._establishing;
        synchronized (list) {
            for (int i = 0; i < this._establishing.size(); ++i) {
                NTCPConnection con = (NTCPConnection)this._establishing.get(i);
                if (con.isClosed()) {
                    this._establishing.remove(i);
                    --i;
                    continue;
                }
                if (con.isEstablished()) {
                    this._establishing.remove(i);
                    --i;
                    continue;
                }
                if (con.getTimeSinceCreated() <= 10000L) continue;
                this._establishing.remove(i);
                --i;
                if (expired == null) {
                    expired = new ArrayList<NTCPConnection>(2);
                }
                expired.add(con);
            }
        }
        for (int i = 0; expired != null && i < expired.size(); ++i) {
            ((NTCPConnection)expired.get(i)).close();
        }
        if (expired != null && expired.size() > 0) {
            this._context.statManager().addRateData("ntcp.outboundEstablishFailed", (long)expired.size(), 0L);
        }
    }

    private void configureLocalAddress() {
        RouterContext ctx = this.getContext();
        if (ctx == null) {
            System.err.println("NIO transport has no context?");
        } else {
            RouterAddress ra = CommSystemFacadeImpl.createNTCPAddress(ctx);
            if (ra != null) {
                NTCPAddress addr = new NTCPAddress(ra);
                if (addr.getPort() <= 0) {
                    this._myAddress = null;
                    if (this._log.shouldLog(40)) {
                        this._log.error("NTCP address is outbound only, since the NTCP configuration is invalid");
                    }
                } else {
                    this._myAddress = addr;
                    this.replaceAddress(ra);
                    if (this._log.shouldLog(20)) {
                        this._log.info("NTCP address configured: " + this._myAddress);
                    }
                }
            } else if (this._log.shouldLog(20)) {
                this._log.info("NTCP address is outbound only");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopListening() {
        if (this._log.shouldLog(10)) {
            this._log.debug("Stopping ntcp transport");
        }
        this._pumper.stopPumping();
        this._writer.stopWriting();
        this._reader.stopReading();
        HashMap cons = null;
        Object object = this._conLock;
        synchronized (object) {
            cons = new HashMap(this._conByIdent);
            this._conByIdent.clear();
        }
        for (NTCPConnection con : cons.values()) {
            con.close();
        }
    }

    public void renderStatusHTML(java.io.Writer out, int sortFlags) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderStatusHTML(java.io.Writer out, String urlBase, int sortFlags) throws IOException {
        TreeSet peers = new TreeSet(this.getComparator(sortFlags));
        Object object = this._conLock;
        synchronized (object) {
            peers.addAll(this._conByIdent.values());
        }
        long offsetTotal = 0L;
        boolean bpsIn = false;
        boolean bpsOut = false;
        long uptimeMsTotal = 0L;
        long sendTotal = 0L;
        long recvTotal = 0L;
        boolean numPeers = false;
        int readingPeers = 0;
        int writingPeers = 0;
        float bpsSend = 0.0f;
        float bpsRecv = 0.0f;
        long totalUptime = 0L;
        long totalSend = 0L;
        long totalRecv = 0L;
        StringBuffer buf = new StringBuffer(512);
        buf.append("<b id=\"ntcpcon\">NTCP connections: ").append(peers.size()).append("</b><br />\n");
        buf.append("<table border=\"1\">\n");
        buf.append(" <tr><td><b><a href=\"#def.peer\">peer</a></b></td>");
        buf.append("     <td><b>dir</b></td>");
        buf.append("     <td align=\"right\"><b><a href=\"#def.idle\">idle</a></b></td>");
        buf.append("     <td align=\"right\"><b><a href=\"#def.rate\">in/out</a></b></td>");
        buf.append("     <td align=\"right\"><b><a href=\"#def.up\">up</a></b></td>");
        buf.append("     <td align=\"right\"><b><a href=\"#def.skew\">skew</a></b></td>");
        buf.append("     <td align=\"right\"><b><a href=\"#def.send\">send</a></b></td>");
        buf.append("     <td align=\"right\"><b><a href=\"#def.recv\">recv</a></b></td>");
        buf.append("     <td><b>out queue</b></td>");
        buf.append("     <td><b>backlogged?</b></td>");
        buf.append("     <td><b>reading?</b></td>");
        buf.append(" </tr>\n");
        out.write(buf.toString());
        buf.setLength(0);
        for (NTCPConnection con : peers) {
            String name = con.getRemotePeer().calculateHash().toBase64().substring(0, 6);
            buf.append("<tr><td><code><a href=\"netdb.jsp?r=").append(name).append("\">").append(name);
            buf.append("</code></td><td align=\"center\"><code>");
            if (con.isInbound()) {
                buf.append("in");
            } else {
                buf.append("out");
            }
            buf.append("</code></td><td align=\"right\"><code>");
            buf.append(con.getTimeSinceReceive() / 1000L);
            buf.append("s/").append(con.getTimeSinceSend() / 1000L);
            buf.append("s</code></td><td align=\"right\"><code>");
            if (con.getTimeSinceReceive() < 10000L) {
                buf.append(NTCPTransport.formatRate(con.getRecvRate() / 1024.0f));
                bpsRecv += con.getRecvRate();
            } else {
                buf.append(NTCPTransport.formatRate(0.0f));
            }
            buf.append("/");
            if (con.getTimeSinceSend() < 10000L) {
                buf.append(NTCPTransport.formatRate(con.getSendRate() / 1024.0f));
                bpsSend += con.getSendRate();
            } else {
                buf.append(NTCPTransport.formatRate(0.0f));
            }
            buf.append("KBps");
            buf.append("</code></td><td align=\"right\"><code>").append(DataHelper.formatDuration((long)con.getUptime()));
            totalUptime += con.getUptime();
            offsetTotal += con.getClockSkew();
            buf.append("</code></td><td align=\"right\"><code>").append(con.getClockSkew());
            buf.append("s</code></td><td align=\"right\"><code>").append(con.getMessagesSent());
            totalSend += con.getMessagesSent();
            buf.append("</code></td><td align=\"right\"><code>").append(con.getMessagesReceived());
            totalRecv += con.getMessagesReceived();
            long outQueue = con.getOutboundQueueSize();
            if (outQueue <= 0L) {
                buf.append("</code></td><td align=\"right\"><code>No messages");
            } else {
                buf.append("</code></td><td align=\"right\"><code>").append(outQueue).append(" message");
                if (outQueue > 1L) {
                    buf.append("s");
                }
                ++writingPeers;
            }
            buf.append("</code></td><td align=\"center\"><code>").append(con.getConsecutiveBacklog() > 0 ? "true" : "false");
            long readTime = con.getReadTime();
            if (readTime <= 0L) {
                buf.append("</code></td><td align=\"center\"><code>No");
            } else {
                buf.append("</code></td><td><code>For ").append(DataHelper.formatDuration((long)readTime));
                ++readingPeers;
            }
            buf.append("</code></td></tr>\n");
            out.write(buf.toString());
            buf.setLength(0);
        }
        if (peers.size() > 0) {
            buf.append("<tr><td colspan=\"11\"><hr /></td></tr>\n");
            buf.append("<tr><td>").append(peers.size()).append(" peers</td><td>&nbsp;</td><td>&nbsp;");
            buf.append("</td><td align=\"right\">").append(NTCPTransport.formatRate(bpsRecv / 1024.0f)).append("/").append(NTCPTransport.formatRate(bpsSend / 1024.0f)).append("KBps");
            buf.append("</td><td align=\"right\">").append(DataHelper.formatDuration((long)(totalUptime / (long)peers.size())));
            buf.append("</td><td align=\"right\">").append(peers.size() > 0 ? DataHelper.formatDuration((long)(offsetTotal * 1000L / (long)peers.size())) : "0ms");
            buf.append("</td><td align=\"right\">").append(totalSend).append("</td><td align=\"right\">").append(totalRecv);
            buf.append("</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;");
            buf.append("</td></tr>\n");
        }
        buf.append("</table>\n");
        buf.append("Peers currently reading I2NP messages: ").append(readingPeers).append("<br />\n");
        buf.append("Peers currently writing I2NP messages: ").append(writingPeers).append("<br />\n");
        out.write(buf.toString());
        buf.setLength(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String formatRate(float rate) {
        NumberFormat numberFormat = _rateFmt;
        synchronized (numberFormat) {
            return _rateFmt.format(rate);
        }
    }

    private Comparator getComparator(int sortFlags) {
        Comparator rv = null;
        switch (Math.abs(sortFlags)) {
            default: 
        }
        rv = AlphaComparator.instance();
        if (sortFlags < 0) {
            rv = new InverseComparator(rv);
        }
        return rv;
    }

    private class SharedBid
    extends TransportBid {
        public SharedBid(int ms) {
            this.setLatencyMs(ms);
        }

        public Transport getTransport() {
            return NTCPTransport.this;
        }

        public String toString() {
            return "NTCP bid @ " + this.getLatencyMs();
        }
    }

    private static class PeerComparator
    implements Comparator {
        private PeerComparator() {
        }

        public int compare(Object lhs, Object rhs) {
            if (lhs == null || rhs == null || !(lhs instanceof NTCPConnection) || !(rhs instanceof NTCPConnection)) {
                throw new IllegalArgumentException("rhs = " + rhs + " lhs = " + lhs);
            }
            return this.compare((NTCPConnection)lhs, (NTCPConnection)rhs);
        }

        protected int compare(NTCPConnection l, NTCPConnection r) {
            return l.getRemotePeer().calculateHash().toBase64().compareTo(r.getRemotePeer().calculateHash().toBase64());
        }
    }

    private static class InverseComparator
    implements Comparator {
        private Comparator _comp;

        public InverseComparator(Comparator comp) {
            this._comp = comp;
        }

        public int compare(Object lhs, Object rhs) {
            return -1 * this._comp.compare(lhs, rhs);
        }
    }

    private static class AlphaComparator
    extends PeerComparator {
        private static final AlphaComparator _instance = new AlphaComparator();

        private AlphaComparator() {
        }

        public static final AlphaComparator instance() {
            return _instance;
        }
    }

    private class SendFinisher
    implements SimpleTimer.TimedEvent {
        private SendFinisher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(OutNetMessage msg) {
            List list = NTCPTransport.this._sent;
            synchronized (list) {
                NTCPTransport.this._sent.add(msg);
            }
            SimpleTimer.getInstance().addEvent((SimpleTimer.TimedEvent)this, 0L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void timeReached() {
            int pending = 0;
            OutNetMessage msg = null;
            List list = NTCPTransport.this._sent;
            synchronized (list) {
                pending = NTCPTransport.this._sent.size() - 1;
                if (pending >= 0) {
                    msg = (OutNetMessage)NTCPTransport.this._sent.remove(0);
                }
            }
            if (msg != null) {
                NTCPTransport.this.afterSend(msg, true, false, msg.getSendTime());
            }
            if (pending > 0) {
                SimpleTimer.getInstance().addEvent((SimpleTimer.TimedEvent)this, 0L);
            }
        }
    }
}

