/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.i2p.crypto.DHSessionKeyBuilder;
import net.i2p.data.Base64;
import net.i2p.data.ByteArray;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.RouterIdentity;
import net.i2p.data.SessionKey;
import net.i2p.data.Signature;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.udp.RemoteHostId;
import net.i2p.router.transport.udp.UDPPacketReader;
import net.i2p.util.Log;

public class InboundEstablishState {
    private RouterContext _context;
    private Log _log;
    private byte[] _receivedX;
    private byte[] _bobIP;
    private int _bobPort;
    private DHSessionKeyBuilder _keyBuilder;
    private byte[] _sentY;
    private byte[] _aliceIP;
    private int _alicePort;
    private long _sentRelayTag;
    private long _sentSignedOnTime;
    private SessionKey _sessionKey;
    private SessionKey _macKey;
    private Signature _sentSignature;
    private byte[][] _receivedIdentity;
    private long _receivedSignedOnTime;
    private byte[] _receivedSignature;
    private boolean _verificationAttempted;
    private RouterIdentity _receivedConfirmedIdentity;
    private long _establishBegin;
    private long _lastReceive;
    private long _lastSend;
    private long _nextSend;
    private RemoteHostId _remoteHostId;
    private int _currentState;
    private boolean _complete;
    public static final int STATE_UNKNOWN = 0;
    public static final int STATE_REQUEST_RECEIVED = 1;
    public static final int STATE_CREATED_SENT = 2;
    public static final int STATE_CONFIRMED_PARTIALLY = 3;
    public static final int STATE_CONFIRMED_COMPLETELY = 4;
    public static final int STATE_FAILED = 5;

    public InboundEstablishState(RouterContext ctx, byte[] remoteIP, int remotePort, int localPort) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(InboundEstablishState.class);
        this._aliceIP = remoteIP;
        this._alicePort = remotePort;
        this._remoteHostId = new RemoteHostId(this._aliceIP, this._alicePort);
        this._bobPort = localPort;
        this._keyBuilder = null;
        this._verificationAttempted = false;
        this._complete = false;
        this._currentState = 0;
        this._establishBegin = ctx.clock().now();
    }

    public synchronized int getState() {
        return this._currentState;
    }

    public synchronized boolean complete() {
        boolean already = this._complete;
        this._complete = true;
        return already;
    }

    public synchronized void receiveSessionRequest(UDPPacketReader.SessionRequestReader req) {
        if (this._receivedX == null) {
            this._receivedX = new byte[256];
        }
        req.readX(this._receivedX, 0);
        if (this._bobIP == null) {
            this._bobIP = new byte[req.readIPSize()];
        }
        req.readIP(this._bobIP, 0);
        if (this._log.shouldLog(10)) {
            this._log.debug("Receive sessionRequest, BobIP = " + Base64.encode((byte[])this._bobIP));
        }
        if (this._currentState == 0) {
            this._currentState = 1;
        }
        this.packetReceived();
    }

    public synchronized boolean sessionRequestReceived() {
        return this._receivedX != null;
    }

    public synchronized byte[] getReceivedX() {
        return this._receivedX;
    }

    public synchronized byte[] getReceivedOurIP() {
        return this._bobIP;
    }

    public synchronized void generateSessionKey() throws DHSessionKeyBuilder.InvalidPublicParameterException {
        if (this._sessionKey != null) {
            return;
        }
        this._keyBuilder = new DHSessionKeyBuilder();
        this._keyBuilder.setPeerPublicValue(this._receivedX);
        this._sessionKey = this._keyBuilder.getSessionKey();
        ByteArray extra = this._keyBuilder.getExtraBytes();
        this._macKey = new SessionKey(new byte[32]);
        System.arraycopy(extra.getData(), 0, this._macKey.getData(), 0, 32);
        if (this._log.shouldLog(10)) {
            this._log.debug("Established inbound keys.  cipher: " + Base64.encode((byte[])this._sessionKey.getData()) + " mac: " + Base64.encode((byte[])this._macKey.getData()));
        }
    }

    public synchronized SessionKey getCipherKey() {
        return this._sessionKey;
    }

    public synchronized SessionKey getMACKey() {
        return this._macKey;
    }

    public synchronized byte[] getSentIP() {
        return this._aliceIP;
    }

    public synchronized int getSentPort() {
        return this._alicePort;
    }

    public synchronized byte[] getBobIP() {
        return this._bobIP;
    }

    public synchronized byte[] getSentY() {
        if (this._sentY == null) {
            this._sentY = this._keyBuilder.getMyPublicValueBytes();
        }
        return this._sentY;
    }

    public synchronized void fail() {
        this._currentState = 5;
    }

    public synchronized long getSentRelayTag() {
        return this._sentRelayTag;
    }

    public synchronized void setSentRelayTag(long tag) {
        this._sentRelayTag = tag;
    }

    public synchronized long getSentSignedOnTime() {
        return this._sentSignedOnTime;
    }

    public synchronized void prepareSessionCreated() {
        if (this._sentSignature == null) {
            this.signSessionCreated();
        }
    }

    public synchronized Signature getSentSignature() {
        return this._sentSignature;
    }

    private void signSessionCreated() {
        byte[] signed = new byte[512 + this._aliceIP.length + 2 + this._bobIP.length + 2 + 4 + 4];
        this._sentSignedOnTime = this._context.clock().now() / 1000L;
        int off = 0;
        System.arraycopy(this._receivedX, 0, signed, off, this._receivedX.length);
        this.getSentY();
        System.arraycopy(this._sentY, 0, signed, off += this._receivedX.length, this._sentY.length);
        System.arraycopy(this._aliceIP, 0, signed, off += this._sentY.length, this._aliceIP.length);
        DataHelper.toLong((byte[])signed, (int)(off += this._aliceIP.length), (int)2, (long)this._alicePort);
        System.arraycopy(this._bobIP, 0, signed, off += 2, this._bobIP.length);
        DataHelper.toLong((byte[])signed, (int)(off += this._bobIP.length), (int)2, (long)this._bobPort);
        DataHelper.toLong((byte[])signed, (int)(off += 2), (int)4, (long)this._sentRelayTag);
        DataHelper.toLong((byte[])signed, (int)(off += 4), (int)4, (long)this._sentSignedOnTime);
        this._sentSignature = this._context.dsa().sign(signed, this._context.keyManager().getSigningPrivateKey());
        if (this._log.shouldLog(10)) {
            StringBuffer buf = new StringBuffer(128);
            buf.append("Signing sessionCreated:");
            buf.append(" ReceivedX: ").append(Base64.encode((byte[])this._receivedX));
            buf.append(" SentY: ").append(Base64.encode((byte[])this._sentY));
            buf.append(" AliceIP: ").append(Base64.encode((byte[])this._aliceIP));
            buf.append(" AlicePort: ").append(this._alicePort);
            buf.append(" BobIP: ").append(Base64.encode((byte[])this._bobIP));
            buf.append(" BobPort: ").append(this._bobPort);
            buf.append(" RelayTag: ").append(this._sentRelayTag);
            buf.append(" SignedOn: ").append(this._sentSignedOnTime);
            buf.append(" signature: ").append(Base64.encode((byte[])this._sentSignature.getData()));
            this._log.debug(buf.toString());
        }
    }

    public synchronized void createdPacketSent() {
        this._lastSend = this._context.clock().now();
        if (this._currentState == 0 || this._currentState == 1) {
            this._currentState = 2;
        }
    }

    public synchronized long getLifetime() {
        return this._context.clock().now() - this._establishBegin;
    }

    public synchronized long getEstablishBeginTime() {
        return this._establishBegin;
    }

    public synchronized long getNextSendTime() {
        return this._nextSend;
    }

    public synchronized void setNextSendTime(long when) {
        this._nextSend = when;
    }

    public RemoteHostId getRemoteHostId() {
        return this._remoteHostId;
    }

    public synchronized void receiveSessionConfirmed(UDPPacketReader.SessionConfirmedReader conf) {
        int cur;
        if (this._receivedIdentity == null) {
            this._receivedIdentity = new byte[conf.readTotalFragmentNum()][];
        }
        if (this._receivedIdentity[cur = conf.readCurrentFragmentNum()] == null) {
            byte[] fragment = new byte[conf.readCurrentFragmentSize()];
            conf.readFragmentData(fragment, 0);
            this._receivedIdentity[cur] = fragment;
        }
        if (cur == this._receivedIdentity.length - 1) {
            this._receivedSignedOnTime = conf.readFinalFragmentSignedOnTime();
            if (this._receivedSignature == null) {
                this._receivedSignature = new byte[40];
            }
            conf.readFinalSignature(this._receivedSignature, 0);
        }
        if (this._currentState == 0 || this._currentState == 1 || this._currentState == 2) {
            this._currentState = this.confirmedFullyReceived() ? 4 : 3;
        }
        this.packetReceived();
    }

    public synchronized boolean confirmedFullyReceived() {
        if (this._receivedIdentity != null) {
            for (int i = 0; i < this._receivedIdentity.length; ++i) {
                if (this._receivedIdentity[i] != null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public synchronized RouterIdentity getConfirmedIdentity() {
        if (!this._verificationAttempted) {
            this.verifyIdentity();
            this._verificationAttempted = true;
        }
        return this._receivedConfirmedIdentity;
    }

    private synchronized void verifyIdentity() {
        block9: {
            int identSize = 0;
            for (int i = 0; i < this._receivedIdentity.length; ++i) {
                identSize += this._receivedIdentity[i].length;
            }
            byte[] ident = new byte[identSize];
            int off = 0;
            for (int i = 0; i < this._receivedIdentity.length; ++i) {
                int len = this._receivedIdentity[i].length;
                System.arraycopy(this._receivedIdentity[i], 0, ident, off, len);
                off += len;
            }
            ByteArrayInputStream in = new ByteArrayInputStream(ident);
            RouterIdentity peer = new RouterIdentity();
            try {
                peer.readBytes((InputStream)in);
                byte[] signed = new byte[512 + this._aliceIP.length + 2 + this._bobIP.length + 2 + 4 + 4];
                off = 0;
                System.arraycopy(this._receivedX, 0, signed, off, this._receivedX.length);
                this.getSentY();
                System.arraycopy(this._sentY, 0, signed, off += this._receivedX.length, this._sentY.length);
                System.arraycopy(this._aliceIP, 0, signed, off += this._sentY.length, this._aliceIP.length);
                DataHelper.toLong((byte[])signed, (int)(off += this._aliceIP.length), (int)2, (long)this._alicePort);
                System.arraycopy(this._bobIP, 0, signed, off += 2, this._bobIP.length);
                DataHelper.toLong((byte[])signed, (int)(off += this._bobIP.length), (int)2, (long)this._bobPort);
                DataHelper.toLong((byte[])signed, (int)(off += 2), (int)4, (long)this._sentRelayTag);
                DataHelper.toLong((byte[])signed, (int)(off += 4), (int)4, (long)this._receivedSignedOnTime);
                Signature sig = new Signature(this._receivedSignature);
                boolean ok = this._context.dsa().verifySignature(sig, signed, peer.getSigningPublicKey());
                if (ok) {
                    this._receivedConfirmedIdentity = peer;
                } else if (this._log.shouldLog(30)) {
                    this._log.warn("Signature failed from " + peer);
                }
            }
            catch (DataFormatException dfe) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Improperly formatted yet fully received ident", (Throwable)dfe);
                }
            }
            catch (IOException ioe) {
                if (!this._log.shouldLog(30)) break block9;
                this._log.warn("Improperly formatted yet fully received ident", (Throwable)ioe);
            }
        }
    }

    private void packetReceived() {
        this._nextSend = this._lastReceive = this._context.clock().now();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(128);
        buf.append(super.toString());
        if (this._receivedX != null) {
            buf.append(" ReceivedX: ").append(Base64.encode((byte[])this._receivedX, (int)0, (int)4));
        }
        if (this._sentY != null) {
            buf.append(" SentY: ").append(Base64.encode((byte[])this._sentY, (int)0, (int)4));
        }
        if (this._aliceIP != null) {
            buf.append(" AliceIP: ").append(Base64.encode((byte[])this._aliceIP));
        }
        buf.append(" AlicePort: ").append(this._alicePort);
        if (this._bobIP != null) {
            buf.append(" BobIP: ").append(Base64.encode((byte[])this._bobIP));
        }
        buf.append(" BobPort: ").append(this._bobPort);
        buf.append(" RelayTag: ").append(this._sentRelayTag);
        buf.append(" SignedOn: ").append(this._sentSignedOnTime);
        buf.append(" state: ").append(this._currentState);
        return buf.toString();
    }
}

