/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.udp.UDPPacket;
import net.i2p.router.transport.udp.UDPReceiver;
import net.i2p.router.transport.udp.UDPSender;
import net.i2p.router.transport.udp.UDPTransport;
import net.i2p.util.Log;

public class UDPEndpoint {
    private RouterContext _context;
    private Log _log;
    private int _listenPort;
    private UDPTransport _transport;
    private UDPSender _sender;
    private UDPReceiver _receiver;
    private DatagramSocket _socket;
    private InetAddress _bindAddress;

    public UDPEndpoint(RouterContext ctx, UDPTransport transport, int listenPort, InetAddress bindAddress) throws SocketException {
        this._context = ctx;
        this._log = ctx.logManager().getLog(UDPEndpoint.class);
        this._transport = transport;
        this._bindAddress = bindAddress;
        this._listenPort = listenPort;
    }

    public void startup() {
        if (this._log.shouldLog(10)) {
            this._log.debug("Starting up the UDP endpoint");
        }
        this.shutdown();
        try {
            this._socket = this._bindAddress == null ? new DatagramSocket(this._listenPort) : new DatagramSocket(this._listenPort, this._bindAddress);
            this._sender = new UDPSender(this._context, this._socket, "UDPSend on " + this._listenPort);
            this._receiver = new UDPReceiver(this._context, this._transport, this._socket, "UDPReceive on " + this._listenPort);
            this._sender.startup();
            this._receiver.startup();
        }
        catch (SocketException se) {
            this._transport.setReachabilityStatus((short)3);
            this._log.log(50, "Unable to bind on port " + this._listenPort, (Throwable)se);
        }
    }

    public void shutdown() {
        if (this._sender != null) {
            this._sender.shutdown();
            this._receiver.shutdown();
        }
        if (this._socket != null) {
            this._socket.close();
        }
    }

    public void setListenPort(int newPort) {
        this._listenPort = newPort;
    }

    public void updateListenPort(int newPort) {
        block3: {
            if (newPort == this._listenPort) {
                return;
            }
            try {
                this._socket = this._bindAddress == null ? new DatagramSocket(this._listenPort) : new DatagramSocket(this._listenPort, this._bindAddress);
                this._sender.updateListeningPort(this._socket, newPort);
                this._receiver.updateListeningPort(this._socket, newPort);
                this._listenPort = newPort;
            }
            catch (SocketException se) {
                if (!this._log.shouldLog(40)) break block3;
                this._log.error("Unable to bind on " + this._listenPort);
            }
        }
    }

    public int getListenPort() {
        return this._listenPort;
    }

    public UDPSender getSender() {
        return this._sender;
    }

    public int send(UDPPacket packet) {
        if (this._sender == null) {
            return 0;
        }
        return this._sender.add(packet);
    }

    public UDPPacket receive() {
        if (this._receiver == null) {
            return null;
        }
        return this._receiver.receiveNext();
    }
}

