/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.io.IOException;
import java.net.DatagramSocket;
import java.util.ArrayList;
import java.util.List;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.FIFOBandwidthLimiter;
import net.i2p.router.transport.udp.RemoteHostId;
import net.i2p.router.transport.udp.UDPPacket;
import net.i2p.router.transport.udp.UDPTransport;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer;

public class UDPReceiver {
    private RouterContext _context;
    private Log _log;
    private DatagramSocket _socket;
    private String _name;
    private List _inboundQueue;
    private boolean _keepRunning;
    private Runner _runner;
    private UDPTransport _transport;
    private static int __id;
    private int _id;
    private static final long MAX_QUEUE_PERIOD = 2000L;
    private static int ARTIFICIAL_DROP_PROBABILITY;
    private static final int ARTIFICIAL_DELAY = 0;
    private static final int ARTIFICIAL_DELAY_BASE = 0;

    public UDPReceiver(RouterContext ctx, UDPTransport transport, DatagramSocket socket, String name) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(UDPReceiver.class);
        ++this._id;
        this._name = name;
        this._inboundQueue = new ArrayList(128);
        this._socket = socket;
        this._transport = transport;
        this._runner = new Runner();
        this._context.statManager().createRateStat("udp.receivePacketSize", "How large packets received are", "udp", new long[]{60000L, 600000L, 3600000L});
        this._context.statManager().createRateStat("udp.receiveRemaining", "How many packets are left sitting on the receiver's queue", "udp", new long[]{60000L, 600000L, 3600000L});
        this._context.statManager().createRateStat("udp.droppedInbound", "How many packet are queued up but not yet received when we drop", "udp", new long[]{60000L, 600000L, 3600000L});
        this._context.statManager().createRateStat("udp.droppedInboundProbabalistically", "How many packet we drop probabalistically (to simulate failures)", "udp", new long[]{60000L, 300000L, 600000L, 3600000L});
        this._context.statManager().createRateStat("udp.acceptedInboundProbabalistically", "How many packet we accept probabalistically (to simulate failures)", "udp", new long[]{60000L, 300000L, 600000L, 3600000L});
        this._context.statManager().createRateStat("udp.receiveHolePunch", "How often we receive a NAT hole punch", "udp", new long[]{60000L, 300000L, 600000L, 3600000L});
        this._context.statManager().createRateStat("udp.ignorePacketFromDroplist", "Packet lifetime for those dropped on the drop list", "udp", new long[]{60000L, 600000L, 3600000L});
    }

    public void startup() {
        this.adjustDropProbability();
        this._keepRunning = true;
        I2PThread t = new I2PThread((Runnable)this._runner, this._name + "." + this._id);
        t.setDaemon(true);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this._keepRunning = false;
        List list = this._inboundQueue;
        synchronized (list) {
            this._inboundQueue.clear();
            this._inboundQueue.notifyAll();
        }
    }

    private void adjustDropProbability() {
        String p = this._context.getProperty("i2np.udp.dropProbability");
        if (p != null) {
            try {
                ARTIFICIAL_DROP_PROBABILITY = Integer.parseInt(p);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (ARTIFICIAL_DROP_PROBABILITY < 0) {
                ARTIFICIAL_DROP_PROBABILITY = 0;
            }
        }
    }

    public DatagramSocket updateListeningPort(DatagramSocket socket, int newPort) {
        return this._runner.updateListeningPort(socket, newPort);
    }

    private int receive(UDPPacket packet) {
        if (ARTIFICIAL_DROP_PROBABILITY > 0) {
            int v = this._context.random().nextInt(100);
            if (v <= ARTIFICIAL_DROP_PROBABILITY) {
                if (this._log.shouldLog(40)) {
                    this._log.error("Drop with v=" + v + " p=" + ARTIFICIAL_DROP_PROBABILITY + " packet size: " + packet.getPacket().getLength() + ": " + packet);
                }
                this._context.statManager().addRateData("udp.droppedInboundProbabalistically", 1L, 0L);
                return -1;
            }
            this._context.statManager().addRateData("udp.acceptedInboundProbabalistically", 1L, 0L);
        }
        return this.doReceive(packet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int doReceive(UDPPacket packet) {
        RemoteHostId from;
        if (this._log.shouldLog(20)) {
            this._log.info("Received: " + packet);
        }
        if (this._transport.isInDropList(from = packet.getRemoteHost())) {
            if (this._log.shouldLog(20)) {
                this._log.info("Ignoring packet from the drop-listed peer: " + from);
            }
            this._context.statManager().addRateData("udp.ignorePacketFromDroplist", packet.getLifetime(), 0L);
            packet.release();
            return 0;
        }
        packet.enqueue();
        boolean rejected = false;
        int queueSize = 0;
        long headPeriod = 0L;
        List list = this._inboundQueue;
        synchronized (list) {
            queueSize = this._inboundQueue.size();
            if (queueSize > 0 && (headPeriod = ((UDPPacket)this._inboundQueue.get(0)).getLifetime()) > 2000L) {
                rejected = true;
                this._inboundQueue.notifyAll();
            }
            if (!rejected) {
                this._inboundQueue.add(packet);
                this._inboundQueue.notifyAll();
                return queueSize + 1;
            }
        }
        packet.release();
        this._context.statManager().addRateData("udp.droppedInbound", (long)queueSize, headPeriod);
        if (this._log.shouldLog(30)) {
            StringBuffer msg = new StringBuffer();
            msg.append("Dropping inbound packet with ");
            msg.append(queueSize);
            msg.append(" queued for ");
            msg.append(headPeriod);
            if (this._transport != null) {
                msg.append(" packet handlers: ").append(this._transport.getPacketHandlerStatus());
            }
            this._log.warn(msg.toString());
        }
        return queueSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UDPPacket receiveNext() {
        UDPPacket rv = null;
        int remaining = 0;
        while (this._keepRunning) {
            List list = this._inboundQueue;
            synchronized (list) {
                if (this._inboundQueue.size() <= 0) {
                    try {
                        this._inboundQueue.wait();
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                }
                if (this._inboundQueue.size() > 0) {
                    rv = (UDPPacket)this._inboundQueue.remove(0);
                    remaining = this._inboundQueue.size();
                    if (remaining > 0) {
                        this._inboundQueue.notifyAll();
                    }
                    break;
                }
            }
        }
        this._context.statManager().addRateData("udp.receiveRemaining", (long)remaining, 0L);
        return rv;
    }

    static {
        ARTIFICIAL_DROP_PROBABILITY = 0;
    }

    private class Runner
    implements Runnable {
        private boolean _socketChanged;

        private Runner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this._socketChanged = false;
            FIFOBandwidthLimiter.Request req = UDPReceiver.this._context.bandwidthLimiter().createRequest();
            while (UDPReceiver.this._keepRunning) {
                if (this._socketChanged) {
                    Thread.currentThread().setName(UDPReceiver.this._name + "." + UDPReceiver.this._id);
                    this._socketChanged = false;
                }
                UDPPacket packet = UDPPacket.acquire(UDPReceiver.this._context, true);
                if (UDPReceiver.this._log.shouldLog(10)) {
                    UDPReceiver.this._log.debug("Before throttling receive");
                }
                while (!UDPReceiver.this._context.throttle().acceptNetworkMessage()) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException ie) {}
                }
                try {
                    if (UDPReceiver.this._log.shouldLog(20)) {
                        UDPReceiver.this._log.info("Before blocking socket.receive on " + System.identityHashCode(packet));
                    }
                    Runner ie = this;
                    synchronized (ie) {
                        UDPReceiver.this._socket.receive(packet.getPacket());
                    }
                    int size = packet.getPacket().getLength();
                    if (UDPReceiver.this._log.shouldLog(20)) {
                        UDPReceiver.this._log.info("After blocking socket.receive: packet is " + size + " bytes on " + System.identityHashCode(packet));
                    }
                    packet.resetBegin();
                    if (size > 0) {
                        req = UDPReceiver.this._context.bandwidthLimiter().requestInbound(size, "UDP receiver");
                        while (req.getPendingInboundRequested() > 0) {
                            req.waitForNextAllocation();
                        }
                        int queued = UDPReceiver.this.receive(packet);
                        UDPReceiver.this._context.statManager().addRateData("udp.receivePacketSize", (long)size, (long)queued);
                        continue;
                    }
                    UDPReceiver.this._context.statManager().addRateData("udp.receiveHolePunch", 1L, 0L);
                    if (!UDPReceiver.this._log.shouldLog(20)) continue;
                    UDPReceiver.this._log.info("Received a 0 byte udp packet from " + packet.getPacket().getAddress() + ":" + packet.getPacket().getPort());
                }
                catch (IOException ioe) {
                    if (this._socketChanged) {
                        if (UDPReceiver.this._log.shouldLog(20)) {
                            UDPReceiver.this._log.info("Changing ports...");
                        }
                    } else if (UDPReceiver.this._log.shouldLog(30)) {
                        UDPReceiver.this._log.warn("Error receiving", (Throwable)ioe);
                    }
                    packet.release();
                }
            }
            if (UDPReceiver.this._log.shouldLog(10)) {
                UDPReceiver.this._log.debug("Stop receiving...");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DatagramSocket updateListeningPort(DatagramSocket socket, int newPort) {
            UDPReceiver.this._name = "UDPReceive on " + newPort;
            DatagramSocket old = null;
            Runner runner = this;
            synchronized (runner) {
                old = UDPReceiver.this._socket;
                UDPReceiver.this._socket = socket;
            }
            this._socketChanged = true;
            old.close();
            return old;
        }
    }

    private class ArtificiallyDelayedReceive
    implements SimpleTimer.TimedEvent {
        private UDPPacket _packet;

        public ArtificiallyDelayedReceive(UDPPacket packet) {
            this._packet = packet;
        }

        public void timeReached() {
            UDPReceiver.this.doReceive(this._packet);
        }
    }
}

