/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.io.IOException;
import java.io.Writer;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.TreeSet;
import java.util.Vector;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.RouterAddress;
import net.i2p.data.RouterIdentity;
import net.i2p.data.RouterInfo;
import net.i2p.data.SessionKey;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.Transport;
import net.i2p.router.transport.TransportBid;
import net.i2p.router.transport.TransportImpl;
import net.i2p.router.transport.udp.EstablishmentManager;
import net.i2p.router.transport.udp.InboundMessageFragments;
import net.i2p.router.transport.udp.IntroductionManager;
import net.i2p.router.transport.udp.MessageQueue;
import net.i2p.router.transport.udp.OutboundMessageFragments;
import net.i2p.router.transport.udp.OutboundMessageState;
import net.i2p.router.transport.udp.OutboundRefiller;
import net.i2p.router.transport.udp.PacketHandler;
import net.i2p.router.transport.udp.PacketPusher;
import net.i2p.router.transport.udp.PeerState;
import net.i2p.router.transport.udp.PeerTestManager;
import net.i2p.router.transport.udp.RemoteHostId;
import net.i2p.router.transport.udp.TimedWeightedPriorityMessageQueue;
import net.i2p.router.transport.udp.UDPAddress;
import net.i2p.router.transport.udp.UDPEndpoint;
import net.i2p.router.transport.udp.UDPFlooder;
import net.i2p.router.transport.udp.UDPPacket;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer;

public class UDPTransport
extends TransportImpl
implements TimedWeightedPriorityMessageQueue.FailedListener {
    private RouterContext _context;
    private Log _log;
    private UDPEndpoint _endpoint;
    private Map _peersByIdent;
    private Map _peersByRemoteHost;
    private PacketHandler _handler;
    private EstablishmentManager _establisher;
    private MessageQueue _outboundMessages;
    private OutboundMessageFragments _fragments;
    private OutboundMessageFragments.ActiveThrottle _activeThrottle;
    private OutboundRefiller _refiller;
    private PacketPusher _pusher;
    private InboundMessageFragments _inboundFragments;
    private UDPFlooder _flooder;
    private PeerTestManager _testManager;
    private IntroductionManager _introManager;
    private ExpirePeerEvent _expireEvent;
    private PeerTestEvent _testEvent;
    private short _reachabilityStatus;
    private long _reachabilityStatusLastUpdated;
    private long _introducersSelectedOn;
    private long _lastInboundReceivedOn;
    private boolean _needsRebuild;
    private RouterAddress _externalAddress;
    private int _externalListenPort;
    private InetAddress _externalListenHost;
    private SessionKey _introKey;
    private TransportBid _fastBid;
    private TransportBid _slowBid;
    private TransportBid _slowestBid;
    private TransportBid _fastPreferredBid;
    private TransportBid _slowPreferredBid;
    private List _dropList;
    private static final int DROPLIST_PERIOD = 600000;
    private static final int MAX_DROPLIST_SIZE = 256;
    public static final String STYLE = "SSU";
    public static final String PROP_INTERNAL_PORT = "i2np.udp.internalPort";
    public static final String PROP_EXTERNAL_HOST = "i2np.udp.host";
    public static final String PROP_EXTERNAL_PORT = "i2np.udp.port";
    public static final String PROP_PREFER_UDP = "i2np.udp.preferred";
    private static final String DEFAULT_PREFER_UDP = "false";
    public static final String PROP_FIXED_PORT = "i2np.udp.fixedPort";
    private static final String DEFAULT_FIXED_PORT = "true";
    public static final String PROP_FORCE_INTRODUCERS = "i2np.udp.forceIntroducers";
    public static final String PROP_ALLOW_DIRECT = "i2np.udp.allowDirect";
    public static final String PROP_BIND_INTERFACE = "i2np.udp.bindInterface";
    public static final int PUBLIC_RELAY_COUNT = 3;
    private static final int[] PRIORITY_LIMITS = new int[]{100, 200, 300, 400, 500, 1000};
    private static final int[] PRIORITY_WEIGHT = new int[]{1, 1, 1, 1, 1, 2};
    private static final boolean SHOULD_FLOOD_PEERS = false;
    private static final int MAX_CONSECUTIVE_FAILED = 5;
    private static final int TEST_FREQUENCY = 780000;
    private static final int ALLOW_IP_CHANGE_INTERVAL = 120000;
    public static final int EXPIRE_TIMEOUT = 1800000;
    private static final int MAX_IDLE_TIME = 1800000;
    private static final int DROP_INACTIVITY_TIME = 60000;
    private static UDPTransport __instance;
    private static final int FLAG_ALPHA = 0;
    private static final int FLAG_IDLE_IN = 1;
    private static final int FLAG_IDLE_OUT = 2;
    private static final int FLAG_RATE_IN = 3;
    private static final int FLAG_RATE_OUT = 4;
    private static final int FLAG_SKEW = 5;
    private static final int FLAG_CWND = 6;
    private static final int FLAG_SSTHRESH = 7;
    private static final int FLAG_RTT = 8;
    private static final int FLAG_DEV = 9;
    private static final int FLAG_RTO = 10;
    private static final int FLAG_MTU = 11;
    private static final int FLAG_SEND = 12;
    private static final int FLAG_RECV = 13;
    private static final int FLAG_RESEND = 14;
    private static final int FLAG_DUP = 15;
    private static final int FLAG_UPTIME = 16;
    private static final DecimalFormat _fmt;
    private static final DecimalFormat _pctFmt;
    private static final String KEY = "<tr><td colspan=\"15\" valign=\"top\" align=\"left\"><b id=\"def.peer\">peer</b>: the remote peer (&lt; inbound, &gt; outbound, v means they offer to introduce us, ^ means we offer to introduce them)<br />\n<b id=\"def.idle\">idle</b>: the idle time is how long since a packet has been received or sent<br />\n<b id=\"def.rate\">in/out</b>: the rates show a smoothed inbound and outbound transfer rate (KBytes per second)<br />\n<b id=\"def.up\">up</b>: the uptime is how long ago this session was established<br />\n<b id=\"def.skew\">skew</b>: the skew says how far off the other user's clock is, relative to your own<br />\n<b id=\"def.cwnd\">cwnd</b>: the congestion window is how many bytes in 'in flight' you can send w/out an acknowledgement / <br />\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; the number of currently active messages being sent /<br />\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; the maximum number of concurrent messages to send /<br />\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; the number of consecutive sends which were blocked due to throws message window size<br />\n<b id=\"def.ssthresh\">ssthresh</b>: the slow start threshold help make sure the cwnd doesn't grow too fast<br />\n<b id=\"def.rtt\">rtt</b>: the round trip time is how long it takes to get an acknowledgement of a packet<br />\n<b id=\"def.dev\">dev</b>: the standard deviation of the round trip time, to help control the retransmit timeout<br />\n<b id=\"def.rto\">rto</b>: the retransmit timeout controls how frequently an unacknowledged packet will be retransmitted<br />\n<b id=\"def.mtu\">mtu</b>: current sending packet size / estimated receiving packet size<br />\n<b id=\"def.send\">send</b>: the number of packets sent to the peer<br />\n<b id=\"def.recv\">recv</b>: the number of packets received from the peer<br />\n<b id=\"def.resent\">resent</b>: the number of packets retransmitted to the peer<br />\n<b id=\"def.dupRecv\">dupRecv</b>: the number of duplicate packets received from the peer</td></tr>\n";
    private static final long STATUS_GRACE_PERIOD = 300000L;
    private static final String PROP_REACHABILITY_STATUS_OVERRIDE = "i2np.udp.status";
    private static final String PROP_SHOULD_TEST = "i2np.udp.shouldTest";
    private static final String[] BADIPS;
    private static final String[] GOODIPS;

    public UDPTransport(RouterContext ctx) {
        super(ctx);
        this._context = ctx;
        this._log = ctx.logManager().getLog(UDPTransport.class);
        this._peersByIdent = new HashMap(128);
        this._peersByRemoteHost = new HashMap(128);
        this._dropList = new ArrayList(256);
        this._endpoint = null;
        TimedWeightedPriorityMessageQueue mq = new TimedWeightedPriorityMessageQueue(ctx, PRIORITY_LIMITS, PRIORITY_WEIGHT, this);
        this._outboundMessages = mq;
        this._activeThrottle = mq;
        this._fastBid = new SharedBid(50);
        this._slowBid = new SharedBid(65);
        this._fastPreferredBid = new SharedBid(15);
        this._slowPreferredBid = new SharedBid(20);
        this._slowestBid = new SharedBid(1000);
        this._fragments = new OutboundMessageFragments(this._context, this, this._activeThrottle);
        this._inboundFragments = new InboundMessageFragments(this._context, this._fragments, this);
        this._flooder = new UDPFlooder(this._context, this);
        this._expireEvent = new ExpirePeerEvent();
        this._testEvent = new PeerTestEvent();
        this._reachabilityStatus = (short)4;
        this._introManager = new IntroductionManager(this._context, this);
        this._introducersSelectedOn = -1L;
        this._lastInboundReceivedOn = -1L;
        this._needsRebuild = true;
        this._context.statManager().createRateStat("udp.alreadyConnected", "What is the lifetime of a reestablished session", "udp", new long[]{60000L, 600000L, 3600000L, 86400000L});
        this._context.statManager().createRateStat("udp.droppedPeer", "How long ago did we receive from a dropped peer (duration == session lifetime", "udp", new long[]{60000L, 3600000L, 86400000L});
        this._context.statManager().createRateStat("udp.droppedPeerInactive", "How long ago did we receive from a dropped peer (duration == session lifetime)", "udp", new long[]{60000L, 3600000L, 86400000L});
        this._context.statManager().createRateStat("udp.statusOK", "How many times the peer test returned OK", "udp", new long[]{300000L, 1200000L, 3600000L, 86400000L});
        this._context.statManager().createRateStat("udp.statusDifferent", "How many times the peer test returned different IP/ports", "udp", new long[]{300000L, 1200000L, 3600000L, 86400000L});
        this._context.statManager().createRateStat("udp.statusReject", "How many times the peer test returned reject unsolicited", "udp", new long[]{300000L, 1200000L, 3600000L, 86400000L});
        this._context.statManager().createRateStat("udp.statusUnknown", "How many times the peer test returned an unknown result", "udp", new long[]{300000L, 1200000L, 3600000L, 86400000L});
        this._context.statManager().createRateStat("udp.addressTestInsteadOfUpdate", "How many times we fire off a peer test of ourselves instead of adjusting our own reachable address?", "udp", new long[]{60000L, 1200000L, 3600000L, 86400000L});
        this._context.statManager().createRateStat("udp.addressUpdated", "How many times we adjust our own reachable IP address", "udp", new long[]{60000L, 1200000L, 3600000L, 86400000L});
        this._context.statManager().createRateStat("udp.proactiveReestablish", "How long a session was idle for when we proactively reestablished it", "udp", new long[]{60000L, 1200000L, 3600000L, 86400000L});
        this._context.statManager().createRateStat("udp.dropPeerDroplist", "How many peers currently have their packets dropped outright when a new peer is added to the list?", "udp", new long[]{60000L, 1200000L});
        this._context.statManager().createRateStat("udp.dropPeerConsecutiveFailures", "How many consecutive failed sends to a peer did we attempt before giving up and reestablishing a new session (lifetime is inactivity perood)", "udp", new long[]{60000L, 600000L});
        __instance = this;
    }

    public void startup() {
        if (this._fragments != null) {
            this._fragments.shutdown();
        }
        if (this._pusher != null) {
            this._pusher.shutdown();
        }
        if (this._handler != null) {
            this._handler.shutdown();
        }
        if (this._endpoint != null) {
            this._endpoint.shutdown();
        }
        if (this._establisher != null) {
            this._establisher.shutdown();
        }
        if (this._refiller != null) {
            this._refiller.shutdown();
        }
        if (this._inboundFragments != null) {
            this._inboundFragments.shutdown();
        }
        if (this._flooder != null) {
            this._flooder.shutdown();
        }
        this._introManager.reset();
        this._introKey = new SessionKey(new byte[32]);
        System.arraycopy(this._context.routerHash().getData(), 0, this._introKey.getData(), 0, 32);
        this.rebuildExternalAddress();
        int port = -1;
        if (this._externalListenPort <= 0) {
            block29: {
                String portStr = this._context.getProperty(PROP_INTERNAL_PORT);
                if (portStr != null) {
                    try {
                        port = Integer.parseInt(portStr);
                    }
                    catch (NumberFormatException nfe) {
                        if (!this._log.shouldLog(40)) break block29;
                        this._log.error("Invalid port specified [" + portStr + "]");
                    }
                }
            }
            if (port <= 0) {
                port = 8887;
                if (this._log.shouldLog(20)) {
                    this._log.info("Selecting an arbitrary port to bind to: " + port);
                }
                this._context.router().setConfigSetting(PROP_INTERNAL_PORT, port + "");
            }
            this._context.router().setConfigSetting(PROP_EXTERNAL_PORT, port + "");
            this._context.router().saveConfig();
        } else {
            port = this._externalListenPort;
            if (this._log.shouldLog(20)) {
                this._log.info("Binding to the explicitly specified external port: " + port);
            }
        }
        if (this._endpoint == null) {
            String bindTo = this._context.getProperty(PROP_BIND_INTERFACE);
            InetAddress bindToAddr = null;
            if (bindTo != null) {
                try {
                    bindToAddr = InetAddress.getByName(bindTo);
                }
                catch (UnknownHostException uhe) {
                    if (this._log.shouldLog(40)) {
                        this._log.error("Invalid SSU bind interface specified [" + bindTo + "]", (Throwable)uhe);
                    }
                    bindToAddr = null;
                }
            }
            try {
                this._endpoint = new UDPEndpoint(this._context, this, port, bindToAddr);
            }
            catch (SocketException se) {
                if (this._log.shouldLog(50)) {
                    this._log.log(50, "Unable to listen on the UDP port (" + port + ")", (Throwable)se);
                }
                return;
            }
        }
        this._endpoint.setListenPort(port);
        if (this._establisher == null) {
            this._establisher = new EstablishmentManager(this._context, this);
        }
        if (this._testManager == null) {
            this._testManager = new PeerTestManager(this._context, this);
        }
        if (this._handler == null) {
            this._handler = new PacketHandler(this._context, this, this._endpoint, this._establisher, this._inboundFragments, this._testManager, this._introManager);
        }
        if (this._refiller == null) {
            this._refiller = new OutboundRefiller(this._context, this._fragments, this._outboundMessages);
        }
        if (this._flooder == null) {
            this._flooder = new UDPFlooder(this._context, this);
        }
        this._endpoint.startup();
        this._establisher.startup();
        this._handler.startup();
        this._fragments.startup();
        this._inboundFragments.startup();
        this._pusher = new PacketPusher(this._context, this._fragments, this._endpoint.getSender());
        this._pusher.startup();
        this._refiller.startup();
        this._flooder.startup();
        this._expireEvent.setIsAlive(true);
        this._testEvent.setIsAlive(true);
        SimpleTimer.getInstance().addEvent((SimpleTimer.TimedEvent)this._testEvent, 10000L);
    }

    public void shutdown() {
        if (this._endpoint != null) {
            this._endpoint.shutdown();
        }
        if (this._flooder != null) {
            this._flooder.shutdown();
        }
        if (this._refiller != null) {
            this._refiller.shutdown();
        }
        if (this._handler != null) {
            this._handler.shutdown();
        }
        if (this._fragments != null) {
            this._fragments.shutdown();
        }
        if (this._pusher != null) {
            this._pusher.shutdown();
        }
        if (this._establisher != null) {
            this._establisher.shutdown();
        }
        if (this._inboundFragments != null) {
            this._inboundFragments.shutdown();
        }
        this._expireEvent.setIsAlive(false);
        this._testEvent.setIsAlive(false);
    }

    public SessionKey getIntroKey() {
        return this._introKey;
    }

    public int getLocalPort() {
        return this._externalListenPort;
    }

    public InetAddress getLocalAddress() {
        return this._externalListenHost;
    }

    public int getExternalPort() {
        return this._externalListenPort;
    }

    void inboundConnectionReceived() {
        this._lastInboundReceivedOn = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void externalAddressReceived(Hash from, byte[] ourIP, int ourPort) {
        boolean inboundRecent;
        boolean isValid = this.isValid(ourIP);
        boolean explicitSpecified = this.explicitAddressSpecified();
        boolean bl = inboundRecent = this._lastInboundReceivedOn + 120000L > System.currentTimeMillis();
        if (this._log.shouldLog(20)) {
            this._log.info("External address received: " + RemoteHostId.toString(ourIP) + ":" + ourPort + " from " + from.toBase64() + ", isValid? " + isValid + ", explicitSpecified? " + explicitSpecified + ", receivedInboundRecent? " + inboundRecent + " status " + this._reachabilityStatus);
        }
        if (explicitSpecified) {
            return;
        }
        boolean fixedPort = this.getIsPortFixed();
        boolean updated = false;
        boolean fireTest = false;
        if (!isValid) {
            if (this._log.shouldLog(40)) {
                this._log.error("The router " + from.toBase64() + " told us we have an invalid IP - " + RemoteHostId.toString(ourIP) + ".  Lets throw tomatoes at them");
            }
            this.markUnreachable(from);
            return;
        }
        if (inboundRecent && this._externalListenPort > 0 && this._externalListenHost != null) {
            if (this._log.shouldLog(20)) {
                this._log.info("Ignoring IP address suggestion, since we have received an inbound con recently");
            }
        } else {
            UDPTransport uDPTransport = this;
            synchronized (uDPTransport) {
                if (this._externalListenHost == null || !UDPTransport.eq(this._externalListenHost.getAddress(), this._externalListenPort, ourIP, ourPort)) {
                    if (this._reachabilityStatus == 4 || this._externalListenHost == null || this._externalListenPort <= 0 || this._context.clock().now() - this._reachabilityStatusLastUpdated > 1560000L) {
                        if (this._log.shouldLog(20)) {
                            this._log.info("Trying to change our external address...");
                        }
                        try {
                            this._externalListenHost = InetAddress.getByAddress(ourIP);
                            if (!fixedPort) {
                                this._externalListenPort = ourPort;
                            }
                            this.rebuildExternalAddress();
                            this.replaceAddress(this._externalAddress);
                            updated = true;
                        }
                        catch (UnknownHostException uhe) {
                            this._externalListenHost = null;
                            if (this._log.shouldLog(20)) {
                                this._log.info("Error trying to change our external address", (Throwable)uhe);
                            }
                        }
                    } else {
                        fireTest = true;
                        if (this._log.shouldLog(20)) {
                            this._log.info("Different address, but we're fine.. (" + this._reachabilityStatus + ")");
                        }
                    }
                } else if (this._log.shouldLog(20)) {
                    this._log.info("Same address as the current one");
                }
            }
        }
        if (fireTest) {
            this._context.statManager().addRateData("udp.addressTestInsteadOfUpdate", 1L, 0L);
            this._testEvent.forceRun();
            SimpleTimer.getInstance().addEvent((SimpleTimer.TimedEvent)this._testEvent, 5000L);
        } else if (updated) {
            this._context.statManager().addRateData("udp.addressUpdated", 1L, 0L);
            if (!fixedPort) {
                this._context.router().setConfigSetting(PROP_EXTERNAL_PORT, ourPort + "");
            }
            this._context.router().saveConfig();
            this._context.router().rebuildRouterInfo();
            this._testEvent.forceRun();
            SimpleTimer.getInstance().addEvent((SimpleTimer.TimedEvent)this._testEvent, 5000L);
        }
    }

    private static final boolean eq(byte[] laddr, int lport, byte[] raddr, int rport) {
        return rport == lport && DataHelper.eq((byte[])laddr, (byte[])raddr);
    }

    public final boolean isValid(byte[] addr) {
        if (addr == null) {
            return false;
        }
        if (addr.length < 4) {
            return false;
        }
        if (UDPTransport.isPubliclyRoutable(addr)) {
            return true;
        }
        return Boolean.valueOf(this._context.getProperty("i2np.udp.allowLocal", DEFAULT_PREFER_UDP));
    }

    private boolean getIsPortFixed() {
        return DEFAULT_FIXED_PORT.equals(this._context.getProperty(PROP_FIXED_PORT, DEFAULT_FIXED_PORT));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PeerState getPeerState(RemoteHostId hostInfo) {
        Map map = this._peersByRemoteHost;
        synchronized (map) {
            return (PeerState)this._peersByRemoteHost.get(hostInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PeerState getPeerState(Hash remotePeer) {
        Map map = this._peersByIdent;
        synchronized (map) {
            return (PeerState)this._peersByIdent.get(remotePeer);
        }
    }

    public PeerState getPeerState(long relayTag) {
        return this._introManager.get(relayTag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addRemotePeerState(PeerState peer) {
        if (this._log.shouldLog(20)) {
            this._log.info("Add remote peer state: " + peer);
        }
        Hash remotePeer = peer.getRemotePeer();
        long oldEstablishedOn = -1L;
        PeerState oldPeer = null;
        if (remotePeer != null) {
            Map map = this._peersByIdent;
            synchronized (map) {
                oldPeer = this._peersByIdent.put(remotePeer, peer);
                if (oldPeer != null && oldPeer != peer) {
                    peer.loadFrom(oldPeer);
                    oldEstablishedOn = oldPeer.getKeyEstablishedTime();
                }
            }
        }
        if (oldPeer != null) {
            oldPeer.dropOutbound();
            this._introManager.remove(oldPeer);
            this._expireEvent.remove(oldPeer);
        }
        oldPeer = null;
        RemoteHostId remoteId = peer.getRemoteHostId();
        if (remoteId == null) {
            return false;
        }
        Map map = this._peersByRemoteHost;
        synchronized (map) {
            oldPeer = this._peersByRemoteHost.put(remoteId, peer);
            if (oldPeer != null && oldPeer != peer) {
                peer.loadFrom(oldPeer);
                oldEstablishedOn = oldPeer.getKeyEstablishedTime();
            }
        }
        if (oldPeer != null) {
            oldPeer.dropOutbound();
            this._introManager.remove(oldPeer);
            this._expireEvent.remove(oldPeer);
        }
        if (oldPeer != null && this._log.shouldLog(30)) {
            this._log.warn("Peer already connected: old=" + oldPeer + " new=" + peer, (Throwable)new Exception("dup"));
        }
        this._activeThrottle.unchoke(peer.getRemotePeer());
        this.markReachable(peer.getRemotePeer(), peer.isInbound());
        this._expireEvent.add(peer);
        this._introManager.add(peer);
        if (oldEstablishedOn > 0L) {
            this._context.statManager().addRateData("udp.alreadyConnected", oldEstablishedOn, 0L);
        }
        if (this.needsRebuild()) {
            this.rebuildExternalAddress();
        }
        if (this.getReachabilityStatus() != 0) {
            this._testEvent.forceRun();
            SimpleTimer.getInstance().addEvent((SimpleTimer.TimedEvent)this._testEvent, 0L);
        }
        return true;
    }

    public RouterAddress getCurrentAddress() {
        if (this.needsRebuild()) {
            this.rebuildExternalAddress(false);
        }
        return super.getCurrentAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(I2NPMessage inMsg, RouterIdentity remoteIdent, Hash remoteIdentHash, long msToReceive, int bytesReceived) {
        if (inMsg.getType() == 1) {
            DatabaseStoreMessage dsm = (DatabaseStoreMessage)inMsg;
            if (dsm.getRouterInfo() != null && dsm.getRouterInfo().getNetworkId() != 2) {
                Hash peerHash = dsm.getRouterInfo().getIdentity().calculateHash();
                PeerState peer = this.getPeerState(peerHash);
                if (peer != null) {
                    RemoteHostId remote = peer.getRemoteHostId();
                    boolean added = false;
                    int droplistSize = 0;
                    List list = this._dropList;
                    synchronized (list) {
                        if (!this._dropList.contains(remote)) {
                            while (this._dropList.size() > 256) {
                                this._dropList.remove(0);
                            }
                            this._dropList.add(remote);
                            added = true;
                        }
                        droplistSize = this._dropList.size();
                    }
                    if (added) {
                        this._context.statManager().addRateData("udp.dropPeerDroplist", (long)droplistSize, 0L);
                        SimpleTimer.getInstance().addEvent((SimpleTimer.TimedEvent)new RemoveDropList(remote), 600000L);
                    }
                }
                this.markUnreachable(peerHash);
                this._context.shitlist().shitlistRouter(peerHash, "Part of the wrong network, version = " + dsm.getRouterInfo().getOption("router.version"));
                this.dropPeer(peerHash, false, "wrong network");
                if (this._log.shouldLog(30)) {
                    this._log.warn("Dropping the peer " + peerHash.toBase64() + " because they are in the wrong net: " + dsm.getRouterInfo());
                }
                return;
            }
            if (dsm.getRouterInfo() != null) {
                if (this._log.shouldLog(20)) {
                    this._log.info("Received an RI from the same net");
                }
            } else if (this._log.shouldLog(20)) {
                this._log.info("Received a leaseSet: " + dsm);
            }
        } else if (this._log.shouldLog(10)) {
            this._log.debug("Received another message: " + inMsg.getClass().getName());
        }
        PeerState peer = this.getPeerState(remoteIdentHash);
        super.messageReceived(inMsg, remoteIdent, remoteIdentHash, msToReceive, bytesReceived);
        if (peer != null) {
            peer.expireInboundMessages();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInDropList(RemoteHostId peer) {
        List list = this._dropList;
        synchronized (list) {
            return this._dropList.contains(peer);
        }
    }

    void dropPeer(Hash peer, boolean shouldShitlist, String why) {
        PeerState state = this.getPeerState(peer);
        if (state != null) {
            this.dropPeer(state, shouldShitlist, why);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropPeer(PeerState peer, boolean shouldShitlist, String why) {
        RemoteHostId remoteId;
        if (this._log.shouldLog(30)) {
            long now = this._context.clock().now();
            StringBuffer buf = new StringBuffer(4096);
            long timeSinceSend = now - peer.getLastSendTime();
            long timeSinceRecv = now - peer.getLastReceiveTime();
            long timeSinceAck = now - peer.getLastACKSend();
            long timeSinceSendOK = now - peer.getLastSendFullyTime();
            int consec = peer.getConsecutiveFailedSends();
            buf.append("Dropping remote peer: ").append(peer.toString()).append(" shitlist? ").append(shouldShitlist);
            buf.append(" lifetime: ").append(now - peer.getKeyEstablishedTime());
            buf.append(" time since send/fully/recv/ack: ").append(timeSinceSend).append(" / ");
            buf.append(timeSinceSendOK).append(" / ");
            buf.append(timeSinceRecv).append(" / ").append(timeSinceAck);
            buf.append(" consec failures: ").append(consec);
            if (why != null) {
                buf.append(" cause: ").append(why);
            }
            this._log.warn(buf.toString(), (Throwable)new Exception("Dropped by"));
        }
        peer.dropOutbound();
        peer.expireInboundMessages();
        this._introManager.remove(peer);
        this._fragments.dropPeer(peer);
        PeerState altByIdent = null;
        PeerState altByHost = null;
        if (peer.getRemotePeer() != null) {
            this.dropPeerCapacities(peer);
            if (shouldShitlist) {
                this.markUnreachable(peer.getRemotePeer());
            }
            long now = this._context.clock().now();
            this._context.statManager().addRateData("udp.droppedPeer", now - peer.getLastReceiveTime(), now - peer.getKeyEstablishedTime());
            Map map = this._peersByIdent;
            synchronized (map) {
                altByIdent = (PeerState)this._peersByIdent.remove(peer.getRemotePeer());
            }
        }
        if ((remoteId = peer.getRemoteHostId()) != null) {
            Map map = this._peersByRemoteHost;
            synchronized (map) {
                altByHost = (PeerState)this._peersByRemoteHost.remove(remoteId);
            }
        }
        this._activeThrottle.unchoke(peer.getRemotePeer());
        this._expireEvent.remove(peer);
        if (this.needsRebuild()) {
            this.rebuildExternalAddress();
        }
        if (altByIdent != null && peer != altByIdent) {
            this.dropPeer(altByIdent, shouldShitlist, "recurse");
        }
        if (altByHost != null && peer != altByHost) {
            this.dropPeer(altByHost, shouldShitlist, "recurse");
        }
    }

    private boolean needsRebuild() {
        RouterAddress addr;
        UDPAddress ua;
        boolean rv;
        if (this._needsRebuild) {
            return true;
        }
        if (this._context.router().isHidden()) {
            return false;
        }
        if (this.introducersRequired()) {
            RouterAddress addr2 = this._externalAddress;
            UDPAddress ua2 = new UDPAddress(addr2);
            int valid = 0;
            Hash peerHash = new Hash();
            for (int i = 0; i < ua2.getIntroducerCount(); ++i) {
                peerHash.setData(ua2.getIntroducerKey(i));
                PeerState peer = this.getPeerState(peerHash);
                if (peer == null) continue;
                ++valid;
            }
            if (valid >= 3) {
                if (this._introducersSelectedOn < this._context.clock().now() - 600000L) {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Our introducers are valid, but thy havent changed in a while, so lets rechoose");
                    }
                    return true;
                }
                if (this._log.shouldLog(20)) {
                    this._log.info("Our introducers are valid and haven't changed in a while");
                }
                return false;
            }
            if (this._log.shouldLog(20)) {
                this._log.info("Our introducers are not valid (" + valid + ")");
            }
            return true;
        }
        boolean bl = rv = this._externalListenHost == null || this._externalListenPort <= 0;
        if (!rv && (ua = new UDPAddress(addr = this._externalAddress)).getIntroducerCount() > 0) {
            rv = true;
        }
        if (this._log.shouldLog(20)) {
            if (rv) {
                this._log.info("Need to initialize our direct SSU info (" + this._externalListenHost + ":" + this._externalListenPort + ")");
            } else {
                addr = this._externalAddress;
                ua = new UDPAddress(addr);
                if (ua.getPort() <= 0 || ua.getHost() == null) {
                    this._log.info("Our direct SSU info is initialized, but not used in our address yet");
                    rv = true;
                } else {
                    this._log.info("Our direct SSU info is initialized");
                }
            }
        }
        return rv;
    }

    private void dropPeerCapacities(PeerState peer) {
    }

    int send(UDPPacket packet) {
        if (this._log.shouldLog(10)) {
            this._log.debug("Sending packet " + packet);
        }
        return this._endpoint.send(packet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransportBid bid(RouterInfo toAddress, long dataSize) {
        int count;
        Hash to = toAddress.getIdentity().calculateHash();
        PeerState peer = this.getPeerState(to);
        if (peer != null) {
            if (this._log.shouldLog(10)) {
                this._log.debug("bidding on a message to an established peer: " + peer);
            }
            if (this.preferUDP()) {
                return this._fastPreferredBid;
            }
            return this._fastBid;
        }
        if (this._reachabilityStatus == 3) {
            this.markUnreachable(to);
            return null;
        }
        RouterAddress addr = toAddress.getTargetAddress(STYLE);
        if (addr == null) {
            this.markUnreachable(to);
            return null;
        }
        UDPAddress ua = new UDPAddress(addr);
        if (ua == null) {
            this.markUnreachable(to);
            return null;
        }
        if (ua.getIntroducerCount() <= 0) {
            InetAddress ia = ua.getHostAddress();
            if (ua.getPort() <= 0 || ia == null || !UDPTransport.isPubliclyRoutable(ia.getAddress())) {
                this.markUnreachable(to);
                return null;
            }
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("bidding on a message to an unestablished peer: " + to.toBase64());
        }
        Map map = this._peersByIdent;
        synchronized (map) {
            count = this._peersByIdent.size();
        }
        if (this.alwaysPreferUDP() || count < 3) {
            return this._slowPreferredBid;
        }
        if (this.preferUDP()) {
            return this._slowBid;
        }
        return this._slowestBid;
    }

    private boolean preferUDP() {
        String pref = this._context.getProperty(PROP_PREFER_UDP, DEFAULT_PREFER_UDP);
        return pref != null && !DEFAULT_PREFER_UDP.equals(pref);
    }

    private boolean alwaysPreferUDP() {
        String pref = this._context.getProperty(PROP_PREFER_UDP, DEFAULT_PREFER_UDP);
        return pref != null && "always".equals(pref);
    }

    public String getStyle() {
        return STYLE;
    }

    public void send(OutNetMessage msg) {
        if (msg == null) {
            return;
        }
        if (msg.getTarget() == null) {
            return;
        }
        if (msg.getTarget().getIdentity() == null) {
            return;
        }
        msg.timestamp("sending on UDP transport");
        Hash to = msg.getTarget().getIdentity().calculateHash();
        PeerState peer = this.getPeerState(to);
        if (this._log.shouldLog(10)) {
            this._log.debug("Sending to " + (to != null ? to.toBase64() : ""));
        }
        if (peer != null) {
            long lastSend = peer.getLastSendFullyTime();
            long lastRecv = peer.getLastReceiveTime();
            long now = this._context.clock().now();
            int inboundActive = peer.expireInboundMessages();
            if (lastSend > 0L && lastRecv > 0L && now - lastSend > 1800000L && now - lastRecv > 1800000L && peer.getConsecutiveFailedSends() > 0 && inboundActive <= 0) {
                this.dropPeer(peer, false, "proactive reconnection");
                msg.timestamp("peer is really idle, dropping con and reestablishing");
                if (this._log.shouldLog(10)) {
                    this._log.debug("Proactive reestablish to " + to.toBase64());
                }
                this._establisher.establish(msg);
                this._context.statManager().addRateData("udp.proactiveReestablish", now - lastSend, now - peer.getKeyEstablishedTime());
                return;
            }
            msg.timestamp("enqueueing for an already established peer");
            if (this._log.shouldLog(10)) {
                this._log.debug("Add to fragments for " + to.toBase64());
            }
            this._fragments.add(msg);
        } else {
            if (this._log.shouldLog(10)) {
                this._log.debug("Establish new connection to " + to.toBase64());
            }
            msg.timestamp("establishing a new connection");
            this._establisher.establish(msg);
        }
    }

    void send(I2NPMessage msg, PeerState peer) {
        OutboundMessageState state;
        boolean ok;
        if (this._log.shouldLog(10)) {
            this._log.debug("Injecting a data message to a new peer: " + peer);
        }
        if (ok = (state = new OutboundMessageState(this._context)).initialize(msg, peer)) {
            this._fragments.add(state);
        }
    }

    protected void outboundMessageReady() {
        throw new UnsupportedOperationException("Not used for UDP");
    }

    public RouterAddress startListening() {
        this.startup();
        return this._externalAddress;
    }

    public void stopListening() {
        this.shutdown();
    }

    private boolean explicitAddressSpecified() {
        return this._context.getProperty(PROP_EXTERNAL_HOST) != null;
    }

    void rebuildExternalAddress() {
        this.rebuildExternalAddress(true);
    }

    void rebuildExternalAddress(boolean allowRebuildRouterInfo) {
        int found;
        String port = this._context.getProperty(PROP_EXTERNAL_PORT);
        if (port != null) {
            try {
                this._externalListenPort = Integer.parseInt(port);
            }
            catch (NumberFormatException nfe) {
                this._externalListenPort = -1;
            }
        }
        if (this.explicitAddressSpecified()) {
            try {
                String host = this._context.getProperty(PROP_EXTERNAL_HOST);
                this._externalListenHost = InetAddress.getByName(host);
            }
            catch (UnknownHostException uhe) {
                this._externalListenHost = null;
            }
        }
        if (this._context.router().isHidden()) {
            return;
        }
        Properties options = new Properties();
        boolean directIncluded = false;
        if (this.allowDirectUDP() && this._externalListenPort > 0 && this._externalListenHost != null && this.isValid(this._externalListenHost.getAddress())) {
            options.setProperty("port", String.valueOf(this._externalListenPort));
            options.setProperty("host", this._externalListenHost.getHostAddress());
            directIncluded = true;
        }
        boolean introducersRequired = this.introducersRequired();
        boolean introducersIncluded = false;
        if ((introducersRequired || !directIncluded) && (found = this._introManager.pickInbound(options, 3)) > 0) {
            if (this._log.shouldLog(20)) {
                this._log.info("Picked peers: " + found);
            }
            this._introducersSelectedOn = this._context.clock().now();
            introducersIncluded = true;
        }
        if (introducersRequired) {
            options.setProperty("caps", "B");
        } else {
            options.setProperty("caps", "BC");
        }
        if (directIncluded || introducersIncluded) {
            options.setProperty("key", this._introKey.toBase64());
            RouterAddress addr = new RouterAddress();
            addr.setCost(5);
            addr.setExpiration(null);
            addr.setTransportStyle(STYLE);
            addr.setOptions(options);
            boolean wantsRebuild = false;
            if (this._externalAddress == null || !this._externalAddress.equals((Object)addr)) {
                wantsRebuild = true;
            }
            RouterAddress oldAddress = this._externalAddress;
            this._externalAddress = addr;
            if (this._log.shouldLog(20)) {
                this._log.info("Address rebuilt: " + addr);
            }
            this.replaceAddress(addr, oldAddress);
            if (allowRebuildRouterInfo && wantsRebuild) {
                this._context.router().rebuildRouterInfo();
            }
            this._needsRebuild = false;
        } else {
            if (this._log.shouldLog(30)) {
                this._log.warn("Wanted to rebuild my SSU address, but couldn't specify either the direct or indirect info (needs introducers? " + introducersRequired + ")", (Throwable)new Exception("source"));
            }
            this._needsRebuild = true;
        }
    }

    protected void replaceAddress(RouterAddress address, RouterAddress oldAddress) {
        this.replaceAddress(address);
        if (oldAddress != null) {
            UDPAddress old = new UDPAddress(oldAddress);
            InetAddress oldHost = old.getHostAddress();
            UDPAddress newAddr = new UDPAddress(address);
            InetAddress newHost = newAddr.getHostAddress();
            if (old.getPort() > 0 && oldHost != null && this.isValid(oldHost.getAddress()) && newAddr.getPort() > 0 && newHost != null && this.isValid(newHost.getAddress()) && (old.getPort() != newAddr.getPort() || !oldHost.equals(newHost)) && DEFAULT_FIXED_PORT.equalsIgnoreCase(this._context.getProperty("router.dynamicKeys", DEFAULT_PREFER_UDP))) {
                if (this._log.shouldLog(40)) {
                    this._log.error("SSU address updated. new address: " + newAddr.getHostAddress() + ":" + newAddr.getPort() + ", old address: " + old.getHostAddress() + ":" + old.getPort());
                }
                this._context.router().shutdown(4);
            }
        }
    }

    public boolean introducersRequired() {
        String forceIntroducers = this._context.getProperty(PROP_FORCE_INTRODUCERS);
        if (forceIntroducers != null && Boolean.valueOf(forceIntroducers).booleanValue()) {
            if (this._log.shouldLog(20)) {
                this._log.info("Force introducers specified");
            }
            return true;
        }
        short status = this.getReachabilityStatus();
        switch (status) {
            case 1: 
            case 2: {
                if (this._log.shouldLog(20)) {
                    this._log.info("Require introducers, because our status is " + status);
                }
                return true;
            }
        }
        if (!this.allowDirectUDP()) {
            if (this._log.shouldLog(20)) {
                this._log.info("Require introducers, because we do not allow direct UDP connections");
            }
            return true;
        }
        return false;
    }

    private boolean allowDirectUDP() {
        String allowDirect = this._context.getProperty(PROP_ALLOW_DIRECT);
        return allowDirect == null || Boolean.valueOf(allowDirect) != false;
    }

    String getPacketHandlerStatus() {
        PacketHandler handler = this._handler;
        if (handler != null) {
            return handler.getHandlerStatus();
        }
        return "";
    }

    public void failed(OutboundMessageState msg) {
        this.failed(msg, true);
    }

    void failed(OutboundMessageState msg, boolean allowPeerFailure) {
        if (msg == null) {
            return;
        }
        int consecutive = 0;
        OutNetMessage m = msg.getMessage();
        if (allowPeerFailure && msg.getPeer() != null && (msg.getMaxSends() >= 10 || msg.isExpired())) {
            consecutive = msg.getPeer().incrementConsecutiveFailedSends();
            if (this._log.shouldLog(30)) {
                this._log.warn("Consecutive failure #" + consecutive + " on " + msg.toString() + " to " + msg.getPeer());
            }
            if (this._context.clock().now() - msg.getPeer().getLastSendFullyTime() > 60000L && consecutive >= 5) {
                this._context.statManager().addRateData("udp.dropPeerConsecutiveFailures", (long)consecutive, msg.getPeer().getInactivityTime());
                this.dropPeer(msg.getPeer(), false, "too many failures");
            }
        }
        this.noteSend(msg, false);
        if (m != null) {
            super.afterSend(m, false);
        }
    }

    private void noteSend(OutboundMessageState msg, boolean successful) {
        int pushCount = msg.getPushCount();
        int sends = msg.getMaxSends();
        boolean expired = msg.isExpired();
        OutNetMessage m = msg.getMessage();
        PeerState p = msg.getPeer();
        StringBuffer buf = new StringBuffer(64);
        buf.append(" lifetime: ").append(msg.getLifetime());
        buf.append(" sends: ").append(sends);
        buf.append(" pushes: ").append(pushCount);
        buf.append(" expired? ").append(expired);
        buf.append(" unacked: ").append(msg.getUnackedSize());
        if (p != null && !successful) {
            buf.append(" consec_failed: ").append(p.getConsecutiveFailedSends());
            long timeSinceSend = this._context.clock().now() - p.getLastSendFullyTime();
            buf.append(" lastFullSend: ").append(timeSinceSend);
            long timeSinceRecv = this._context.clock().now() - p.getLastReceiveTime();
            buf.append(" lastRecv: ").append(timeSinceRecv);
            buf.append(" xfer: ").append(p.getSendBps()).append("/").append(p.getReceiveBps());
            buf.append(" mtu: ").append(p.getMTU());
            buf.append(" rto: ").append(p.getRTO());
            buf.append(" sent: ").append(p.getMessagesSent()).append("/").append(p.getPacketsTransmitted());
            buf.append(" recv: ").append(p.getMessagesReceived()).append("/").append(p.getPacketsReceived());
            buf.append(" uptime: ").append(this._context.clock().now() - p.getKeyEstablishedTime());
        }
        if (m != null && p != null) {
            this._context.messageHistory().sendMessage(m.getMessageType(), msg.getMessageId(), m.getExpiration(), p.getRemotePeer(), successful, buf.toString());
        } else {
            this._context.messageHistory().sendMessage("establish", msg.getMessageId(), -1L, p != null ? p.getRemotePeer() : null, successful, buf.toString());
        }
    }

    public void failed(OutNetMessage msg, String reason) {
        if (msg == null) {
            return;
        }
        if (this._log.shouldLog(30)) {
            this._log.warn("Sending message failed: " + msg, (Throwable)new Exception("failed from"));
        }
        this._context.messageHistory().sendMessage(msg.getMessageType(), msg.getMessageId(), msg.getExpiration(), msg.getTarget().getIdentity().calculateHash(), false, reason);
        super.afterSend(msg, false);
    }

    public void succeeded(OutboundMessageState msg) {
        if (msg == null) {
            return;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Sending message succeeded: " + msg);
        }
        this.noteSend(msg, true);
        OutNetMessage m = msg.getMessage();
        if (m != null) {
            super.afterSend(m, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countActivePeers() {
        long now = this._context.clock().now();
        int active = 0;
        int inactive = 0;
        Map map = this._peersByIdent;
        synchronized (map) {
            for (PeerState peer : this._peersByIdent.values()) {
                if (now - peer.getLastReceiveTime() > 300000L) {
                    ++inactive;
                    continue;
                }
                ++active;
            }
        }
        return active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countActiveSendPeers() {
        long now = this._context.clock().now();
        int active = 0;
        int inactive = 0;
        Map map = this._peersByIdent;
        synchronized (map) {
            for (PeerState peer : this._peersByIdent.values()) {
                if (now - peer.getLastSendFullyTime() > 60000L) {
                    ++inactive;
                    continue;
                }
                ++active;
            }
        }
        return active;
    }

    public boolean isEstablished(Hash dest) {
        return this.getPeerState(dest) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getClockSkews() {
        Vector<Long> skews = new Vector<Long>();
        Vector peers = new Vector();
        Map map = this._peersByIdent;
        synchronized (map) {
            peers.addAll(this._peersByIdent.values());
        }
        long now = this._context.clock().now();
        for (PeerState peer : peers) {
            if (now - peer.getLastReceiveTime() > 3600000L) continue;
            skews.addElement(new Long(peer.getClockSkew()));
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("UDP transport returning " + skews.size() + " peer clock skews.");
        }
        return skews;
    }

    public static final UDPTransport _instance() {
        return __instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List _getActivePeers() {
        ArrayList peers = new ArrayList(128);
        Map map = this._peersByIdent;
        synchronized (map) {
            peers.addAll(this._peersByIdent.keySet());
        }
        long now = this._context.clock().now();
        Iterator iter = peers.iterator();
        while (iter.hasNext()) {
            Hash peer = (Hash)iter.next();
            PeerState state = this.getPeerState(peer);
            if (now - state.getLastReceiveTime() <= 300000L) continue;
            iter.remove();
        }
        return peers;
    }

    private Comparator getComparator(int sortFlags) {
        Comparator rv = null;
        switch (Math.abs(sortFlags)) {
            case 1: {
                rv = IdleInComparator.instance();
                break;
            }
            case 2: {
                rv = IdleOutComparator.instance();
                break;
            }
            case 3: {
                rv = RateInComparator.instance();
                break;
            }
            case 4: {
                rv = RateOutComparator.instance();
                break;
            }
            case 16: {
                rv = UptimeComparator.instance();
                break;
            }
            case 5: {
                rv = SkewComparator.instance();
                break;
            }
            case 6: {
                rv = CwndComparator.instance();
                break;
            }
            case 7: {
                rv = SsthreshComparator.instance();
                break;
            }
            case 8: {
                rv = RTTComparator.instance();
                break;
            }
            case 9: {
                rv = DevComparator.instance();
                break;
            }
            case 10: {
                rv = RTOComparator.instance();
                break;
            }
            case 11: {
                rv = MTUComparator.instance();
                break;
            }
            case 12: {
                rv = SendCountComparator.instance();
                break;
            }
            case 13: {
                rv = RecvCountComparator.instance();
                break;
            }
            case 14: {
                rv = ResendComparator.instance();
                break;
            }
            case 15: {
                rv = DupComparator.instance();
                break;
            }
            default: {
                rv = AlphaComparator.instance();
            }
        }
        if (sortFlags < 0) {
            rv = new InverseComparator(rv);
        }
        return rv;
    }

    private void appendSortLinks(StringBuffer buf, String urlBase, int sortFlags, String descr, int ascending) {
        if (sortFlags == ascending) {
            buf.append(" <a href=\"").append(urlBase).append("?sort=").append(0 - ascending);
            buf.append("\" title=\"").append(descr).append("\">V</a><b>^</b> ");
        } else if (sortFlags == 0 - ascending) {
            buf.append(" <b>V</b><a href=\"").append(urlBase).append("?sort=").append(ascending);
            buf.append("\" title=\"").append(descr).append("\">^</a> ");
        } else {
            buf.append(" <a href=\"").append(urlBase).append("?sort=").append(0 - ascending);
            buf.append("\" title=\"").append(descr).append("\">V</a><a href=\"").append(urlBase).append("?sort=").append(ascending);
            buf.append("\" title=\"").append(descr).append("\">^</a> ");
        }
    }

    public void renderStatusHTML(Writer out, int sortFlags) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderStatusHTML(Writer out, String urlBase, int sortFlags) throws IOException {
        TreeSet peers = new TreeSet(this.getComparator(sortFlags));
        Map map = this._peersByIdent;
        synchronized (map) {
            peers.addAll(this._peersByIdent.values());
        }
        long offsetTotal = 0L;
        int bpsIn = 0;
        int bpsOut = 0;
        long uptimeMsTotal = 0L;
        long cwinTotal = 0L;
        long rttTotal = 0L;
        long rtoTotal = 0L;
        long sendTotal = 0L;
        long recvTotal = 0L;
        long resentTotal = 0L;
        long dupRecvTotal = 0L;
        int numPeers = 0;
        StringBuffer buf = new StringBuffer(512);
        buf.append("<b id=\"udpcon\">UDP connections: ").append(peers.size()).append("</b><br />\n");
        buf.append("<table border=\"1\">\n");
        buf.append(" <tr><td><b><a href=\"#def.peer\">peer</a></b>");
        if (sortFlags == 0) {
            buf.append(" V ");
        } else {
            buf.append(" <a href=\"").append(urlBase).append("?sort=0\">V</a> ");
        }
        buf.append("</td><td><b><a href=\"#def.idle\">idle</a></b>");
        this.appendSortLinks(buf, urlBase, sortFlags, "Sort by idle inbound", 1);
        buf.append("/");
        this.appendSortLinks(buf, urlBase, sortFlags, "Sort by idle outbound", 2);
        buf.append("</td>");
        buf.append("     <td><b><a href=\"#def.rate\">in/out</a></b>");
        this.appendSortLinks(buf, urlBase, sortFlags, "Sort by inbound rate", 3);
        buf.append("/");
        this.appendSortLinks(buf, urlBase, sortFlags, "Sort by outbound rate", 4);
        buf.append("</td>\n");
        buf.append("     <td><b><a href=\"#def.up\">up</a></b>");
        this.appendSortLinks(buf, urlBase, sortFlags, "Sort by connection uptime", 16);
        buf.append("</td><td><b><a href=\"#def.skew\">skew</a></b>");
        this.appendSortLinks(buf, urlBase, sortFlags, "Sort by clock skew", 5);
        buf.append("</td>\n");
        buf.append("     <td><b><a href=\"#def.cwnd\">cwnd</a></b>");
        this.appendSortLinks(buf, urlBase, sortFlags, "Sort by congestion window", 6);
        buf.append("</td><td><b><a href=\"#def.ssthresh\">ssthresh</a></b>");
        this.appendSortLinks(buf, urlBase, sortFlags, "Sort by slow start threshold", 7);
        buf.append("</td>\n");
        buf.append("     <td><b><a href=\"#def.rtt\">rtt</a></b>");
        this.appendSortLinks(buf, urlBase, sortFlags, "Sort by round trip time", 8);
        buf.append("</td><td><b><a href=\"#def.dev\">dev</a></b>");
        this.appendSortLinks(buf, urlBase, sortFlags, "Sort by round trip time deviation", 9);
        buf.append("</td><td><b><a href=\"#def.rto\">rto</a></b>");
        this.appendSortLinks(buf, urlBase, sortFlags, "Sort by retransmission timeout", 10);
        buf.append("</td>\n");
        buf.append("     <td><b><a href=\"#def.mtu\">mtu</a></b>");
        this.appendSortLinks(buf, urlBase, sortFlags, "Sort by maximum transmit unit", 11);
        buf.append("</td><td><b><a href=\"#def.send\">send</a></b>");
        this.appendSortLinks(buf, urlBase, sortFlags, "Sort by packets sent", 12);
        buf.append("</td><td><b><a href=\"#def.recv\">recv</a></b>");
        this.appendSortLinks(buf, urlBase, sortFlags, "Sort by packets received", 13);
        buf.append("</td>\n");
        buf.append("     <td><b><a href=\"#def.resent\">resent</a></b>");
        this.appendSortLinks(buf, urlBase, sortFlags, "Sort by packets retransmitted", 14);
        buf.append("</td><td><b><a href=\"#def.dupRecv\">dupRecv</a></b>");
        this.appendSortLinks(buf, urlBase, sortFlags, "Sort by packets received more than once", 15);
        buf.append("</td>\n");
        buf.append(" </tr>\n");
        out.write(buf.toString());
        buf.setLength(0);
        long now = this._context.clock().now();
        for (PeerState peer : peers) {
            if (now - peer.getLastReceiveTime() > 3600000L) continue;
            buf.append("<tr>");
            String name = peer.getRemotePeer().toBase64().substring(0, 6);
            buf.append("<td valign=\"top\" nowrap=\"nowrap\"><code>");
            buf.append("<a href=\"netdb.jsp?r=");
            buf.append(name);
            buf.append("\">");
            buf.append(name);
            buf.append("</a>&nbsp;");
            if (peer.isInbound()) {
                buf.append("in ");
            } else {
                buf.append("out ");
            }
            if (peer.getWeRelayToThemAs() > 0L) {
                buf.append("^");
            } else {
                buf.append("&nbsp;");
            }
            if (peer.getTheyRelayToUsAs() > 0L) {
                buf.append("v");
            }
            boolean appended = false;
            if (this._activeThrottle.isChoked(peer.getRemotePeer())) {
                if (!appended) {
                    buf.append("<br />");
                }
                buf.append(" [choked]");
                appended = true;
            }
            if (peer.getConsecutiveFailedSends() > 0) {
                if (!appended) {
                    buf.append("<br />");
                }
                buf.append(" [").append(peer.getConsecutiveFailedSends()).append(" failures]");
                appended = true;
            }
            if (this._context.shitlist().isShitlisted(peer.getRemotePeer(), STYLE)) {
                if (!appended) {
                    buf.append("<br />");
                }
                buf.append(" [shitlisted]");
                appended = true;
            }
            buf.append("</code></td>");
            long idleIn = (now - peer.getLastReceiveTime()) / 1000L;
            long idleOut = (now - peer.getLastSendTime()) / 1000L;
            if (idleIn < 0L) {
                idleIn = 0L;
            }
            if (idleOut < 0L) {
                idleOut = 0L;
            }
            buf.append("<td valign=\"top\" align=\"right\" ><code>");
            buf.append(idleIn);
            buf.append("s/");
            buf.append(idleOut);
            buf.append("s</code></td>");
            int recvBps = idleIn > 2L ? 0 : peer.getReceiveBps();
            int sendBps = idleOut > 2L ? 0 : peer.getSendBps();
            buf.append("<td valign=\"top\" align=\"right\" ><code>");
            buf.append(UDPTransport.formatKBps(recvBps));
            buf.append("/");
            buf.append(UDPTransport.formatKBps(sendBps));
            buf.append("KBps ");
            buf.append("</code></td>");
            long uptime = now - peer.getKeyEstablishedTime();
            buf.append("<td valign=\"top\" align=\"right\" ><code>");
            buf.append(DataHelper.formatDuration((long)uptime));
            buf.append("</code></td>");
            buf.append("<td valign=\"top\" align=\"right\" ><code>");
            buf.append(peer.getClockSkew());
            buf.append("s</code></td>");
            offsetTotal += (long)peer.getClockSkew();
            long sendWindow = peer.getSendWindowBytes();
            buf.append("<td valign=\"top\" align=\"right\" ><code>");
            buf.append(sendWindow / 1024L);
            buf.append("K");
            buf.append("/").append(peer.getConcurrentSends());
            buf.append("/").append(peer.getConcurrentSendWindow());
            buf.append("/").append(peer.getConsecutiveSendRejections());
            buf.append("</code></td>");
            buf.append("<td valign=\"top\" align=\"right\" ><code>");
            buf.append(peer.getSlowStartThreshold() / 1024);
            buf.append("K</code></td>");
            int rtt = peer.getRTT();
            int rto = peer.getRTO();
            buf.append("<td valign=\"top\" align=\"right\" ><code>");
            buf.append(rtt);
            buf.append("</code></td>");
            buf.append("<td valign=\"top\" align=\"right\" ><code>");
            buf.append(peer.getRTTDeviation());
            buf.append("</code></td>");
            buf.append("<td valign=\"top\" align=\"right\" ><code>");
            buf.append(rto);
            buf.append("</code></td>");
            buf.append("<td valign=\"top\" align=\"right\" ><code>");
            buf.append(peer.getMTU()).append("/").append(peer.getReceiveMTU());
            buf.append("</code></td>");
            long sent = peer.getPacketsTransmitted();
            long recv = peer.getPacketsReceived();
            buf.append("<td valign=\"top\" align=\"right\" ><code>");
            buf.append(sent);
            buf.append("</code></td>");
            buf.append("<td valign=\"top\" align=\"right\" ><code>");
            buf.append(recv);
            buf.append("</code></td>");
            long resent = peer.getPacketsRetransmitted();
            long dupRecv = peer.getPacketsReceivedDuplicate();
            buf.append("<td valign=\"top\" align=\"right\" ><code>");
            buf.append(resent);
            buf.append("</code></td>");
            double recvDupPct = (double)peer.getPacketsReceivedDuplicate() / (double)peer.getPacketsReceived();
            buf.append("<td valign=\"top\" align=\"right\" ><code>");
            buf.append(dupRecv);
            buf.append("</code></td>");
            buf.append("</tr>\n");
            out.write(buf.toString());
            buf.setLength(0);
            bpsIn += recvBps;
            bpsOut += sendBps;
            uptimeMsTotal += uptime;
            cwinTotal += sendWindow;
            rttTotal += (long)rtt;
            rtoTotal += (long)rto;
            sendTotal += sent;
            recvTotal += recv;
            resentTotal += resent;
            dupRecvTotal += dupRecv;
            ++numPeers;
        }
        buf.append("<tr><td colspan=\"15\"><hr /></td></tr>\n");
        buf.append(" <tr><td colspan=\"2\"><b>Total</b></td>");
        buf.append("     <td align=\"right\">");
        buf.append(UDPTransport.formatKBps(bpsIn)).append("/").append(UDPTransport.formatKBps(bpsOut));
        buf.append("KBps</td>");
        buf.append("     <td align=\"right\">").append(numPeers > 0 ? DataHelper.formatDuration((long)(uptimeMsTotal / (long)numPeers)) : "0s");
        buf.append("</td><td align=\"right\">").append(numPeers > 0 ? DataHelper.formatDuration((long)(offsetTotal * 1000L / (long)numPeers)) : "0ms").append("</td>\n");
        buf.append("     <td align=\"right\">");
        buf.append(numPeers > 0 ? cwinTotal / (long)(numPeers * 1024) + "K" : "0K");
        buf.append("</td><td>&nbsp;</td>\n");
        buf.append("     <td align=\"right\">");
        buf.append(numPeers > 0 ? rttTotal / (long)numPeers : 0L);
        buf.append("</td><td align=\"right\">&nbsp;</td><td align=\"right\">");
        buf.append(numPeers > 0 ? rtoTotal / (long)numPeers : 0L);
        buf.append("</td>\n     <td>&nbsp;</td><td align=\"right\">");
        buf.append(sendTotal).append("</td><td align=\"right\">").append(recvTotal).append("</td>\n");
        buf.append("     <td align=\"right\">").append(resentTotal);
        buf.append("</td><td align=\"right\">").append(dupRecvTotal).append("</td>\n");
        buf.append(" </tr>\n");
        buf.append("<tr><td colspan=\"15\" valign=\"top\" align=\"left\">");
        long bytesTransmitted = this._context.bandwidthLimiter().getTotalAllocatedOutboundBytes();
        double averagePacketSize = this._context.statManager().getRate("udp.sendPacketSize").getLifetimeAverageValue();
        resentTotal = this._context.statManager().getRate("udp.packetsRetransmitted").getLifetimeEventCount();
        double nondupSent = (double)bytesTransmitted - (double)resentTotal * averagePacketSize;
        double bwResent = nondupSent <= 0.0 ? 0.0 : (double)resentTotal * averagePacketSize / nondupSent;
        buf.append("Percentage of bytes retransmitted (lifetime): ").append(UDPTransport.formatPct(bwResent));
        buf.append(" <i>(includes retransmission required by packet loss)</i><br />\n");
        buf.append("</td></tr>\n");
        out.write(buf.toString());
        buf.setLength(0);
        out.write(KEY);
        out.write("</table>\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String formatKBps(int bps) {
        DecimalFormat decimalFormat = _fmt;
        synchronized (decimalFormat) {
            return _fmt.format((float)bps / 1024.0f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String formatPct(double pct) {
        DecimalFormat decimalFormat = _pctFmt;
        synchronized (decimalFormat) {
            return _pctFmt.format(pct);
        }
    }

    void setReachabilityStatus(short status) {
        short old = this._reachabilityStatus;
        long now = this._context.clock().now();
        switch (status) {
            case 0: {
                this._context.statManager().addRateData("udp.statusOK", 1L, 0L);
                this._reachabilityStatus = status;
                this._reachabilityStatusLastUpdated = now;
                break;
            }
            case 1: {
                this._context.statManager().addRateData("udp.statusDifferent", 1L, 0L);
                this._reachabilityStatus = status;
                this._reachabilityStatusLastUpdated = now;
                break;
            }
            case 2: {
                this._context.statManager().addRateData("udp.statusReject", 1L, 0L);
            }
            case 3: {
                this._reachabilityStatus = status;
                this._reachabilityStatusLastUpdated = now;
                break;
            }
            default: {
                this._context.statManager().addRateData("udp.statusUnknown", 1L, 0L);
            }
        }
        if (status != old && status != 4) {
            if (this._log.shouldLog(20)) {
                this._log.info("Old status: " + old + " New status: " + status + " from: ", (Throwable)new Exception("traceback"));
            }
            if (this.needsRebuild()) {
                this.rebuildExternalAddress();
            }
        }
    }

    public short getReachabilityStatus() {
        String override = this._context.getProperty(PROP_REACHABILITY_STATUS_OVERRIDE);
        if (override == null) {
            return this._reachabilityStatus;
        }
        if ("ok".equals(override)) {
            return 0;
        }
        if ("err-reject".equals(override)) {
            return 2;
        }
        if ("err-different".equals(override)) {
            return 1;
        }
        return this._reachabilityStatus;
    }

    public void recheckReachability() {
        this._testEvent.runTest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PeerState pickTestPeer(RemoteHostId dontInclude) {
        ArrayList peers = null;
        Map map = this._peersByIdent;
        synchronized (map) {
            peers = new ArrayList(this._peersByIdent.values());
        }
        Collections.shuffle(peers, (Random)this._context.random());
        for (int i = 0; i < peers.size(); ++i) {
            RouterAddress addr;
            RouterInfo peerInfo;
            PeerState peer = (PeerState)peers.get(i);
            if (dontInclude != null && dontInclude.equals(peer.getRemoteHostId()) || (peerInfo = this._context.netDb().lookupRouterInfoLocally(peer.getRemotePeer())) == null || (addr = peerInfo.getTargetAddress(STYLE)) == null) continue;
            return peer;
        }
        return null;
    }

    private boolean shouldTest() {
        return !this._context.router().isHidden();
    }

    public static void main(String[] args) {
        boolean routable;
        InetAddress addr;
        int i;
        for (i = 0; i < BADIPS.length; ++i) {
            try {
                addr = InetAddress.getByName(BADIPS[i]);
                routable = UDPTransport.isPubliclyRoutable(addr.getAddress());
                System.out.println("Routable: " + routable + " (" + BADIPS[i] + ")");
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (i = 0; i < GOODIPS.length; ++i) {
            try {
                addr = InetAddress.getByName(GOODIPS[i]);
                routable = UDPTransport.isPubliclyRoutable(addr.getAddress());
                System.out.println("Routable: " + routable + " (" + GOODIPS[i] + ")");
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static {
        _fmt = new DecimalFormat("#,##0.00");
        _pctFmt = new DecimalFormat("#0.0%");
        BADIPS = new String[]{"192.168.0.1", "127.0.0.1", "10.3.4.5", "172.16.3.4", "224.5.6.7"};
        GOODIPS = new String[]{"192.167.0.1", "126.0.0.1", "11.3.4.5", "172.15.3.4", "223.5.6.7"};
    }

    private class PeerTestEvent
    implements SimpleTimer.TimedEvent {
        private boolean _alive;
        private long _lastTested;
        private boolean _forceRun;

        private PeerTestEvent() {
        }

        public void timeReached() {
            if (UDPTransport.this.shouldTest()) {
                long now = UDPTransport.this._context.clock().now();
                if (this._forceRun || now - this._lastTested >= 780000L) {
                    this.runTest();
                }
            }
            if (this._alive) {
                long delay = 390000 + UDPTransport.this._context.random().nextInt(780000);
                if (delay <= 0L) {
                    throw new RuntimeException("wtf, delay is " + delay);
                }
                SimpleTimer.getInstance().addEvent((SimpleTimer.TimedEvent)this, delay);
            }
        }

        private void runTest() {
            PeerState bob = UDPTransport.this.pickTestPeer(null);
            if (bob != null) {
                if (UDPTransport.this._log.shouldLog(20)) {
                    UDPTransport.this._log.info("Running periodic test with bob = " + bob);
                }
                UDPTransport.this._testManager.runTest(bob.getRemoteIPAddress(), bob.getRemotePort(), bob.getCurrentCipherKey(), bob.getCurrentMACKey());
                this._lastTested = UDPTransport.this._context.clock().now();
                this._forceRun = false;
                return;
            }
            if (UDPTransport.this._log.shouldLog(30)) {
                UDPTransport.this._log.warn("Unable to run a periodic test, as there are no peers with the capacity required");
            }
            this._forceRun = false;
        }

        void forceRun() {
            this._forceRun = true;
        }

        public void setIsAlive(boolean isAlive) {
            this._alive = isAlive;
            if (isAlive) {
                long delay = UDPTransport.this._context.random().nextInt(1560000);
                SimpleTimer.getInstance().addEvent((SimpleTimer.TimedEvent)this, delay);
            } else {
                SimpleTimer.getInstance().removeEvent((SimpleTimer.TimedEvent)this);
            }
        }
    }

    private class ExpirePeerEvent
    implements SimpleTimer.TimedEvent {
        private List _expirePeers = new ArrayList(128);
        private List _expireBuffer = new ArrayList(128);
        private boolean _alive;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void timeReached() {
            long inactivityCutoff = UDPTransport.this._context.clock().now() - 1800000L;
            this._expireBuffer.clear();
            List list = this._expirePeers;
            synchronized (list) {
                int sz = this._expirePeers.size();
                for (int i = 0; i < sz; ++i) {
                    PeerState peer = (PeerState)this._expirePeers.get(i);
                    if (peer.getLastReceiveTime() >= inactivityCutoff || peer.getLastSendTime() >= inactivityCutoff) continue;
                    this._expireBuffer.add(peer);
                    this._expirePeers.remove(i);
                    --i;
                    --sz;
                }
            }
            for (int i = 0; i < this._expireBuffer.size(); ++i) {
                UDPTransport.this.dropPeer((PeerState)this._expireBuffer.get(i), false, "idle too long");
            }
            this._expireBuffer.clear();
            if (this._alive) {
                SimpleTimer.getInstance().addEvent((SimpleTimer.TimedEvent)this, 30000L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(PeerState peer) {
            List list = this._expirePeers;
            synchronized (list) {
                this._expirePeers.add(peer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(PeerState peer) {
            List list = this._expirePeers;
            synchronized (list) {
                this._expirePeers.remove(peer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setIsAlive(boolean isAlive) {
            this._alive = isAlive;
            if (isAlive) {
                SimpleTimer.getInstance().addEvent((SimpleTimer.TimedEvent)this, 30000L);
            } else {
                SimpleTimer.getInstance().removeEvent((SimpleTimer.TimedEvent)this);
                List list = this._expirePeers;
                synchronized (list) {
                    this._expirePeers.clear();
                }
            }
        }
    }

    private class SharedBid
    extends TransportBid {
        public SharedBid(int ms) {
            this.setLatencyMs(ms);
        }

        public Transport getTransport() {
            return UDPTransport.this;
        }

        public String toString() {
            return "UDP bid @ " + this.getLatencyMs();
        }
    }

    private static class InverseComparator
    implements Comparator {
        private Comparator _comp;

        public InverseComparator(Comparator comp) {
            this._comp = comp;
        }

        public int compare(Object lhs, Object rhs) {
            return -1 * this._comp.compare(lhs, rhs);
        }
    }

    private static class PeerComparator
    implements Comparator {
        private PeerComparator() {
        }

        public int compare(Object lhs, Object rhs) {
            if (lhs == null || rhs == null || !(lhs instanceof PeerState) || !(rhs instanceof PeerState)) {
                throw new IllegalArgumentException("rhs = " + rhs + " lhs = " + lhs);
            }
            return this.compare((PeerState)lhs, (PeerState)rhs);
        }

        protected int compare(PeerState l, PeerState r) {
            return l.getRemotePeer().toBase64().compareTo(r.getRemotePeer().toBase64());
        }
    }

    private static class DupComparator
    extends PeerComparator {
        private static final DupComparator _instance = new DupComparator();

        private DupComparator() {
        }

        public static final DupComparator instance() {
            return _instance;
        }

        protected int compare(PeerState l, PeerState r) {
            long rv = l.getPacketsReceivedDuplicate() - r.getPacketsReceivedDuplicate();
            if (rv == 0L) {
                return super.compare(l, r);
            }
            return (int)rv;
        }
    }

    private static class ResendComparator
    extends PeerComparator {
        private static final ResendComparator _instance = new ResendComparator();

        private ResendComparator() {
        }

        public static final ResendComparator instance() {
            return _instance;
        }

        protected int compare(PeerState l, PeerState r) {
            long rv = l.getPacketsRetransmitted() - r.getPacketsRetransmitted();
            if (rv == 0L) {
                return super.compare(l, r);
            }
            return (int)rv;
        }
    }

    private static class RecvCountComparator
    extends PeerComparator {
        private static final RecvCountComparator _instance = new RecvCountComparator();

        private RecvCountComparator() {
        }

        public static final RecvCountComparator instance() {
            return _instance;
        }

        protected int compare(PeerState l, PeerState r) {
            long rv = l.getPacketsReceived() - r.getPacketsReceived();
            if (rv == 0L) {
                return super.compare(l, r);
            }
            return (int)rv;
        }
    }

    private static class SendCountComparator
    extends PeerComparator {
        private static final SendCountComparator _instance = new SendCountComparator();

        private SendCountComparator() {
        }

        public static final SendCountComparator instance() {
            return _instance;
        }

        protected int compare(PeerState l, PeerState r) {
            long rv = l.getPacketsTransmitted() - r.getPacketsTransmitted();
            if (rv == 0L) {
                return super.compare(l, r);
            }
            return (int)rv;
        }
    }

    private static class MTUComparator
    extends PeerComparator {
        private static final MTUComparator _instance = new MTUComparator();

        private MTUComparator() {
        }

        public static final MTUComparator instance() {
            return _instance;
        }

        protected int compare(PeerState l, PeerState r) {
            long rv = l.getMTU() - r.getMTU();
            if (rv == 0L) {
                return super.compare(l, r);
            }
            return (int)rv;
        }
    }

    private static class RTOComparator
    extends PeerComparator {
        private static final RTOComparator _instance = new RTOComparator();

        private RTOComparator() {
        }

        public static final RTOComparator instance() {
            return _instance;
        }

        protected int compare(PeerState l, PeerState r) {
            long rv = l.getRTO() - r.getRTO();
            if (rv == 0L) {
                return super.compare(l, r);
            }
            return (int)rv;
        }
    }

    private static class DevComparator
    extends PeerComparator {
        private static final DevComparator _instance = new DevComparator();

        private DevComparator() {
        }

        public static final DevComparator instance() {
            return _instance;
        }

        protected int compare(PeerState l, PeerState r) {
            long rv = l.getRTTDeviation() - r.getRTTDeviation();
            if (rv == 0L) {
                return super.compare(l, r);
            }
            return (int)rv;
        }
    }

    private static class RTTComparator
    extends PeerComparator {
        private static final RTTComparator _instance = new RTTComparator();

        private RTTComparator() {
        }

        public static final RTTComparator instance() {
            return _instance;
        }

        protected int compare(PeerState l, PeerState r) {
            long rv = l.getRTT() - r.getRTT();
            if (rv == 0L) {
                return super.compare(l, r);
            }
            return (int)rv;
        }
    }

    private static class SsthreshComparator
    extends PeerComparator {
        private static final SsthreshComparator _instance = new SsthreshComparator();

        private SsthreshComparator() {
        }

        public static final SsthreshComparator instance() {
            return _instance;
        }

        protected int compare(PeerState l, PeerState r) {
            long rv = l.getSlowStartThreshold() - r.getSlowStartThreshold();
            if (rv == 0L) {
                return super.compare(l, r);
            }
            return (int)rv;
        }
    }

    private static class CwndComparator
    extends PeerComparator {
        private static final CwndComparator _instance = new CwndComparator();

        private CwndComparator() {
        }

        public static final CwndComparator instance() {
            return _instance;
        }

        protected int compare(PeerState l, PeerState r) {
            long rv = l.getSendWindowBytes() - r.getSendWindowBytes();
            if (rv == 0L) {
                return super.compare(l, r);
            }
            return (int)rv;
        }
    }

    private static class SkewComparator
    extends PeerComparator {
        private static final SkewComparator _instance = new SkewComparator();

        private SkewComparator() {
        }

        public static final SkewComparator instance() {
            return _instance;
        }

        protected int compare(PeerState l, PeerState r) {
            long rv = Math.abs(l.getClockSkew()) - Math.abs(r.getClockSkew());
            if (rv == 0L) {
                return super.compare(l, r);
            }
            return (int)rv;
        }
    }

    private static class UptimeComparator
    extends PeerComparator {
        private static final UptimeComparator _instance = new UptimeComparator();

        private UptimeComparator() {
        }

        public static final UptimeComparator instance() {
            return _instance;
        }

        protected int compare(PeerState l, PeerState r) {
            long rv = r.getKeyEstablishedTime() - l.getKeyEstablishedTime();
            if (rv == 0L) {
                return super.compare(l, r);
            }
            return (int)rv;
        }
    }

    private static class RateOutComparator
    extends PeerComparator {
        private static final RateOutComparator _instance = new RateOutComparator();

        private RateOutComparator() {
        }

        public static final RateOutComparator instance() {
            return _instance;
        }

        protected int compare(PeerState l, PeerState r) {
            long rv = l.getSendBps() - r.getSendBps();
            if (rv == 0L) {
                return super.compare(l, r);
            }
            return (int)rv;
        }
    }

    private static class RateInComparator
    extends PeerComparator {
        private static final RateInComparator _instance = new RateInComparator();

        private RateInComparator() {
        }

        public static final RateInComparator instance() {
            return _instance;
        }

        protected int compare(PeerState l, PeerState r) {
            long rv = l.getReceiveBps() - r.getReceiveBps();
            if (rv == 0L) {
                return super.compare(l, r);
            }
            return (int)rv;
        }
    }

    private static class IdleOutComparator
    extends PeerComparator {
        private static final IdleOutComparator _instance = new IdleOutComparator();

        private IdleOutComparator() {
        }

        public static final IdleOutComparator instance() {
            return _instance;
        }

        protected int compare(PeerState l, PeerState r) {
            long rv = r.getLastSendTime() - l.getLastSendTime();
            if (rv == 0L) {
                return super.compare(l, r);
            }
            return (int)rv;
        }
    }

    private static class IdleInComparator
    extends PeerComparator {
        private static final IdleInComparator _instance = new IdleInComparator();

        private IdleInComparator() {
        }

        public static final IdleInComparator instance() {
            return _instance;
        }

        protected int compare(PeerState l, PeerState r) {
            long rv = r.getLastReceiveTime() - l.getLastReceiveTime();
            if (rv == 0L) {
                return super.compare(l, r);
            }
            return (int)rv;
        }
    }

    private static class AlphaComparator
    extends PeerComparator {
        private static final AlphaComparator _instance = new AlphaComparator();

        private AlphaComparator() {
        }

        public static final AlphaComparator instance() {
            return _instance;
        }
    }

    private class RemoveDropList
    implements SimpleTimer.TimedEvent {
        private RemoteHostId _peer;

        public RemoveDropList(RemoteHostId peer) {
            this._peer = peer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void timeReached() {
            List list = UDPTransport.this._dropList;
            synchronized (list) {
                UDPTransport.this._dropList.remove(this._peer);
            }
        }
    }
}

