/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.i2p.I2PAppContext;
import net.i2p.data.Base64;
import net.i2p.data.ByteArray;
import net.i2p.data.Hash;
import net.i2p.data.PrivateKey;
import net.i2p.data.PublicKey;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.BuildRequestRecord;
import net.i2p.data.i2np.BuildResponseRecord;
import net.i2p.data.i2np.TunnelBuildMessage;
import net.i2p.data.i2np.TunnelBuildReplyMessage;
import net.i2p.router.tunnel.BuildMessageGenerator;
import net.i2p.router.tunnel.BuildMessageProcessor;
import net.i2p.router.tunnel.BuildReplyHandler;
import net.i2p.router.tunnel.HopConfig;
import net.i2p.router.tunnel.TunnelCreatorConfig;
import net.i2p.util.Log;

public class BuildMessageTest {
    private Hash[] _peers;
    private PrivateKey[] _privKeys;
    private PublicKey[] _pubKeys;
    private Hash _replyRouter;
    private long _replyTunnel;

    public static void main(String[] args) {
        BuildMessageTest test = new BuildMessageTest();
        try {
            test.runTest();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void runTest() {
        I2PAppContext ctx = I2PAppContext.getGlobalContext();
        Log log = ctx.logManager().getLog(this.getClass());
        List order = BuildMessageTest.pickOrder(ctx);
        TunnelCreatorConfig cfg = this.createConfig(ctx);
        this._replyRouter = new Hash();
        byte[] h = new byte[32];
        Arrays.fill(h, (byte)-1);
        this._replyRouter.setData(h);
        this._replyTunnel = 42L;
        BuildMessageGenerator gen = new BuildMessageGenerator();
        TunnelBuildMessage msg = new TunnelBuildMessage(ctx);
        for (int i = 0; i < BuildMessageGenerator.ORDER.length; ++i) {
            int hop = (Integer)order.get(i);
            PublicKey key = null;
            if (hop < this._pubKeys.length) {
                key = this._pubKeys[hop];
            }
            gen.createRecord(i, hop, msg, cfg, this._replyRouter, this._replyTunnel, ctx, key);
        }
        gen.layeredEncrypt(ctx, msg, cfg, order);
        log.debug("\n================================================================\nMessage fully encrypted\n================================================================");
        BuildMessageProcessor proc = new BuildMessageProcessor(ctx);
        for (int i = 0; i < cfg.getLength(); ++i) {
            BuildRequestRecord req = proc.decrypt(ctx, msg, this._peers[i], this._privKeys[i]);
            if (req == null) {
                throw new RuntimeException("foo @ " + i);
            }
            long ourId = req.readReceiveTunnelId();
            byte[] replyIV = req.readReplyIV();
            long nextId = req.readNextTunnelId();
            Hash nextPeer = req.readNextIdentity();
            boolean isInGW = req.readIsInboundGateway();
            boolean isOutEnd = req.readIsOutboundEndpoint();
            long time = req.readRequestTime();
            long now = ctx.clock().now() / 3600000L * 3600000L;
            int ourSlot = -1;
            BuildResponseRecord resp = new BuildResponseRecord();
            byte[] reply = resp.create(ctx, 0, req.readReplyKey(), req.readReplyIV(), -1L);
            for (int j = 0; j < 8; ++j) {
                if (msg.getRecord(j) != null) continue;
                ourSlot = j;
                msg.setRecord(j, new ByteArray(reply));
                break;
            }
            log.debug("Read slot " + ourSlot + " containing hop " + i + " @ " + this._peers[i].toBase64() + " receives on " + ourId + " w/ replyIV " + Base64.encode((byte[])replyIV) + " sending to " + nextId + " on " + nextPeer.toBase64() + " inGW? " + isInGW + " outEnd? " + isOutEnd + " time difference " + (now - time));
        }
        log.debug("\n================================================================\nAll hops traversed and replies gathered\n================================================================");
        TunnelBuildReplyMessage reply = new TunnelBuildReplyMessage(ctx);
        for (int i = 0; i < 8; ++i) {
            reply.setRecord(i, msg.getRecord(i));
        }
        BuildReplyHandler handler = new BuildReplyHandler();
        int[] statuses = handler.decrypt(ctx, reply, cfg, order);
        if (statuses == null) {
            throw new RuntimeException("bar");
        }
        boolean allAgree = true;
        for (int i = 0; i < cfg.getLength(); ++i) {
            Hash peer = cfg.getPeer(i);
            int record = (Integer)order.get(i);
            if (statuses[record] == 0) continue;
            allAgree = false;
        }
        log.debug("\n================================================================\nAll peers agree? " + allAgree + "\n================================================================");
    }

    private static final List pickOrder(I2PAppContext ctx) {
        ArrayList<Integer> rv = new ArrayList<Integer>(8);
        rv.add(new Integer(2));
        rv.add(new Integer(4));
        rv.add(new Integer(6));
        rv.add(new Integer(0));
        rv.add(new Integer(1));
        rv.add(new Integer(3));
        rv.add(new Integer(5));
        rv.add(new Integer(7));
        return rv;
    }

    private TunnelCreatorConfig createConfig(I2PAppContext ctx) {
        return this.configOutbound(ctx);
    }

    private TunnelCreatorConfig configOutbound(I2PAppContext ctx) {
        this._peers = new Hash[4];
        this._pubKeys = new PublicKey[this._peers.length];
        this._privKeys = new PrivateKey[this._peers.length];
        for (int i = 0; i < this._peers.length; ++i) {
            Hash h;
            byte[] buf = new byte[32];
            Arrays.fill(buf, (byte)i);
            this._peers[i] = h = new Hash(buf);
            Object[] kp = ctx.keyGenerator().generatePKIKeypair();
            this._pubKeys[i] = (PublicKey)kp[0];
            this._privKeys[i] = (PrivateKey)kp[1];
        }
        TunnelCreatorConfig cfg = new TunnelCreatorConfig(null, this._peers.length, false);
        long now = ctx.clock().now();
        for (int i = 0; i < this._peers.length; ++i) {
            cfg.setPeer(i, this._peers[i]);
            HopConfig hop = cfg.getConfig(i);
            hop.setExpiration(now + 600000L);
            hop.setIVKey(ctx.keyGenerator().generateSessionKey());
            hop.setLayerKey(ctx.keyGenerator().generateSessionKey());
            hop.setReplyKey(ctx.keyGenerator().generateSessionKey());
            byte[] iv = new byte[16];
            Arrays.fill(iv, (byte)i);
            hop.setReplyIV(new ByteArray(iv));
            hop.setReceiveTunnelId(new TunnelId((long)(i + 1)));
        }
        return cfg;
    }
}

