/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel;

import net.i2p.I2PAppContext;
import net.i2p.data.Base64;
import net.i2p.router.tunnel.OutboundGatewayProcessor;
import net.i2p.router.tunnel.TunnelCreatorConfig;
import net.i2p.router.tunnel.TunnelGateway;
import net.i2p.util.Log;

public class OutboundSender
implements TunnelGateway.Sender {
    private I2PAppContext _context;
    private Log _log;
    private TunnelCreatorConfig _config;
    private OutboundGatewayProcessor _processor;
    static final boolean USE_ENCRYPTION = true;

    public OutboundSender(I2PAppContext ctx, TunnelCreatorConfig config) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(OutboundSender.class);
        this._config = config;
        this._processor = new OutboundGatewayProcessor(this._context, config);
    }

    public long sendPreprocessed(byte[] preprocessed, TunnelGateway.Receiver receiver) {
        if (this._log.shouldLog(10)) {
            this._log.debug("preprocessed data going out " + this._config + ": " + Base64.encode((byte[])preprocessed));
        }
        this._processor.process(preprocessed, 0, preprocessed.length);
        if (this._log.shouldLog(10)) {
            this._log.debug("after wrapping up the preprocessed data on " + this._config);
        }
        long rv = receiver.receiveEncrypted(preprocessed);
        if (this._log.shouldLog(10)) {
            this._log.debug("after receiving on " + this._config + ": receiver = " + receiver);
        }
        return rv;
    }
}

