/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel;

import java.util.ArrayList;
import java.util.List;
import net.i2p.I2PAppContext;
import net.i2p.data.Hash;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.router.tunnel.FlushTimer;
import net.i2p.router.tunnel.TunnelGateway;
import net.i2p.router.tunnel.TunnelGatewayPumper;
import net.i2p.util.SimpleTimer;

public class PumpedTunnelGateway
extends TunnelGateway {
    private List _prequeue = new ArrayList(4);
    private TunnelGatewayPumper _pumper;

    public PumpedTunnelGateway(I2PAppContext context, TunnelGateway.QueuePreprocessor preprocessor, TunnelGateway.Sender sender, TunnelGateway.Receiver receiver, TunnelGatewayPumper pumper) {
        super(context, preprocessor, sender, receiver);
        this._pumper = pumper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(I2NPMessage msg, Hash toRouter, TunnelId toTunnel) {
        ++this._messagesSent;
        TunnelGateway.PendingImpl cur = new TunnelGateway.PendingImpl(this, msg, toRouter, toTunnel);
        long beforeLock = System.currentTimeMillis();
        List list = this._prequeue;
        synchronized (list) {
            this._prequeue.add(cur);
        }
        this._pumper.wantsPumping(this);
        if (this._log.shouldLog(10)) {
            this._log.debug("GW prequeue time: " + (System.currentTimeMillis() - beforeLock) + " for " + msg.getUniqueId() + " on " + this.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pump(List queueBuf) {
        List list = this._prequeue;
        synchronized (list) {
            if (this._prequeue.size() <= 0) {
                return;
            }
            queueBuf.addAll(this._prequeue);
            this._prequeue.clear();
        }
        long startAdd = System.currentTimeMillis();
        long beforeLock = System.currentTimeMillis();
        long afterAdded = -1L;
        boolean delayedFlush = false;
        long delayAmount = -1L;
        int remaining = 0;
        long afterPreprocess = 0L;
        long afterExpire = 0L;
        List list2 = this._queue;
        synchronized (list2) {
            this._queue.addAll(queueBuf);
            afterAdded = System.currentTimeMillis();
            if (this._log.shouldLog(10)) {
                this._log.debug("Added before direct flush preprocessing for " + this.toString() + ": " + this._queue);
            }
            delayedFlush = this._preprocessor.preprocessQueue(this._queue, this._sender, this._receiver);
            afterPreprocess = System.currentTimeMillis();
            if (delayedFlush) {
                delayAmount = this._preprocessor.getDelayAmount();
            }
            this._lastFlush = this._context.clock().now();
            for (int i = 0; i < this._queue.size(); ++i) {
                TunnelGateway.Pending m = (TunnelGateway.Pending)this._queue.get(i);
                if (m.getExpiration() + 60000L >= this._lastFlush) continue;
                if (this._log.shouldLog(10)) {
                    this._log.debug("Expire on the queue (size=" + this._queue.size() + "): " + m);
                }
                this._queue.remove(i);
                --i;
            }
            afterExpire = System.currentTimeMillis();
            remaining = this._queue.size();
            if (remaining > 0 && this._log.shouldLog(10)) {
                this._log.debug("Remaining after preprocessing: " + this._queue);
            }
        }
        if (delayedFlush) {
            FlushTimer.getInstance().addEvent((SimpleTimer.TimedEvent)this._delayedFlush, delayAmount);
        }
        this._context.statManager().addRateData("tunnel.lockedGatewayAdd", afterAdded - beforeLock, (long)remaining);
        long complete = System.currentTimeMillis();
        if (this._log.shouldLog(10)) {
            this._log.debug("Time to add " + queueBuf.size() + " messages to " + this.toString() + ": " + (complete - startAdd) + " delayed? " + delayedFlush + " remaining: " + remaining + " prepare: " + (beforeLock - startAdd) + " add: " + (afterAdded - beforeLock) + " preprocess: " + (afterPreprocess - afterAdded) + " expire: " + (afterExpire - afterPreprocess) + " queue flush: " + (complete - afterExpire));
        }
        queueBuf.clear();
    }
}

