/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel;

import net.i2p.router.RouterContext;
import net.i2p.router.tunnel.FragmentHandler;
import net.i2p.util.Log;

public class RouterFragmentHandler
extends FragmentHandler {
    private RouterContext _routerContext;
    private Log _log;

    public RouterFragmentHandler(RouterContext context, FragmentHandler.DefragmentedReceiver receiver) {
        super(context, receiver);
        this._routerContext = context;
        this._log = context.logManager().getLog(RouterFragmentHandler.class);
    }

    protected void noteReception(long messageId, int fragmentId, Object status) {
        if (this._log.shouldLog(20)) {
            this._log.info("Received fragment " + fragmentId + " for message " + messageId + ": " + status);
        }
        this._routerContext.messageHistory().receiveTunnelFragment(messageId, fragmentId, status);
    }

    protected void noteCompletion(long messageId) {
        if (this._log.shouldLog(20)) {
            this._log.info("Received complete message " + messageId);
        }
        this._routerContext.messageHistory().receiveTunnelFragmentComplete(messageId);
    }

    protected void noteFailure(long messageId, String status) {
        if (this._log.shouldLog(20)) {
            this._log.info("Dropped message " + messageId + ": " + status);
        }
        this._routerContext.messageHistory().droppedFragmentedMessage(messageId, status);
    }
}

