/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.i2np.TunnelDataMessage;
import net.i2p.data.i2np.TunnelGatewayMessage;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.Service;
import net.i2p.router.peermanager.PeerProfile;
import net.i2p.router.tunnel.BatchedRouterPreprocessor;
import net.i2p.router.tunnel.BloomFilterIVValidator;
import net.i2p.router.tunnel.HopConfig;
import net.i2p.router.tunnel.HopProcessor;
import net.i2p.router.tunnel.InboundEndpointProcessor;
import net.i2p.router.tunnel.InboundGatewayReceiver;
import net.i2p.router.tunnel.InboundSender;
import net.i2p.router.tunnel.OutboundReceiver;
import net.i2p.router.tunnel.OutboundSender;
import net.i2p.router.tunnel.OutboundTunnelEndpoint;
import net.i2p.router.tunnel.PumpedTunnelGateway;
import net.i2p.router.tunnel.TunnelCreatorConfig;
import net.i2p.router.tunnel.TunnelGateway;
import net.i2p.router.tunnel.TunnelGatewayPumper;
import net.i2p.router.tunnel.TunnelGatewayZeroHop;
import net.i2p.router.tunnel.TunnelParticipant;
import net.i2p.stat.Rate;
import net.i2p.stat.RateStat;
import net.i2p.util.Log;

public class TunnelDispatcher
implements Service {
    private RouterContext _context;
    private Log _log;
    private Map _outboundGateways;
    private Map _outboundEndpoints;
    private Map _participants;
    private Map _inboundGateways;
    private Map _participatingConfig;
    private long _lastParticipatingExpiration;
    private BloomFilterIVValidator _validator;
    private LeaveTunnel _leaveJob;
    private long _lastDropTime;
    private TunnelGatewayPumper _pumper;
    private static final int DROP_BASE_INTERVAL = 40000;
    private static final int DROP_RANDOM_BOOST = 10000;

    public TunnelDispatcher(RouterContext ctx) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(TunnelDispatcher.class);
        this._outboundGateways = new HashMap();
        this._outboundEndpoints = new HashMap();
        this._participants = new HashMap();
        this._inboundGateways = new HashMap();
        this._participatingConfig = new HashMap();
        this._lastParticipatingExpiration = 0L;
        this._lastDropTime = 0L;
        this._validator = null;
        this._pumper = new TunnelGatewayPumper(ctx);
        this._leaveJob = new LeaveTunnel(ctx);
        ctx.statManager().createRateStat("tunnel.participatingTunnels", "How many tunnels are we participating in?", "Tunnels", new long[]{60000L, 600000L, 3600000L});
        ctx.statManager().createRateStat("tunnel.dispatchOutboundPeer", "How many messages we send out a tunnel targetting a peer?", "Tunnels", new long[]{600000L, 3600000L});
        ctx.statManager().createRateStat("tunnel.dispatchOutboundTunnel", "How many messages we send out a tunnel targetting a tunnel?", "Tunnels", new long[]{600000L, 3600000L});
        ctx.statManager().createRateStat("tunnel.dispatchInbound", "How many messages we send through our tunnel gateway?", "Tunnels", new long[]{600000L, 3600000L});
        ctx.statManager().createRateStat("tunnel.dispatchParticipant", "How many messages we send through a tunnel we are participating in?", "Tunnels", new long[]{600000L, 3600000L});
        ctx.statManager().createRateStat("tunnel.dispatchEndpoint", "How many messages we receive as the outbound endpoint of a tunnel?", "Tunnels", new long[]{600000L, 3600000L});
        ctx.statManager().createRateStat("tunnel.joinOutboundGateway", "How many tunnels we join as the outbound gateway?", "Tunnels", new long[]{600000L, 3600000L});
        ctx.statManager().createRateStat("tunnel.joinOutboundGatewayZeroHop", "How many zero hop tunnels we join as the outbound gateway?", "Tunnels", new long[]{600000L, 3600000L});
        ctx.statManager().createRateStat("tunnel.joinInboundEndpoint", "How many tunnels we join as the inbound endpoint?", "Tunnels", new long[]{600000L, 3600000L});
        ctx.statManager().createRateStat("tunnel.joinInboundEndpointZeroHop", "How many zero hop tunnels we join as the inbound endpoint?", "Tunnels", new long[]{600000L, 3600000L});
        ctx.statManager().createRateStat("tunnel.joinParticipant", "How many tunnels we join as a participant?", "Tunnels", new long[]{600000L, 3600000L});
        ctx.statManager().createRateStat("tunnel.joinOutboundEndpoint", "How many tunnels we join as the outbound endpoint?", "Tunnels", new long[]{600000L, 3600000L});
        ctx.statManager().createRateStat("tunnel.joinInboundGateway", "How many tunnels we join as the inbound gateway?", "Tunnels", new long[]{600000L, 3600000L});
        ctx.statManager().createRateStat("tunnel.dispatchGatewayTime", "How long it takes to dispatch a TunnelGatewayMessage", "Tunnels", new long[]{60000L, 3600000L});
        ctx.statManager().createRateStat("tunnel.dispatchDataTime", "How long it takes to dispatch a TunnelDataMessage", "Tunnels", new long[]{60000L, 3600000L});
        ctx.statManager().createRateStat("tunnel.dispatchOutboundTime", "How long it takes to dispatch an outbound message", "Tunnels", new long[]{60000L, 3600000L});
        ctx.statManager().createRateStat("tunnel.dispatchOutboundZeroHopTime", "How long it takes to dispatch an outbound message through a zero hop tunnel", "Tunnels", new long[]{60000L, 3600000L});
        ctx.statManager().createRateStat("tunnel.participatingBandwidth", "Participating traffic", "Tunnels", new long[]{60000L, 600000L});
        ctx.statManager().createRateStat("tunnel.participatingBandwidthOut", "Participating traffic", "Tunnels", new long[]{60000L, 600000L});
        ctx.statManager().createRateStat("tunnel.participatingMessageDropped", "Dropped for exceeding share limit", "Tunnels", new long[]{60000L, 600000L});
        ctx.statManager().createRateStat("tunnel.participatingMessageCount", "How many messages are sent through a participating tunnel?", "Tunnels", new long[]{60000L, 600000L, 3600000L});
        ctx.statManager().createRateStat("tunnel.ownedMessageCount", "How many messages are sent through a tunnel we created (period == failures)?", "Tunnels", new long[]{60000L, 600000L, 3600000L});
        ctx.statManager().createRateStat("tunnel.failedCompletelyMessages", "How many messages are sent through a tunnel that failed prematurely (period == failures)?", "Tunnels", new long[]{60000L, 600000L, 3600000L});
        ctx.statManager().createRateStat("tunnel.failedPartially", "How many messages are sent through a tunnel that only failed partially (period == failures)?", "Tunnels", new long[]{60000L, 600000L, 3600000L});
    }

    private TunnelGateway.QueuePreprocessor createPreprocessor(HopConfig cfg) {
        return new BatchedRouterPreprocessor(this._context, cfg);
    }

    private TunnelGateway.QueuePreprocessor createPreprocessor(TunnelCreatorConfig cfg) {
        return new BatchedRouterPreprocessor(this._context, cfg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void joinOutbound(TunnelCreatorConfig cfg) {
        if (this._log.shouldLog(20)) {
            this._log.info("Outbound built successfully: " + cfg);
        }
        if (cfg.getLength() > 1) {
            TunnelGateway.QueuePreprocessor preproc = this.createPreprocessor(cfg);
            OutboundSender sender = new OutboundSender(this._context, cfg);
            OutboundReceiver receiver = new OutboundReceiver(this._context, cfg);
            PumpedTunnelGateway gw = new PumpedTunnelGateway(this._context, preproc, sender, receiver, this._pumper);
            TunnelId outId = cfg.getConfig(0).getSendTunnel();
            Map map = this._outboundGateways;
            synchronized (map) {
                this._outboundGateways.put(outId, gw);
            }
            this._context.statManager().addRateData("tunnel.joinOutboundGateway", 1L, 0L);
            this._context.messageHistory().tunnelJoined("outbound", cfg);
        } else {
            TunnelGatewayZeroHop gw = new TunnelGatewayZeroHop(this._context, cfg);
            TunnelId outId = cfg.getConfig(0).getSendTunnel();
            Map map = this._outboundGateways;
            synchronized (map) {
                this._outboundGateways.put(outId, gw);
            }
            this._context.statManager().addRateData("tunnel.joinOutboundGatewayZeroHop", 1L, 0L);
            this._context.messageHistory().tunnelJoined("outboundZeroHop", cfg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void joinInbound(TunnelCreatorConfig cfg) {
        if (this._log.shouldLog(20)) {
            this._log.info("Inbound built successfully: " + cfg);
        }
        if (cfg.getLength() > 1) {
            TunnelParticipant participant = new TunnelParticipant(this._context, new InboundEndpointProcessor(this._context, cfg, this._validator));
            TunnelId recvId = cfg.getConfig(cfg.getLength() - 1).getReceiveTunnel();
            Map map = this._participants;
            synchronized (map) {
                this._participants.put(recvId, participant);
            }
            this._context.statManager().addRateData("tunnel.joinInboundEndpoint", 1L, 0L);
            this._context.messageHistory().tunnelJoined("inboundEndpoint", cfg);
        } else {
            TunnelGatewayZeroHop gw = new TunnelGatewayZeroHop(this._context, cfg);
            TunnelId recvId = cfg.getConfig(0).getReceiveTunnel();
            Map map = this._inboundGateways;
            synchronized (map) {
                this._inboundGateways.put(recvId, gw);
            }
            this._context.statManager().addRateData("tunnel.joinInboundEndpointZeroHop", 1L, 0L);
            this._context.messageHistory().tunnelJoined("inboundEndpointZeroHop", cfg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void joinParticipant(HopConfig cfg) {
        if (this._log.shouldLog(20)) {
            this._log.info("Joining as participant: " + cfg);
        }
        TunnelId recvId = cfg.getReceiveTunnel();
        TunnelParticipant participant = new TunnelParticipant(this._context, cfg, new HopProcessor(this._context, cfg, this._validator));
        Map map = this._participants;
        synchronized (map) {
            this._participants.put(recvId, participant);
        }
        map = this._participatingConfig;
        synchronized (map) {
            this._participatingConfig.put(recvId, cfg);
        }
        this._context.messageHistory().tunnelJoined("participant", cfg);
        this._context.statManager().addRateData("tunnel.joinParticipant", 1L, 0L);
        if (cfg.getExpiration() > this._lastParticipatingExpiration) {
            this._lastParticipatingExpiration = cfg.getExpiration();
        }
        this._leaveJob.add(cfg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void joinOutboundEndpoint(HopConfig cfg) {
        if (this._log.shouldLog(20)) {
            this._log.info("Joining as outbound endpoint: " + cfg);
        }
        TunnelId recvId = cfg.getReceiveTunnel();
        OutboundTunnelEndpoint endpoint = new OutboundTunnelEndpoint(this._context, cfg, new HopProcessor(this._context, cfg, this._validator));
        Map map = this._outboundEndpoints;
        synchronized (map) {
            this._outboundEndpoints.put(recvId, endpoint);
        }
        map = this._participatingConfig;
        synchronized (map) {
            this._participatingConfig.put(recvId, cfg);
        }
        this._context.messageHistory().tunnelJoined("outboundEndpoint", cfg);
        this._context.statManager().addRateData("tunnel.joinOutboundEndpoint", 1L, 0L);
        if (cfg.getExpiration() > this._lastParticipatingExpiration) {
            this._lastParticipatingExpiration = cfg.getExpiration();
        }
        this._leaveJob.add(cfg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void joinInboundGateway(HopConfig cfg) {
        if (this._log.shouldLog(20)) {
            this._log.info("Joining as inbound gateway: " + cfg);
        }
        TunnelGateway.QueuePreprocessor preproc = this.createPreprocessor(cfg);
        InboundSender sender = new InboundSender(this._context, cfg);
        InboundGatewayReceiver receiver = new InboundGatewayReceiver(this._context, cfg);
        PumpedTunnelGateway gw = new PumpedTunnelGateway(this._context, preproc, sender, receiver, this._pumper);
        TunnelId recvId = cfg.getReceiveTunnel();
        Map map = this._inboundGateways;
        synchronized (map) {
            this._inboundGateways.put(recvId, gw);
        }
        map = this._participatingConfig;
        synchronized (map) {
            this._participatingConfig.put(recvId, cfg);
        }
        this._context.messageHistory().tunnelJoined("inboundGateway", cfg);
        this._context.statManager().addRateData("tunnel.joinInboundGateway", 1L, 0L);
        if (cfg.getExpiration() > this._lastParticipatingExpiration) {
            this._lastParticipatingExpiration = cfg.getExpiration();
        }
        this._leaveJob.add(cfg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getParticipatingCount() {
        Map map = this._participatingConfig;
        synchronized (map) {
            return this._participatingConfig.size();
        }
    }

    public long getLastParticipatingExpiration() {
        return this._lastParticipatingExpiration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(TunnelCreatorConfig cfg) {
        if (cfg.isInbound()) {
            TunnelId recvId = cfg.getConfig(cfg.getLength() - 1).getReceiveTunnel();
            if (this._log.shouldLog(10)) {
                this._log.debug("removing our own inbound " + cfg);
            }
            TunnelParticipant participant = null;
            Map map = this._participants;
            synchronized (map) {
                participant = (TunnelParticipant)this._participants.remove(recvId);
            }
            if (participant == null) {
                map = this._inboundGateways;
                synchronized (map) {
                    this._inboundGateways.remove(recvId);
                }
            } else {
                for (int i = 0; i < cfg.getLength(); ++i) {
                    Hash peer = cfg.getPeer(i);
                    PeerProfile profile = this._context.profileOrganizer().getProfile(peer);
                    if (profile == null) continue;
                    int ok = participant.getCompleteCount();
                    int fail = participant.getFailedCount();
                    profile.getTunnelHistory().incrementProcessed(ok, fail);
                }
            }
        } else {
            if (this._log.shouldLog(10)) {
                this._log.debug("removing our own outbound " + cfg);
            }
            TunnelId outId = cfg.getConfig(0).getSendTunnel();
            TunnelGateway gw = null;
            Map i = this._outboundGateways;
            synchronized (i) {
                gw = (TunnelGateway)this._outboundGateways.remove(outId);
            }
            if (gw != null) {
                // empty if block
            }
        }
        long msgs = cfg.getProcessedMessagesCount();
        int failures = cfg.getTunnelFailures();
        boolean failed = cfg.getTunnelFailed();
        this._context.statManager().addRateData("tunnel.ownedMessageCount", msgs, (long)failures);
        if (failed) {
            this._context.statManager().addRateData("tunnel.failedCompletelyMessages", msgs, (long)failures);
        } else if (failures > 0) {
            this._context.statManager().addRateData("tunnel.failedPartiallyMessages", msgs, (long)failures);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(HopConfig cfg) {
        TunnelId recvId = cfg.getReceiveTunnel();
        if (this._log.shouldLog(10)) {
            this._log.debug("removing " + cfg);
        }
        boolean removed = false;
        Map map = this._participatingConfig;
        synchronized (map) {
            removed = null != this._participatingConfig.remove(recvId);
        }
        if (!removed && this._log.shouldLog(30)) {
            this._log.warn("Participating tunnel, but no longer listed in participatingConfig? " + cfg);
        }
        map = this._participants;
        synchronized (map) {
            removed = null != this._participants.remove(recvId);
        }
        if (removed) {
            return;
        }
        map = this._inboundGateways;
        synchronized (map) {
            removed = null != this._inboundGateways.remove(recvId);
        }
        if (removed) {
            return;
        }
        map = this._outboundEndpoints;
        synchronized (map) {
            removed = null != this._outboundEndpoints.remove(recvId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch(TunnelDataMessage msg, Hash recvFrom) {
        long before = System.currentTimeMillis();
        TunnelParticipant participant = null;
        Map map = this._participants;
        synchronized (map) {
            participant = (TunnelParticipant)this._participants.get(msg.getTunnelIdObj());
        }
        if (participant != null) {
            if (this._log.shouldLog(10)) {
                this._log.debug("dispatch to participant " + participant + ": " + msg.getUniqueId() + " from " + recvFrom.toBase64().substring(0, 4));
            }
            this._context.messageHistory().tunnelDispatched(msg.getUniqueId(), msg.getTunnelId(), "participant");
            participant.dispatch(msg, recvFrom);
            this._context.statManager().addRateData("tunnel.dispatchParticipant", 1L, 0L);
        } else {
            OutboundTunnelEndpoint endpoint = null;
            Map map2 = this._outboundEndpoints;
            synchronized (map2) {
                endpoint = (OutboundTunnelEndpoint)this._outboundEndpoints.get(msg.getTunnelIdObj());
            }
            if (endpoint != null) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("dispatch where we are the outbound endpoint: " + endpoint + ": " + msg + " from " + recvFrom.toBase64().substring(0, 4));
                }
                this._context.messageHistory().tunnelDispatched(msg.getUniqueId(), msg.getTunnelId(), "outbound endpoint");
                endpoint.dispatch(msg, recvFrom);
                this._context.statManager().addRateData("tunnel.dispatchEndpoint", 1L, 0L);
            } else {
                int level;
                this._context.messageHistory().droppedTunnelDataMessageUnknown(msg.getUniqueId(), msg.getTunnelId());
                int n = level = this._context.router().getUptime() > 600000L ? 30 : 10;
                if (this._log.shouldLog(level)) {
                    this._log.log(level, "no matching participant/endpoint for id=" + msg.getTunnelId() + " expiring in " + DataHelper.formatDuration((long)(msg.getMessageExpiration() - this._context.clock().now())) + ": existing = " + this._participants.size() + " / " + this._outboundEndpoints.size());
                }
            }
        }
        long dispatchTime = System.currentTimeMillis() - before;
        if (this._log.shouldLog(10)) {
            this._log.debug("Dispatch data time: " + dispatchTime + " participant? " + participant);
        }
        this._context.statManager().addRateData("tunnel.dispatchDataTime", dispatchTime, dispatchTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch(TunnelGatewayMessage msg) {
        long before = System.currentTimeMillis();
        TunnelGateway gw = null;
        Map map = this._inboundGateways;
        synchronized (map) {
            gw = (TunnelGateway)this._inboundGateways.get(msg.getTunnelId());
        }
        if (gw != null) {
            if (this._log.shouldLog(10)) {
                this._log.debug("dispatch where we are the inbound gateway: " + gw + ": " + msg);
            }
            if (msg.getMessageExpiration() < before - 60000L || msg.getMessage().getMessageExpiration() < before - 60000L) {
                if (this._log.shouldLog(40)) {
                    this._log.error("Not dispatching a gateway message for tunnel " + msg.getTunnelId().getTunnelId() + " as the wrapper's expiration is in " + DataHelper.formatDuration((long)(msg.getMessageExpiration() - before)) + " and/or the content's expiration is in " + DataHelper.formatDuration((long)(msg.getMessage().getMessageExpiration() - before)) + " with messageId " + msg.getUniqueId() + "/" + msg.getMessage().getUniqueId() + " and message type " + msg.getMessage().getClass().getName());
                }
                return;
            }
            this._context.messageHistory().tunnelDispatched(msg.getUniqueId(), msg.getMessage().getUniqueId(), msg.getTunnelId().getTunnelId(), "inbound gateway");
            gw.add(msg);
            this._context.statManager().addRateData("tunnel.dispatchInbound", 1L, 0L);
        } else {
            int level;
            this._context.messageHistory().droppedTunnelGatewayMessageUnknown(msg.getUniqueId(), msg.getTunnelId().getTunnelId());
            int n = level = this._context.router().getUptime() > 600000L ? 30 : 20;
            if (this._log.shouldLog(level)) {
                this._log.log(level, "no matching tunnel for id=" + msg.getTunnelId().getTunnelId() + ": gateway message expiring in " + DataHelper.formatDuration((long)(msg.getMessageExpiration() - this._context.clock().now())) + "/" + DataHelper.formatDuration((long)(msg.getMessage().getMessageExpiration() - this._context.clock().now())) + " messageId " + msg.getUniqueId() + "/" + msg.getMessage().getUniqueId() + " messageType: " + msg.getMessage().getClass().getName() + " existing = " + this._inboundGateways.size(), (Throwable)new Exception("source"));
            }
        }
        long dispatchTime = System.currentTimeMillis() - before;
        if (this._log.shouldLog(10)) {
            this._log.debug("Dispatch in gw time: " + dispatchTime + " gateway? " + gw);
        }
        this._context.statManager().addRateData("tunnel.dispatchGatewayTime", dispatchTime, dispatchTime);
    }

    public void dispatchOutbound(I2NPMessage msg, TunnelId outboundTunnel, Hash targetPeer) {
        this.dispatchOutbound(msg, outboundTunnel, null, targetPeer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchOutbound(I2NPMessage msg, TunnelId outboundTunnel, TunnelId targetTunnel, Hash targetPeer) {
        if (outboundTunnel == null) {
            throw new IllegalArgumentException("wtf, null outbound tunnel?");
        }
        long before = this._context.clock().now();
        TunnelGateway gw = null;
        Map map = this._outboundGateways;
        synchronized (map) {
            gw = (TunnelGateway)this._outboundGateways.get(outboundTunnel);
        }
        if (gw != null) {
            if (this._log.shouldLog(10)) {
                this._log.debug("dispatch outbound through " + outboundTunnel.getTunnelId() + ": " + msg);
            }
            if (msg.getMessageExpiration() < before - 60000L) {
                if (this._log.shouldLog(40)) {
                    this._log.error("why are you sending a tunnel message that expired " + (before - msg.getMessageExpiration()) + "ms ago? " + msg, (Throwable)new Exception("cause"));
                }
                return;
            }
            if (msg.getMessageExpiration() < before && this._log.shouldLog(30)) {
                this._log.warn("why are you sending a tunnel message that expired " + (before - msg.getMessageExpiration()) + "ms ago? " + msg, (Throwable)new Exception("cause"));
            }
            long tid1 = outboundTunnel.getTunnelId();
            long tid2 = targetTunnel != null ? targetTunnel.getTunnelId() : -1L;
            this._context.messageHistory().tunnelDispatched(msg.getUniqueId(), tid1, tid2, targetPeer, "outbound gateway");
            gw.add(msg, targetPeer, targetTunnel);
            if (targetTunnel == null) {
                this._context.statManager().addRateData("tunnel.dispatchOutboundPeer", 1L, 0L);
            } else {
                this._context.statManager().addRateData("tunnel.dispatchOutboundTunnel", 1L, 0L);
            }
        } else {
            int level;
            this._context.messageHistory().droppedTunnelGatewayMessageUnknown(msg.getUniqueId(), outboundTunnel.getTunnelId());
            int n = level = this._context.router().getUptime() > 600000L ? 40 : 30;
            if (this._log.shouldLog(level)) {
                this._log.log(level, "no matching outbound tunnel for id=" + outboundTunnel + ": existing = " + this._outboundGateways.size(), (Throwable)new Exception("src"));
            }
        }
        long dispatchTime = this._context.clock().now() - before;
        if (dispatchTime > 1000L && this._log.shouldLog(30)) {
            this._log.warn("wtf, took " + dispatchTime + " to dispatch " + msg + " out " + outboundTunnel + " in " + gw);
        }
        if (gw instanceof TunnelGatewayZeroHop) {
            this._context.statManager().addRateData("tunnel.dispatchOutboundZeroHopTime", dispatchTime, dispatchTime);
        } else {
            this._context.statManager().addRateData("tunnel.dispatchOutboundTime", dispatchTime, dispatchTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List listParticipatingTunnels() {
        Map map = this._participatingConfig;
        synchronized (map) {
            return new ArrayList(this._participatingConfig.values());
        }
    }

    public void updateParticipatingStats() {
        List participating = this.listParticipatingTunnels();
        int size = participating.size();
        long count = 0L;
        long bw = 0L;
        long bwOut = 0L;
        long tcount = 0L;
        long tooYoung = this._context.clock().now() - 60000L;
        long tooOld = tooYoung - 540000L;
        for (int i = 0; i < size; ++i) {
            HopConfig cfg = (HopConfig)participating.get(i);
            long c = cfg.getRecentMessagesCount();
            bw += c;
            bwOut += cfg.getRecentSentMessagesCount();
            long created = cfg.getCreation();
            if (created > tooYoung || created < tooOld) continue;
            ++tcount;
            count += c;
        }
        if (tcount > 0L) {
            count = count * 30L / tcount;
        }
        this._context.statManager().addRateData("tunnel.participatingMessageCount", count, 20000L);
        this._context.statManager().addRateData("tunnel.participatingBandwidth", bw * 1024L / 20L, 20000L);
        this._context.statManager().addRateData("tunnel.participatingBandwidthOut", bwOut * 1024L / 20L, 20000L);
        this._context.statManager().addRateData("tunnel.participatingTunnels", (long)size, 0L);
    }

    public boolean shouldDropParticipatingMessage() {
        boolean reject;
        float share;
        int maxKBps;
        float maxBps;
        RateStat rs = this._context.statManager().getRate("tunnel.participatingBandwidth");
        if (rs == null) {
            return false;
        }
        Rate r = rs.getRate(60000L);
        if (r == null) {
            return false;
        }
        long count = r.getLastEventCount() + 3L * r.getCurrentEventCount();
        int bw = 0;
        bw = count > 0L ? (int)((r.getLastTotalValue() + 3.0 * r.getCurrentTotalValue()) / (double)count) : (int)r.getLifetimeAverageValue();
        int usedIn = Math.min(this._context.router().get1sRateIn(), this._context.router().get15sRateIn());
        if ((usedIn = Math.min(usedIn, bw)) <= 0) {
            return false;
        }
        int usedOut = Math.min(this._context.router().get1sRate(true), this._context.router().get15sRate(true));
        if ((usedOut = Math.min(usedOut, bw)) <= 0) {
            return false;
        }
        int used = Math.min(usedIn, usedOut);
        float pctDrop = ((float)used - (maxBps = (float)(maxKBps = Math.min(this._context.bandwidthLimiter().getInboundKBytesPerSecond(), this._context.bandwidthLimiter().getOutboundKBytesPerSecond())) * (share = (float)this._context.router().getSharePercentage()) * 1024.0f * 0.95f)) / (float)used;
        if (pctDrop <= 0.0f) {
            return false;
        }
        float rand = this._context.random().nextFloat();
        boolean bl = reject = rand <= pctDrop;
        if (reject) {
            if (this._log.shouldLog(30)) {
                int availBps = (int)((float)(maxKBps * 1024) * share - (float)used);
                this._log.warn("Drop part. msg. avail/max/used " + availBps + "/" + (int)maxBps + "/" + used + " %Drop = " + pctDrop);
            }
            this._context.statManager().addRateData("tunnel.participatingMessageDropped", 1L, 0L);
        }
        return reject;
    }

    public void dropBiggestParticipating() {
        List partTunnels = this.listParticipatingTunnels();
        if (partTunnels == null || partTunnels.size() == 0) {
            if (this._log.shouldLog(40)) {
                this._log.error("Not dropping tunnel, since partTunnels was null or had 0 items!");
            }
            return;
        }
        long periodWithoutDrop = this._context.clock().now() - this._lastDropTime;
        if (periodWithoutDrop < 40000L) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Not dropping tunnel, since last drop was " + periodWithoutDrop + " ms ago!");
            }
            return;
        }
        HopConfig biggest = null;
        HopConfig current = null;
        long biggestMessages = 0L;
        long biggestAge = -1L;
        double biggestRate = 0.0;
        for (int i = 0; i < partTunnels.size(); ++i) {
            current = (HopConfig)partTunnels.get(i);
            long currentMessages = current.getProcessedMessagesCount();
            long currentAge = this._context.clock().now() - current.getCreation();
            double currentRate = (double)currentMessages / (double)(currentAge / 1000L);
            if (currentMessages <= 20L || biggest != null && !(currentRate > biggestRate)) continue;
            biggest = current;
            biggestMessages = currentMessages;
            biggestAge = currentAge;
            biggestRate = currentRate;
        }
        if (biggest == null) {
            if (this._log.shouldLog(40)) {
                this._log.error("Not dropping tunnel, since no suitable tunnel was found.");
            }
            return;
        }
        if (this._log.shouldLog(30)) {
            this._log.warn("Dropping tunnel with " + biggestRate + " messages/s and " + biggestMessages + " messages, last drop was " + periodWithoutDrop / 1000L + " s ago.");
        }
        this.remove(biggest);
        this._lastDropTime = this._context.clock().now() + (long)this._context.random().nextInt(10000);
    }

    public void startup() {
        this._validator = new BloomFilterIVValidator(this._context, 256);
    }

    public void shutdown() {
        if (this._validator != null) {
            this._validator.destroy();
        }
        this._validator = null;
        this._pumper.stopPumping();
    }

    public void restart() {
        this.shutdown();
        this.startup();
    }

    public void renderStatusHTML(Writer out) throws IOException {
    }

    private class LeaveTunnel
    extends JobImpl {
        private List _configs;
        private List _times;
        private static final int LEAVE_BATCH_TIME = 10000;

        public LeaveTunnel(RouterContext ctx) {
            super(ctx);
            this.getTiming().setStartAfter(ctx.clock().now());
            this._configs = new ArrayList(128);
            this._times = new ArrayList(128);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(HopConfig cfg) {
            Long dropTime = new Long(cfg.getExpiration() + 120000L + 10000L);
            LeaveTunnel leaveTunnel = this;
            synchronized (leaveTunnel) {
                boolean noTunnels = this._configs.size() <= 0;
                this._configs.add(cfg);
                this._times.add(dropTime);
                long oldAfter = this.getTiming().getStartAfter();
                long oldStart = this.getTiming().getActualStart();
                if (noTunnels || oldAfter <= 0L || oldAfter < this.getContext().clock().now() && oldAfter <= oldStart || oldAfter >= dropTime) {
                    this.getTiming().setStartAfter(dropTime);
                    this.getContext().jobQueue().addJob(this);
                }
            }
            if (TunnelDispatcher.this._log.shouldLog(10)) {
                long now = this.getContext().clock().now();
                TunnelDispatcher.this._log.debug("Scheduling leave in " + DataHelper.formatDuration((long)(dropTime - now)) + ": " + cfg);
            }
        }

        public String getName() {
            return "Leave participant";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runJob() {
            LeaveTunnel leaveTunnel;
            HopConfig cur = null;
            Long nextTime = null;
            long now = this.getContext().clock().now() + 10000L;
            while (true) {
                leaveTunnel = this;
                synchronized (leaveTunnel) {
                    if (this._configs.size() <= 0) {
                        return;
                    }
                    nextTime = (Long)this._times.get(0);
                    if (nextTime <= now) {
                        cur = (HopConfig)this._configs.remove(0);
                        this._times.remove(0);
                        nextTime = this._times.size() > 0 ? (Long)this._times.get(0) : null;
                    } else {
                        cur = null;
                    }
                }
                if (cur == null) break;
                TunnelDispatcher.this.remove(cur);
            }
            if (nextTime != null) {
                leaveTunnel = this;
                synchronized (leaveTunnel) {
                    this.getTiming().setStartAfter(nextTime);
                    this.getContext().jobQueue().addJob(this);
                }
            }
        }
    }
}

