/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel.pool;

import java.util.Set;
import net.i2p.data.Certificate;
import net.i2p.data.RouterInfo;
import net.i2p.data.SessionKey;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.DeliveryInstructions;
import net.i2p.data.i2np.GarlicMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.router.Job;
import net.i2p.router.JobImpl;
import net.i2p.router.MessageSelector;
import net.i2p.router.OutNetMessage;
import net.i2p.router.ReplyJob;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelInfo;
import net.i2p.router.message.GarlicMessageBuilder;
import net.i2p.router.message.PayloadGarlicConfig;
import net.i2p.util.Log;

class SendGarlicMessageJob
extends JobImpl {
    private Log _log;
    private I2NPMessage _payload;
    private RouterInfo _target;
    private MessageSelector _replySelector;
    private ReplyJob _onReply;
    private Job _onTimeout;
    private SessionKey _sentKey;
    private Set _sentTags;
    private static final boolean FORCE_ELGAMAL = false;

    public SendGarlicMessageJob(RouterContext ctx, I2NPMessage payload, RouterInfo target, MessageSelector selector, ReplyJob onReply, Job onTimeout, SessionKey sentKey, Set sentTags) {
        super(ctx);
        this._log = ctx.logManager().getLog(SendGarlicMessageJob.class);
        this._payload = payload;
        this._target = target;
        this._replySelector = selector;
        this._onReply = onReply;
        this._onTimeout = onTimeout;
        this._sentKey = sentKey;
        this._sentTags = sentTags;
    }

    public String getName() {
        return "build and send request garlic";
    }

    public void runJob() {
        TunnelInfo out;
        DeliveryInstructions instructions = new DeliveryInstructions();
        instructions.setDeliveryMode(0);
        PayloadGarlicConfig payload = new PayloadGarlicConfig();
        payload.setCertificate(new Certificate(0, null));
        payload.setId(this.getContext().random().nextLong(0xFFFFFFFFL));
        payload.setPayload(this._payload);
        payload.setRecipient(this._target);
        payload.setDeliveryInstructions(instructions);
        payload.setRequestAck(false);
        payload.setExpiration(this._payload.getMessageExpiration());
        int timeout = (int)(payload.getExpiration() - this.getContext().clock().now());
        GarlicMessage msg = null;
        msg = GarlicMessageBuilder.buildMessage(this.getContext(), payload, this._sentKey, this._sentTags);
        OutNetMessage dummyMessage = this.getContext().messageRegistry().registerPending(this._replySelector, this._onReply, this._onTimeout, timeout);
        if (this._log.shouldLog(10)) {
            this._log.debug("Scheduling timeout job (" + this._onTimeout + ") to be run in " + timeout + "ms");
        }
        if ((out = this.getContext().tunnelManager().selectOutboundTunnel()) == null) {
            if (this._onTimeout != null) {
                this.getContext().jobQueue().addJob(this._onTimeout);
            }
            this.getContext().messageRegistry().unregisterPending(dummyMessage);
            return;
        }
        TunnelId outId = out.getSendTunnelId(0);
        if (this._log.shouldLog(10)) {
            this._log.debug("Dispatching the garlic request out " + outId + " targetting " + this._target.getIdentity().calculateHash().toBase64().substring(0, 4));
        }
        this.getContext().tunnelDispatcher().dispatchOutbound(msg, outId, this._target.getIdentity().calculateHash());
    }
}

