/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel.pool;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.data.RouterInfo;
import net.i2p.data.TunnelId;
import net.i2p.router.ClientTunnelSettings;
import net.i2p.router.JobImpl;
import net.i2p.router.LoadTestManager;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelInfo;
import net.i2p.router.TunnelManagerFacade;
import net.i2p.router.TunnelPoolSettings;
import net.i2p.router.tunnel.HopConfig;
import net.i2p.router.tunnel.pool.BuildExecutor;
import net.i2p.router.tunnel.pool.ClientPeerSelector;
import net.i2p.router.tunnel.pool.ExploratoryPeerSelector;
import net.i2p.router.tunnel.pool.PooledTunnelCreatorConfig;
import net.i2p.router.tunnel.pool.TestJob;
import net.i2p.router.tunnel.pool.TunnelPool;
import net.i2p.stat.RateStat;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;

public class TunnelPoolManager
implements TunnelManagerFacade {
    private RouterContext _context;
    private Log _log;
    private Map _clientInboundPools;
    private Map _clientOutboundPools;
    private TunnelPool _inboundExploratory;
    private TunnelPool _outboundExploratory;
    private LoadTestManager _loadTestManager;
    private BuildExecutor _executor;
    private boolean _isShutdown;
    private static final String PROP_LOAD_TEST = "router.loadTest";

    public TunnelPoolManager(RouterContext ctx) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(TunnelPoolManager.class);
        this._clientInboundPools = new HashMap(4);
        this._clientOutboundPools = new HashMap(4);
        this._isShutdown = false;
        this._executor = new BuildExecutor(ctx, this);
        I2PThread execThread = new I2PThread((Runnable)this._executor, "BuildExecutor");
        execThread.setDaemon(true);
        execThread.start();
        ctx.statManager().createRateStat("tunnel.testSuccessTime", "How long do successful tunnel tests take?", "Tunnels", new long[]{60000L, 600000L, 3600000L, 10800000L, 86400000L});
        ctx.statManager().createRateStat("tunnel.participatingTunnels", "How many tunnels are we participating in?", "Tunnels", new long[]{60000L, 600000L, 3600000L, 10800000L, 86400000L});
    }

    public TunnelInfo selectInboundTunnel() {
        TunnelPool pool = this._inboundExploratory;
        if (pool == null) {
            return null;
        }
        TunnelInfo info = pool.selectTunnel();
        if (info == null) {
            this._inboundExploratory.buildFallback();
            info = this._inboundExploratory.selectTunnel();
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TunnelInfo selectInboundTunnel(Hash destination) {
        if (destination == null) {
            return this.selectInboundTunnel();
        }
        TunnelPool pool = null;
        Map map = this._clientInboundPools;
        synchronized (map) {
            pool = (TunnelPool)this._clientInboundPools.get(destination);
        }
        if (pool != null) {
            return pool.selectTunnel();
        }
        if (this._log.shouldLog(50)) {
            this._log.log(50, "wtf, want the inbound tunnel for " + destination.calculateHash().toBase64() + " but there isn't a pool?");
        }
        return null;
    }

    public TunnelInfo selectOutboundTunnel() {
        TunnelPool pool = this._outboundExploratory;
        if (pool == null) {
            return null;
        }
        TunnelInfo info = pool.selectTunnel();
        if (info == null) {
            pool.buildFallback();
            info = pool.selectTunnel();
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TunnelInfo selectOutboundTunnel(Hash destination) {
        if (destination == null) {
            return this.selectOutboundTunnel();
        }
        TunnelPool pool = null;
        Map map = this._clientOutboundPools;
        synchronized (map) {
            pool = (TunnelPool)this._clientOutboundPools.get(destination);
        }
        if (pool != null) {
            return pool.selectTunnel();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TunnelInfo getTunnelInfo(TunnelId id) {
        TunnelInfo info = null;
        Map map = this._clientInboundPools;
        synchronized (map) {
            for (TunnelPool pool : this._clientInboundPools.values()) {
                info = pool.getTunnel(id);
                if (info == null) continue;
                return info;
            }
        }
        info = this._inboundExploratory.getTunnel(id);
        if (info != null) {
            return info;
        }
        info = this._outboundExploratory.getTunnel(id);
        if (info != null) {
            return info;
        }
        return null;
    }

    public int getFreeTunnelCount() {
        if (this._inboundExploratory == null) {
            return 0;
        }
        return this._inboundExploratory.size();
    }

    public int getOutboundTunnelCount() {
        if (this._outboundExploratory == null) {
            return 0;
        }
        return this._outboundExploratory.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInboundClientTunnelCount() {
        int count = 0;
        ArrayList destinations = null;
        Map map = this._clientInboundPools;
        synchronized (map) {
            destinations = new ArrayList(this._clientInboundPools.keySet());
        }
        for (int i = 0; i < destinations.size(); ++i) {
            Hash client = (Hash)destinations.get(i);
            TunnelPool pool = null;
            Map map2 = this._clientInboundPools;
            synchronized (map2) {
                pool = (TunnelPool)this._clientInboundPools.get(client);
            }
            count += pool.listTunnels().size();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOutboundClientTunnelCount() {
        int count = 0;
        ArrayList destinations = null;
        Map map = this._clientInboundPools;
        synchronized (map) {
            destinations = new ArrayList(this._clientOutboundPools.keySet());
        }
        for (int i = 0; i < destinations.size(); ++i) {
            Hash client = (Hash)destinations.get(i);
            TunnelPool pool = null;
            Map map2 = this._clientOutboundPools;
            synchronized (map2) {
                pool = (TunnelPool)this._clientOutboundPools.get(client);
            }
            count += pool.listTunnels().size();
        }
        return count;
    }

    public int getParticipatingCount() {
        return this._context.tunnelDispatcher().getParticipatingCount();
    }

    public long getLastParticipatingExpiration() {
        return this._context.tunnelDispatcher().getLastParticipatingExpiration();
    }

    public boolean isInUse(Hash peer) {
        return true;
    }

    public boolean isValidTunnel(Hash client, TunnelInfo tunnel) {
        if (tunnel.getExpiration() < this._context.clock().now()) {
            return false;
        }
        TunnelPool pool = tunnel.isInbound() ? (TunnelPool)this._clientInboundPools.get(client) : (TunnelPool)this._clientOutboundPools.get(client);
        if (pool == null) {
            return false;
        }
        return pool.listTunnels().contains(tunnel);
    }

    public TunnelPoolSettings getInboundSettings() {
        return this._inboundExploratory.getSettings();
    }

    public TunnelPoolSettings getOutboundSettings() {
        return this._outboundExploratory.getSettings();
    }

    public void setInboundSettings(TunnelPoolSettings settings) {
        this._inboundExploratory.setSettings(settings);
    }

    public void setOutboundSettings(TunnelPoolSettings settings) {
        this._outboundExploratory.setSettings(settings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TunnelPoolSettings getInboundSettings(Hash client) {
        TunnelPool pool = null;
        Map map = this._clientInboundPools;
        synchronized (map) {
            pool = (TunnelPool)this._clientInboundPools.get(client);
        }
        if (pool != null) {
            return pool.getSettings();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TunnelPoolSettings getOutboundSettings(Hash client) {
        TunnelPool pool = null;
        Map map = this._clientOutboundPools;
        synchronized (map) {
            pool = (TunnelPool)this._clientOutboundPools.get(client);
        }
        if (pool != null) {
            return pool.getSettings();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInboundSettings(Hash client, TunnelPoolSettings settings) {
        TunnelPool pool = null;
        Map map = this._clientInboundPools;
        synchronized (map) {
            pool = (TunnelPool)this._clientInboundPools.get(client);
        }
        if (pool != null) {
            pool.setSettings(settings);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOutboundSettings(Hash client, TunnelPoolSettings settings) {
        TunnelPool pool = null;
        Map map = this._clientOutboundPools;
        synchronized (map) {
            pool = (TunnelPool)this._clientOutboundPools.get(client);
        }
        if (pool != null) {
            pool.setSettings(settings);
        }
    }

    public void restart() {
        this.shutdown();
        this.startup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildTunnels(Destination client, ClientTunnelSettings settings) {
        if (this._log.shouldLog(10)) {
            this._log.debug("Building tunnels for the client " + client.calculateHash().toBase64() + ": " + settings);
        }
        Hash dest = client.calculateHash();
        settings.getInboundSettings().setDestination(dest);
        settings.getOutboundSettings().setDestination(dest);
        TunnelPool inbound = null;
        TunnelPool outbound = null;
        Map map = this._clientInboundPools;
        synchronized (map) {
            inbound = (TunnelPool)this._clientInboundPools.get(dest);
            if (inbound == null) {
                inbound = new TunnelPool(this._context, this, settings.getInboundSettings(), new ClientPeerSelector());
                this._clientInboundPools.put(dest, inbound);
            } else {
                inbound.setSettings(settings.getInboundSettings());
            }
        }
        map = this._clientOutboundPools;
        synchronized (map) {
            outbound = (TunnelPool)this._clientOutboundPools.get(dest);
            if (outbound == null) {
                outbound = new TunnelPool(this._context, this, settings.getOutboundSettings(), new ClientPeerSelector());
                this._clientOutboundPools.put(dest, outbound);
            } else {
                outbound.setSettings(settings.getOutboundSettings());
            }
        }
        inbound.startup();
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        outbound.startup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTunnels(Hash destination) {
        if (destination == null) {
            return;
        }
        if (this._context.clientManager().isLocal(destination) && this._log.shouldLog(50)) {
            this._log.log(50, "wtf, why are you removing the pool for " + destination.toBase64(), (Throwable)new Exception("i did it"));
        }
        TunnelPool inbound = null;
        TunnelPool outbound = null;
        Map map = this._clientInboundPools;
        synchronized (map) {
            inbound = (TunnelPool)this._clientInboundPools.remove(destination);
        }
        map = this._clientOutboundPools;
        synchronized (map) {
            outbound = (TunnelPool)this._clientOutboundPools.remove(destination);
        }
        if (inbound != null) {
            inbound.shutdown();
        }
        if (outbound != null) {
            outbound.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void buildComplete(PooledTunnelCreatorConfig cfg) {
        this.buildComplete();
        if (this._loadTestManager != null) {
            this._loadTestManager.addTunnelTestCandidate(cfg);
        }
        if (cfg.getLength() > 1) {
            TunnelPool pool = cfg.getTunnelPool();
            if (pool == null) {
                this._log.error("How does this not have a pool?  " + cfg, (Throwable)new Exception("baf"));
                if (cfg.getDestination() != null) {
                    if (cfg.isInbound()) {
                        Map map = this._clientInboundPools;
                        synchronized (map) {
                            pool = (TunnelPool)this._clientInboundPools.get(cfg.getDestination());
                        }
                    } else {
                        Map map = this._clientOutboundPools;
                        synchronized (map) {
                            pool = (TunnelPool)this._clientOutboundPools.get(cfg.getDestination());
                        }
                    }
                } else {
                    pool = cfg.isInbound() ? this._inboundExploratory : this._outboundExploratory;
                }
                cfg.setTunnelPool(pool);
            }
            this._context.jobQueue().addJob(new TestJob(this._context, cfg, pool));
        }
    }

    void buildComplete() {
    }

    public void startup() {
        this._isShutdown = false;
        if (!this._executor.isRunning()) {
            I2PThread t = new I2PThread((Runnable)this._executor, "BuildExecutor");
            t.setDaemon(true);
            t.start();
        }
        ExploratoryPeerSelector selector = new ExploratoryPeerSelector();
        TunnelPoolSettings inboundSettings = new TunnelPoolSettings();
        inboundSettings.setIsExploratory(true);
        inboundSettings.setIsInbound(true);
        this._inboundExploratory = new TunnelPool(this._context, this, inboundSettings, selector);
        this._inboundExploratory.startup();
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        TunnelPoolSettings outboundSettings = new TunnelPoolSettings();
        outboundSettings.setIsExploratory(true);
        outboundSettings.setIsInbound(false);
        this._outboundExploratory = new TunnelPool(this._context, this, outboundSettings, selector);
        this._outboundExploratory.startup();
        this._context.jobQueue().addJob(new BootstrapPool(this._context, this._inboundExploratory));
        this._context.jobQueue().addJob(new BootstrapPool(this._context, this._outboundExploratory));
    }

    public void shutdown() {
        if (this._inboundExploratory != null) {
            this._inboundExploratory.shutdown();
        }
        if (this._outboundExploratory != null) {
            this._outboundExploratory.shutdown();
        }
        this._isShutdown = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void listPools(List out) {
        Map map = this._clientInboundPools;
        synchronized (map) {
            out.addAll(this._clientInboundPools.values());
        }
        map = this._clientOutboundPools;
        synchronized (map) {
            out.addAll(this._clientOutboundPools.values());
        }
        if (this._inboundExploratory != null) {
            out.add(this._inboundExploratory);
        }
        if (this._outboundExploratory != null) {
            out.add(this._outboundExploratory);
        }
    }

    void tunnelFailed() {
        this._executor.repoll();
    }

    BuildExecutor getExecutor() {
        return this._executor;
    }

    boolean isShutdown() {
        return this._isShutdown;
    }

    public int getInboundBuildQueueSize() {
        return this._executor.getInboundBuildQueueSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderStatusHTML(Writer out) throws IOException {
        out.write("<h2><a name=\"exploratory\">Exploratory tunnels</a> (<a href=\"/configtunnels.jsp#exploratory\">config</a>):</h2>\n");
        this.renderPool(out, this._inboundExploratory, this._outboundExploratory);
        ArrayList destinations = null;
        Map map = this._clientInboundPools;
        synchronized (map) {
            destinations = new ArrayList(this._clientInboundPools.keySet());
        }
        for (int i = 0; i < destinations.size(); ++i) {
            String name;
            Hash client = (Hash)destinations.get(i);
            TunnelPool in = null;
            TunnelPool outPool = null;
            Map map2 = this._clientInboundPools;
            synchronized (map2) {
                in = (TunnelPool)this._clientInboundPools.get(client);
            }
            map2 = this._clientOutboundPools;
            synchronized (map2) {
                outPool = (TunnelPool)this._clientOutboundPools.get(client);
            }
            String string = name = in != null ? in.getSettings().getDestinationNickname() : null;
            if (name == null && outPool != null) {
                name = outPool.getSettings().getDestinationNickname();
            }
            if (name == null) {
                name = client.toBase64().substring(0, 4);
            }
            out.write("<h2><a name=\"" + client.toBase64().substring(0, 4) + "\">Client tunnels</a> for " + name);
            if (this._context.clientManager().isLocal(client)) {
                out.write(" (<a href=\"/configtunnels.jsp#" + client.toBase64().substring(0, 4) + "\">config</a>):</h2>\n");
            } else {
                out.write(" (dead):</h2>\n");
            }
            this.renderPool(out, in, outPool);
        }
        List participating = this._context.tunnelDispatcher().listParticipatingTunnels();
        Collections.sort(participating, new TunnelComparator());
        out.write("<h2><a name=\"participating\">Participating tunnels</a>:</h2><table border=\"1\">\n");
        out.write("<tr><td><b>Receive on</b></td><td><b>From</b></td><td><b>Send on</b></td><td><b>To</b></td><td><b>Expiration</b></td><td><b>Usage</b></td><td><b>Rate</b></td><td><b>Role</b></td></tr>\n");
        long processed = 0L;
        RateStat rs = this._context.statManager().getRate("tunnel.participatingMessageCount");
        if (rs != null) {
            processed = (long)rs.getRate(600000L).getLifetimeTotalValue();
        }
        int inactive = 0;
        for (int i = 0; i < participating.size(); ++i) {
            HopConfig cfg = (HopConfig)participating.get(i);
            if (cfg.getProcessedMessagesCount() <= 0L) {
                ++inactive;
                continue;
            }
            out.write("<tr>");
            if (cfg.getReceiveTunnel() != null) {
                out.write("<td>" + cfg.getReceiveTunnel().getTunnelId() + "</td>");
            } else {
                out.write("<td>n/a</td>");
            }
            if (cfg.getReceiveFrom() != null) {
                out.write("<td>" + cfg.getReceiveFrom().toBase64().substring(0, 4) + "</td>");
            } else {
                out.write("<td>&nbsp;</td>");
            }
            if (cfg.getSendTunnel() != null) {
                out.write("<td>" + cfg.getSendTunnel().getTunnelId() + "</td>");
            } else {
                out.write("<td>&nbsp;</td>");
            }
            if (cfg.getSendTo() != null) {
                out.write("<td>" + cfg.getSendTo().toBase64().substring(0, 4) + "</td>");
            } else {
                out.write("<td>&nbsp;</td>");
            }
            long timeLeft = cfg.getExpiration() - this._context.clock().now();
            if (timeLeft > 0L) {
                out.write("<td align=right>" + DataHelper.formatDuration((long)timeLeft) + "</td>");
            } else {
                out.write("<td align=right>(grace period)</td>");
            }
            out.write("<td align=right>" + cfg.getProcessedMessagesCount() + "KB</td>");
            int lifetime = (int)((this._context.clock().now() - cfg.getCreation()) / 1000L);
            if (lifetime <= 0) {
                lifetime = 1;
            }
            if (lifetime > 600) {
                lifetime = 600;
            }
            int bps = 1024 * (int)cfg.getProcessedMessagesCount() / lifetime;
            out.write("<td align=right>" + bps + "Bps</td>");
            if (cfg.getSendTo() == null) {
                out.write("<td>Outbound Endpoint</td>");
            } else if (cfg.getReceiveFrom() == null) {
                out.write("<td>Inbound Gateway</td>");
            } else {
                out.write("<td>Participant</td>");
            }
            out.write("</tr>\n");
            processed += cfg.getProcessedMessagesCount();
        }
        out.write("</table>\n");
        out.write("Inactive participating tunnels: " + inactive + "<br />\n");
        out.write("Lifetime bandwidth usage: " + processed + "KB<br />\n");
    }

    private void renderPool(Writer out, TunnelPool in, TunnelPool outPool) throws IOException {
        ArrayList tunnels = null;
        tunnels = in == null ? new ArrayList() : in.listTunnels();
        if (outPool != null) {
            tunnels.addAll(outPool.listTunnels());
        }
        long processedIn = in != null ? in.getLifetimeProcessed() : 0L;
        long processedOut = outPool != null ? outPool.getLifetimeProcessed() : 0L;
        out.write("<table border=\"1\"><tr><td><b>Direction</b></td><td><b>Expiration</b></td><td><b>Usage</b></td><td align=\"left\">Hops (gateway first)</td></tr>\n");
        int live = 0;
        for (int i = 0; i < tunnels.size(); ++i) {
            TunnelInfo info = (TunnelInfo)tunnels.get(i);
            long timeLeft = info.getExpiration() - this._context.clock().now();
            if (timeLeft <= 0L) continue;
            ++live;
            if (info.isInbound()) {
                out.write("<tr><td><b>inbound</b></td>");
            } else {
                out.write("<tr><td><b>outbound</b></td>");
            }
            out.write("<td align=right>" + DataHelper.formatDuration((long)timeLeft) + "</td>\n");
            out.write("<td align=right>" + info.getProcessedMessagesCount() + "KB</td>\n");
            for (int j = 0; j < info.getLength(); ++j) {
                TunnelId id;
                Hash peer = info.getPeer(j);
                String cap = this.getCapacity(peer);
                TunnelId tunnelId = id = info.isInbound() ? info.getReceiveTunnelId(j) : info.getSendTunnelId(j);
                if (this._context.routerHash().equals((Object)peer)) {
                    out.write("<td>" + (id == null ? "" : "" + id) + "</td>");
                    continue;
                }
                out.write("<td>" + peer.toBase64().substring(0, 4) + (id == null ? "" : ":" + id) + cap + "</td>");
            }
            out.write("</tr>\n");
            if (info.isInbound()) {
                processedIn += info.getProcessedMessagesCount();
                continue;
            }
            processedOut += info.getProcessedMessagesCount();
        }
        out.write("</table>\n");
        if (in != null) {
            List pending = in.listPending();
            for (int i = 0; i < pending.size(); ++i) {
                TunnelInfo info = (TunnelInfo)pending.get(i);
                out.write("In progress: <code>" + info.toString() + "</code><br />\n");
            }
            live += pending.size();
        }
        if (outPool != null) {
            List pending = outPool.listPending();
            for (int i = 0; i < pending.size(); ++i) {
                TunnelInfo info = (TunnelInfo)pending.get(i);
                out.write("In progress: <code>" + info.toString() + "</code><br />\n");
            }
            live += pending.size();
        }
        if (live <= 0) {
            out.write("<b>No tunnels, waiting for the grace period to end</b><br />\n");
        }
        out.write("Lifetime bandwidth usage: " + processedIn + "KB in, " + processedOut + "KB out<br />");
    }

    private String getCapacity(Hash peer) {
        RouterInfo info = this._context.netDb().lookupRouterInfoLocally(peer);
        if (info != null) {
            String caps = info.getCapabilities();
            if (caps.indexOf(75) >= 0) {
                return "[&lt;12&nbsp;]";
            }
            if (caps.indexOf(76) >= 0) {
                return "[&lt;=32&nbsp;]";
            }
            if (caps.indexOf(77) >= 0) {
                return "[&lt;=64&nbsp;]";
            }
            if (caps.indexOf(78) >= 0) {
                return "<b>[&lt;=128]</b>";
            }
            if (caps.indexOf(79) >= 0) {
                return "<b>[&gt;128]</b>";
            }
            return "[old&nbsp;]";
        }
        return "[unkn]";
    }

    class TunnelComparator
    implements Comparator {
        TunnelComparator() {
        }

        public int compare(Object l, Object r) {
            return (int)(((HopConfig)r).getProcessedMessagesCount() - ((HopConfig)l).getProcessedMessagesCount());
        }
    }

    private class BootstrapPool
    extends JobImpl {
        private TunnelPool _pool;

        public BootstrapPool(RouterContext ctx, TunnelPool pool) {
            super(ctx);
            this._pool = pool;
            this.getTiming().setStartAfter(ctx.clock().now() + 30000L);
        }

        public String getName() {
            return "Bootstrap tunnel pool";
        }

        public void runJob() {
            this._pool.buildFallback();
        }
    }
}

