/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark;

public class BitField {
    private final byte[] bitfield;
    private final int size;
    private int count;

    public BitField(int size) {
        this.size = size;
        int arraysize = (size - 1) / 8 + 1;
        this.bitfield = new byte[arraysize];
        this.count = 0;
    }

    public BitField(byte[] bitfield, int size) {
        this.size = size;
        int arraysize = (size - 1) / 8 + 1;
        this.bitfield = new byte[arraysize];
        System.arraycopy(bitfield, 0, this.bitfield, 0, arraysize);
        this.count = 0;
        for (int i = 0; i < size; ++i) {
            if (!this.get(i)) continue;
            ++this.count;
        }
    }

    public byte[] getFieldBytes() {
        return this.bitfield;
    }

    public int size() {
        return this.size;
    }

    public void set(int bit) {
        if (bit < 0 || bit >= this.size) {
            throw new IndexOutOfBoundsException(Integer.toString(bit));
        }
        int index = bit / 8;
        int mask = 128 >> bit % 8;
        if ((this.bitfield[index] & mask) == 0) {
            ++this.count;
            int n = index;
            this.bitfield[n] = (byte)(this.bitfield[n] | mask);
        }
    }

    public boolean get(int bit) {
        if (bit < 0 || bit >= this.size) {
            throw new IndexOutOfBoundsException(Integer.toString(bit));
        }
        int index = bit / 8;
        int mask = 128 >> bit % 8;
        return (this.bitfield[index] & mask) != 0;
    }

    public int count() {
        return this.count;
    }

    public boolean complete() {
        return this.count >= this.size;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("BitField(");
        sb.append(this.size).append(")[");
        for (int i = 0; i < this.size; ++i) {
            if (!this.get(i)) continue;
            sb.append(' ');
            sb.append(i);
        }
        sb.append(" ]");
        return sb.toString();
    }
}

