/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.i2p.I2PAppContext;
import net.i2p.I2PException;
import net.i2p.client.I2PSession;
import net.i2p.client.streaming.I2PServerSocket;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.client.streaming.I2PSocketManager;
import net.i2p.client.streaming.I2PSocketManagerFactory;
import net.i2p.data.DataFormatException;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.util.EepGet;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer;
import org.klomp.snark.PeerID;
import org.klomp.snark.Snark;

public class I2PSnarkUtil {
    private I2PAppContext _context = I2PAppContext.getGlobalContext();
    private Log _log = this._context.logManager().getLog(Snark.class);
    private static I2PSnarkUtil _instance = new I2PSnarkUtil();
    private boolean _shouldProxy;
    private String _proxyHost;
    private int _proxyPort;
    private String _i2cpHost;
    private int _i2cpPort;
    private Map _opts = new HashMap();
    private I2PSocketManager _manager;
    private boolean _configured;
    private Set _shitlist;
    private int _maxUploaders;
    private int _maxUpBW;

    public static I2PSnarkUtil instance() {
        return _instance;
    }

    private I2PSnarkUtil() {
        this.setProxy("127.0.0.1", 4444);
        this.setI2CPConfig("127.0.0.1", 7654, null);
        this._shitlist = new HashSet(64);
        this._configured = false;
        this._maxUploaders = 10;
    }

    public void setProxy(String host, int port) {
        if (host != null && port > 0) {
            this._shouldProxy = true;
            this._proxyHost = host;
            this._proxyPort = port;
        } else {
            this._shouldProxy = false;
            this._proxyHost = null;
            this._proxyPort = -1;
        }
        this._configured = true;
    }

    public boolean configured() {
        return this._configured;
    }

    public void setI2CPConfig(String i2cpHost, int i2cpPort, Map opts) {
        this._i2cpHost = i2cpHost;
        this._i2cpPort = i2cpPort;
        if (opts != null) {
            this._opts.putAll(opts);
        }
        this._configured = true;
    }

    public void setMaxUploaders(int limit) {
        this._maxUploaders = limit;
        this._configured = true;
    }

    public void setMaxUpBW(int limit) {
        this._maxUpBW = limit;
        this._configured = true;
    }

    public String getI2CPHost() {
        return this._i2cpHost;
    }

    public int getI2CPPort() {
        return this._i2cpPort;
    }

    public Map getI2CPOptions() {
        return this._opts;
    }

    public String getEepProxyHost() {
        return this._proxyHost;
    }

    public int getEepProxyPort() {
        return this._proxyPort;
    }

    public boolean getEepProxySet() {
        return this._shouldProxy;
    }

    public int getMaxUploaders() {
        return this._maxUploaders;
    }

    public int getMaxUpBW() {
        return this._maxUpBW;
    }

    public synchronized boolean connect() {
        if (this._manager == null) {
            Properties opts = new Properties();
            if (this._opts != null) {
                for (String key : this._opts.keySet()) {
                    opts.setProperty(key, this._opts.get(key).toString());
                }
            }
            if (opts.getProperty("inbound.nickname") == null) {
                opts.setProperty("inbound.nickname", "I2PSnark");
            }
            if (opts.getProperty("outbound.nickname") == null) {
                opts.setProperty("outbound.nickname", "I2PSnark");
            }
            if (opts.getProperty("i2p.streaming.inactivityTimeout") == null) {
                opts.setProperty("i2p.streaming.inactivityTimeout", "240000");
            }
            if (opts.getProperty("i2p.streaming.inactivityAction") == null) {
                opts.setProperty("i2p.streaming.inactivityAction", "1");
            }
            if (opts.getProperty("i2p.streaming.initialWindowSize") == null) {
                opts.setProperty("i2p.streaming.initialWindowSize", "1");
            }
            if (opts.getProperty("i2p.streaming.slowStartGrowthRateFactor") == null) {
                opts.setProperty("i2p.streaming.slowStartGrowthRateFactor", "1");
            }
            this._manager = I2PSocketManagerFactory.createManager(this._i2cpHost, this._i2cpPort, opts);
        }
        return this._manager != null;
    }

    public boolean connected() {
        return this._manager != null;
    }

    public void disconnect() {
        I2PSocketManager mgr = this._manager;
        this._manager = null;
        this._shitlist.clear();
        mgr.destroySocketManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    I2PSocket connect(PeerID peer) throws IOException {
        Hash dest = peer.getAddress().calculateHash();
        Set set = this._shitlist;
        synchronized (set) {
            if (this._shitlist.contains(dest)) {
                throw new IOException("Not trying to contact " + dest.toBase64() + ", as they are shitlisted");
            }
        }
        try {
            I2PSocket rv = this._manager.connect(peer.getAddress());
            if (rv != null) {
                Set set2 = this._shitlist;
                synchronized (set2) {
                    this._shitlist.remove(dest);
                }
            }
            return rv;
        }
        catch (I2PException ie) {
            Set set3 = this._shitlist;
            synchronized (set3) {
                this._shitlist.add(dest);
            }
            SimpleTimer.getInstance().addEvent(new Unshitlist(dest), 600000L);
            throw new IOException("Unable to reach the peer " + peer + ": " + ie.getMessage());
        }
    }

    public File get(String url) {
        return this.get(url, true, 0);
    }

    public File get(String url, boolean rewrite) {
        return this.get(url, rewrite, 0);
    }

    public File get(String url, int retries) {
        return this.get(url, true, retries);
    }

    public File get(String url, boolean rewrite, int retries) {
        EepGet get;
        this._log.debug("Fetching [" + url + "] proxy=" + this._proxyHost + ":" + this._proxyPort + ": " + this._shouldProxy);
        File out = null;
        try {
            out = File.createTempFile("i2psnark", "url", new File("."));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            if (out != null) {
                out.delete();
            }
            return null;
        }
        String fetchURL = url;
        if (rewrite) {
            fetchURL = this.rewriteAnnounce(url);
        }
        if ((get = new EepGet(this._context, this._shouldProxy, this._proxyHost, this._proxyPort, retries, out.getAbsolutePath(), fetchURL)).fetch()) {
            this._log.debug("Fetch successful [" + url + "]: size=" + out.length());
            return out;
        }
        this._log.warn("Fetch failed [" + url + "]");
        out.delete();
        return null;
    }

    public I2PServerSocket getServerSocket() {
        I2PSocketManager mgr = this._manager;
        if (mgr != null) {
            return mgr.getServerSocket();
        }
        return null;
    }

    String getOurIPString() {
        Destination dest;
        if (this._manager == null) {
            return "unknown";
        }
        I2PSession sess = this._manager.getSession();
        if (sess != null && (dest = sess.getMyDestination()) != null) {
            return dest.toBase64();
        }
        return "unknown";
    }

    Destination getDestination(String ip) {
        if (ip == null) {
            return null;
        }
        if (ip.endsWith(".i2p")) {
            Destination dest;
            if (ip.length() < 520 && (dest = this._context.namingService().lookup(ip)) != null) {
                return dest;
            }
            try {
                return new Destination(ip.substring(0, ip.length() - 4));
            }
            catch (DataFormatException dfe) {
                return null;
            }
        }
        try {
            return new Destination(ip);
        }
        catch (DataFormatException dfe) {
            return null;
        }
    }

    public String lookup(String name) {
        Destination dest = this.getDestination(name);
        if (dest == null) {
            return null;
        }
        return dest.toBase64();
    }

    String rewriteAnnounce(String origAnnounce) {
        int destStart = "http://".length();
        int destEnd = origAnnounce.indexOf(".i2p");
        if (destEnd < destStart + 516) {
            return origAnnounce;
        }
        int pathStart = origAnnounce.indexOf(47, destEnd);
        String rv = "http://i2p/" + origAnnounce.substring(destStart, destEnd) + origAnnounce.substring(pathStart);
        return rv;
    }

    void debug(String msg, int snarkDebugLevel, Throwable t) {
        if (t instanceof OutOfMemoryError) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            try {
                t.printStackTrace();
            }
            catch (Throwable tt) {
                // empty catch block
            }
            try {
                System.out.println("OOM thread: " + Thread.currentThread().getName());
            }
            catch (Throwable tt) {
                // empty catch block
            }
        }
        switch (snarkDebugLevel) {
            case 0: 
            case 1: {
                this._log.error(msg, t);
                break;
            }
            case 2: {
                this._log.warn(msg, t);
                break;
            }
            case 3: 
            case 4: {
                this._log.info(msg, t);
                break;
            }
            default: {
                this._log.debug(msg, t);
            }
        }
    }

    private class Unshitlist
    implements SimpleTimer.TimedEvent {
        private Hash _dest;

        public Unshitlist(Hash dest) {
            this._dest = dest;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void timeReached() {
            Set set = I2PSnarkUtil.this._shitlist;
            synchronized (set) {
                I2PSnarkUtil.this._shitlist.remove(this._dest);
            }
        }
    }
}

