/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark;

import java.io.DataOutputStream;
import java.io.IOException;
import net.i2p.util.SimpleTimer;

class Message {
    static final byte KEEP_ALIVE = -1;
    static final byte CHOKE = 0;
    static final byte UNCHOKE = 1;
    static final byte INTERESTED = 2;
    static final byte UNINTERESTED = 3;
    static final byte HAVE = 4;
    static final byte BITFIELD = 5;
    static final byte REQUEST = 6;
    static final byte PIECE = 7;
    static final byte CANCEL = 8;
    byte type;
    int piece;
    int begin;
    int length;
    byte[] data;
    int off;
    int len;
    SimpleTimer.TimedEvent expireEvent;

    Message() {
    }

    void sendMessage(DataOutputStream dos) throws IOException {
        if (this.type == -1) {
            dos.writeInt(0);
            return;
        }
        int datalen = 1;
        if (this.type == 4 || this.type == 6 || this.type == 7 || this.type == 8) {
            datalen += 4;
        }
        if (this.type == 6 || this.type == 7 || this.type == 8) {
            datalen += 4;
        }
        if (this.type == 6 || this.type == 8) {
            datalen += 4;
        }
        if (this.type == 5 || this.type == 7) {
            datalen += this.len;
        }
        dos.writeInt(datalen);
        dos.writeByte(this.type & 0xFF);
        if (this.type == 4 || this.type == 6 || this.type == 7 || this.type == 8) {
            dos.writeInt(this.piece);
        }
        if (this.type == 6 || this.type == 7 || this.type == 8) {
            dos.writeInt(this.begin);
        }
        if (this.type == 6 || this.type == 8) {
            dos.writeInt(this.length);
        }
        if (this.type == 5 || this.type == 7) {
            dos.write(this.data, this.off, this.len);
        }
    }

    public String toString() {
        switch (this.type) {
            case -1: {
                return "KEEP_ALIVE";
            }
            case 0: {
                return "CHOKE";
            }
            case 1: {
                return "UNCHOKE";
            }
            case 2: {
                return "INTERESTED";
            }
            case 3: {
                return "UNINTERESTED";
            }
            case 4: {
                return "HAVE(" + this.piece + ")";
            }
            case 5: {
                return "BITFIELD";
            }
            case 6: {
                return "REQUEST(" + this.piece + "," + this.begin + "," + this.length + ")";
            }
            case 7: {
                return "PIECE(" + this.piece + "," + this.begin + "," + this.length + ")";
            }
            case 8: {
                return "CANCEL(" + this.piece + "," + this.begin + "," + this.length + ")";
            }
        }
        return "<UNKNOWN>";
    }
}

