/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.util.Log;
import org.klomp.snark.BitField;
import org.klomp.snark.I2PSnarkUtil;
import org.klomp.snark.MetaInfo;
import org.klomp.snark.PeerConnectionIn;
import org.klomp.snark.PeerConnectionOut;
import org.klomp.snark.PeerID;
import org.klomp.snark.PeerListener;
import org.klomp.snark.PeerState;

public class Peer
implements Comparable {
    private Log _log = new Log(Peer.class);
    private final PeerID peerID;
    private final byte[] my_id;
    final MetaInfo metainfo;
    private DataInputStream din;
    private DataOutputStream dout;
    PeerState state;
    private I2PSocket sock;
    private boolean deregister = true;
    private static long __id;
    private long _id;
    static final long CHECK_PERIOD = 40000L;
    static final int RATE_DEPTH = 6;
    private long[] uploaded_old = new long[]{-1L, -1L, -1L, -1L, -1L, -1L};
    private long[] downloaded_old = new long[]{-1L, -1L, -1L, -1L, -1L, -1L};

    public Peer(PeerID peerID, byte[] my_id, MetaInfo metainfo) throws IOException {
        this.peerID = peerID;
        this.my_id = my_id;
        this.metainfo = metainfo;
        this._id = ++__id;
    }

    public Peer(I2PSocket sock, InputStream in, OutputStream out, byte[] my_id, MetaInfo metainfo) throws IOException {
        this.my_id = my_id;
        this.metainfo = metainfo;
        this.sock = sock;
        byte[] id = this.handshake(in, out);
        this.peerID = new PeerID(id, sock.getPeerDestination());
        this._id = ++__id;
        this._log.debug("Creating a new peer with " + this.peerID.getAddress().calculateHash().toBase64(), new Exception("creating " + this._id));
    }

    public PeerID getPeerID() {
        return this.peerID;
    }

    public String toString() {
        if (this.peerID != null) {
            return this.peerID.toString() + ' ' + this._id;
        }
        return "[unknown id] " + this._id;
    }

    public String getSocket() {
        return this.sock.toString();
    }

    public int hashCode() {
        return this.peerID.hashCode() ^ 2 << (int)this._id;
    }

    public boolean equals(Object o) {
        if (o instanceof Peer) {
            Peer p = (Peer)o;
            return this._id == p._id && this.peerID.equals(p.peerID);
        }
        return false;
    }

    public int compareTo(Object o) {
        Peer p = (Peer)o;
        int rv = this.peerID.compareTo(p.peerID);
        if (rv == 0) {
            if (this._id > p._id) {
                return 1;
            }
            if (this._id < p._id) {
                return -1;
            }
            return 0;
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runConnection(PeerListener listener, BitField bitfield) {
        if (this.state != null) {
            throw new IllegalStateException("Peer already started");
        }
        this._log.debug("Running connection to " + this.peerID.getAddress().calculateHash().toBase64(), new Exception("connecting"));
        try {
            Object out;
            Object in;
            if (this.din == null) {
                this.sock = I2PSnarkUtil.instance().connect(this.peerID);
                this._log.debug("Connected to " + this.peerID + ": " + this.sock);
                if (this.sock == null || this.sock.isClosed()) {
                    throw new IOException("Unable to reach " + this.peerID);
                }
                in = this.sock.getInputStream();
                out = this.sock.getOutputStream();
                in = new BufferedInputStream(this.sock.getInputStream());
                byte[] id = this.handshake((InputStream)in, (OutputStream)out);
                byte[] expected_id = this.peerID.getID();
                if (!Arrays.equals(expected_id, id)) {
                    throw new IOException("Unexpected peerID '" + PeerID.idencode(id) + "' expected '" + PeerID.idencode(expected_id) + "'");
                }
                this._log.debug("Handshake got matching IDs with " + this.toString());
            } else {
                this._log.debug("Already have din [" + this.sock + "] with " + this.toString());
            }
            in = new PeerConnectionIn(this, this.din);
            out = new PeerConnectionOut(this, this.dout);
            PeerState s = new PeerState(this, listener, this.metainfo, (PeerConnectionIn)in, (PeerConnectionOut)out);
            if (bitfield != null) {
                s.out.sendBitfield(bitfield);
            }
            this.state = s;
            listener.connected(this);
            this._log.debug("Start running the reader with " + this.toString());
            ((PeerConnectionOut)out).startup();
            Thread.currentThread().setName("Snark reader from " + this.peerID);
            s.in.run();
        }
        catch (IOException eofe) {
            if (this._log.shouldLog(10)) {
                this._log.debug(this.toString(), eofe);
            }
        }
        catch (Throwable t) {
            this._log.error(this + ": " + t.getMessage(), t);
            if (t instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)t;
            }
        }
        finally {
            if (this.deregister) {
                listener.disconnected(this);
            }
            this.disconnect();
        }
    }

    private byte[] handshake(InputStream in, OutputStream out) throws IOException {
        this.din = new DataInputStream(in);
        this.dout = new DataOutputStream(out);
        this.dout.write(19);
        this.dout.write("BitTorrent protocol".getBytes("UTF-8"));
        byte[] zeros = new byte[8];
        this.dout.write(zeros);
        byte[] shared_hash = this.metainfo.getInfoHash();
        this.dout.write(shared_hash);
        this.dout.write(this.my_id);
        this.dout.flush();
        this._log.debug("Wrote my shared hash and ID to " + this.toString());
        byte b = this.din.readByte();
        if (b != 19) {
            throw new IOException("Handshake failure, expected 19, got " + (b & 0xFF) + " on " + this.sock);
        }
        byte[] bs = new byte[19];
        this.din.readFully(bs);
        String bittorrentProtocol = new String(bs, "UTF-8");
        if (!"BitTorrent protocol".equals(bittorrentProtocol)) {
            throw new IOException("Handshake failure, expected 'Bittorrent protocol', got '" + bittorrentProtocol + "'");
        }
        this.din.readFully(zeros);
        bs = new byte[20];
        this.din.readFully(bs);
        if (!Arrays.equals(shared_hash, bs)) {
            throw new IOException("Unexpected MetaInfo hash");
        }
        this.din.readFully(bs);
        this._log.debug("Read the remote side's hash and peerID fully from " + this.toString());
        return bs;
    }

    public boolean isConnected() {
        return this.state != null;
    }

    public void disconnect(boolean deregister) {
        this.deregister = deregister;
        this.disconnect();
    }

    void disconnect() {
        PeerState s = this.state;
        if (s != null) {
            PeerListener pl;
            PeerConnectionOut out;
            PeerListener p;
            if (this.deregister && (p = s.listener) != null) {
                p.savePeerPartial(s);
                p.markUnrequested(this);
            }
            this.state = null;
            PeerConnectionIn in = s.in;
            if (in != null) {
                in.disconnect();
            }
            if ((out = s.out) != null) {
                out.disconnect();
            }
            if ((pl = s.listener) != null) {
                pl.disconnected(this);
            }
        }
        I2PSocket csock = this.sock;
        this.sock = null;
        if (csock != null && !csock.isClosed()) {
            try {
                csock.close();
            }
            catch (IOException ioe) {
                this._log.warn("Error disconnecting " + this.toString(), ioe);
            }
        }
    }

    public void have(int piece) {
        PeerState s = this.state;
        if (s != null) {
            s.havePiece(piece);
        }
    }

    public boolean isInterested() {
        PeerState s = this.state;
        return s != null && s.interested;
    }

    public void setInteresting(boolean interest) {
        PeerState s = this.state;
        if (s != null) {
            s.setInteresting(interest);
        }
    }

    public boolean isInteresting() {
        PeerState s = this.state;
        return s != null && s.interesting;
    }

    public void setChoking(boolean choke) {
        PeerState s = this.state;
        if (s != null) {
            s.setChoking(choke);
        }
    }

    public boolean isChoking() {
        PeerState s = this.state;
        return s == null || s.choking;
    }

    public boolean isChoked() {
        PeerState s = this.state;
        return s == null || s.choked;
    }

    public long getDownloaded() {
        PeerState s = this.state;
        return s != null ? s.downloaded : 0L;
    }

    public long getUploaded() {
        PeerState s = this.state;
        return s != null ? s.uploaded : 0L;
    }

    public void resetCounters() {
        PeerState s = this.state;
        if (s != null) {
            s.downloaded = 0L;
            s.uploaded = 0L;
        }
    }

    public long getInactiveTime() {
        PeerState s = this.state;
        if (s != null) {
            PeerConnectionIn in = s.in;
            PeerConnectionOut out = s.out;
            if (in != null && out != null) {
                long now = System.currentTimeMillis();
                return Math.max(now - out.lastSent, now - in.lastRcvd);
            }
            return -1L;
        }
        return -1L;
    }

    public void keepAlive() {
        PeerState s = this.state;
        if (s != null) {
            s.keepAlive();
        }
    }

    public void retransmitRequests() {
        PeerState s = this.state;
        if (s != null) {
            s.retransmitRequests();
        }
    }

    public int completed() {
        PeerState s = this.state;
        if (s == null || s.bitfield == null) {
            return 0;
        }
        return s.bitfield.count();
    }

    public boolean isCompleted() {
        PeerState s = this.state;
        if (s == null || s.bitfield == null) {
            return false;
        }
        return s.bitfield.complete();
    }

    public void setRateHistory(long up, long down) {
        this.setRate(up, this.uploaded_old);
        this.setRate(down, this.downloaded_old);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRate(long val, long[] array) {
        long[] lArray = array;
        synchronized (array) {
            for (int i = 5; i > 0; --i) {
                array[i] = array[i - 1];
            }
            array[0] = val;
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return;
        }
    }

    public long getUploadRate() {
        return this.getRate(this.uploaded_old);
    }

    public long getDownloadRate() {
        return this.getRate(this.downloaded_old);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getRate(long[] array) {
        long rate = 0L;
        long[] lArray = array;
        synchronized (array) {
            int i;
            for (i = 0; i < 6 && array[i] >= 0L; ++i) {
                rate += array[i];
            }
            // ** MonitorExit[var5_4] (shouldn't be in output)
            if (i == 0) {
                return 0L;
            }
            return rate / ((long)i * 40000L / 1000L);
        }
    }
}

