/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.TimerTask;
import org.klomp.snark.Peer;
import org.klomp.snark.PeerCoordinator;
import org.klomp.snark.Snark;

class PeerCheckerTask
extends TimerTask {
    private final long KILOPERSECOND = 40960L;
    private final PeerCoordinator coordinator;
    private Random random = new Random();

    PeerCheckerTask(PeerCoordinator coordinator) {
        this.coordinator = coordinator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        List list = this.coordinator.peers;
        synchronized (list) {
            Iterator it = this.coordinator.peers.iterator();
            if (!it.hasNext() || this.coordinator.halted()) {
                this.coordinator.peerCount = 0;
                this.coordinator.interestedAndChoking = 0;
                this.coordinator.setRateHistory(0L, 0L);
                this.coordinator.uploaders = 0;
                if (this.coordinator.halted()) {
                    this.cancel();
                }
                return;
            }
            long worstdownload = Long.MAX_VALUE;
            Peer worstDownloader = null;
            int peers = 0;
            int uploaders = 0;
            int downloaders = 0;
            int removedCount = 0;
            long uploaded = 0L;
            long downloaded = 0L;
            ArrayList<Peer> removed = new ArrayList<Peer>();
            int uploadLimit = this.coordinator.allowedUploaders();
            boolean overBWLimit = this.coordinator.overUpBWLimit();
            while (it.hasNext()) {
                boolean overBWLimitChoke;
                Peer peer = (Peer)it.next();
                if (!peer.isConnected()) {
                    it.remove();
                    this.coordinator.removePeerFromPieces(peer);
                    this.coordinator.peerCount = this.coordinator.peers.size();
                    continue;
                }
                ++peers;
                if (!peer.isChoking()) {
                    ++uploaders;
                }
                if (!peer.isChoked() && peer.isInteresting()) {
                    ++downloaders;
                }
                long upload = peer.getUploaded();
                uploaded += upload;
                long download = peer.getDownloaded();
                downloaded += download;
                peer.setRateHistory(upload, download);
                peer.resetCounters();
                Snark.debug(peer + ":", 5);
                Snark.debug(" ul: " + upload / 40960L + " dl: " + download / 40960L + " i: " + peer.isInterested() + " I: " + peer.isInteresting() + " c: " + peer.isChoking() + " C: " + peer.isChoked(), 5);
                boolean bl = overBWLimitChoke = upload > 0L && (overBWLimit && this.random.nextBoolean() || this.coordinator.overUpBWLimit(uploaded));
                if ((this.coordinator.uploaders == uploadLimit && this.coordinator.interestedAndChoking > 0 || this.coordinator.uploaders > uploadLimit || overBWLimitChoke) && !peer.isChoking()) {
                    if (!peer.isInterested()) {
                        Snark.debug("Choke uninterested peer: " + peer, 4);
                        peer.setChoking(true);
                        --uploaders;
                        --this.coordinator.uploaders;
                        it.remove();
                        removed.add(peer);
                    } else if (overBWLimitChoke) {
                        Snark.debug("BW limit (" + upload + "/" + uploaded + "), choke peer: " + peer, 4);
                        peer.setChoking(true);
                        --uploaders;
                        --this.coordinator.uploaders;
                        ++removedCount;
                        it.remove();
                        removed.add(peer);
                    } else if (peer.isInteresting() && peer.isChoked()) {
                        Snark.debug("Choke choking peer: " + peer, 5);
                        peer.setChoking(true);
                        --uploaders;
                        --this.coordinator.uploaders;
                        ++removedCount;
                        it.remove();
                        removed.add(peer);
                    } else if (!peer.isInteresting() && !this.coordinator.completed()) {
                        Snark.debug("Choke uninteresting peer: " + peer, 5);
                        peer.setChoking(true);
                        --uploaders;
                        --this.coordinator.uploaders;
                        ++removedCount;
                        it.remove();
                        removed.add(peer);
                    } else if (peer.isInteresting() && !peer.isChoked() && download == 0L) {
                        Snark.debug("Choke downloader that doesn't deliver:" + peer, 5);
                        peer.setChoking(true);
                        --uploaders;
                        --this.coordinator.uploaders;
                        ++removedCount;
                        it.remove();
                        removed.add(peer);
                    } else if (peer.isInteresting() && !peer.isChoked() && download < worstdownload) {
                        worstdownload = download;
                        worstDownloader = peer;
                    } else if (upload < worstdownload && this.coordinator.completed()) {
                        worstdownload = upload;
                        worstDownloader = peer;
                    }
                }
                peer.retransmitRequests();
                peer.keepAlive();
            }
            this.coordinator.uploaders = uploaders;
            if ((uploaders == uploadLimit && this.coordinator.interestedAndChoking > 0 || uploaders > uploadLimit) && worstDownloader != null) {
                Snark.debug("Choke worst downloader: " + worstDownloader, 5);
                worstDownloader.setChoking(true);
                --this.coordinator.uploaders;
                ++removedCount;
                this.coordinator.peers.remove(worstDownloader);
                this.coordinator.peerCount = this.coordinator.peers.size();
                removed.add(worstDownloader);
            }
            if (!overBWLimit && !this.coordinator.overUpBWLimit(uploaded)) {
                this.coordinator.unchokePeer();
            }
            this.coordinator.peers.addAll(removed);
            this.coordinator.peerCount = this.coordinator.peers.size();
            this.coordinator.interestedAndChoking += removedCount;
            this.coordinator.setRateHistory(uploaded, downloaded);
        }
    }
}

