/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark;

import java.io.IOException;
import net.i2p.util.I2PThread;
import org.klomp.snark.ConnectionAcceptor;
import org.klomp.snark.I2PSnarkUtil;
import org.klomp.snark.PeerCoordinator;
import org.klomp.snark.ShutdownListener;
import org.klomp.snark.Snark;
import org.klomp.snark.Storage;
import org.klomp.snark.TrackerClient;

public class SnarkShutdown
extends I2PThread {
    private final Storage storage;
    private final PeerCoordinator coordinator;
    private final ConnectionAcceptor acceptor;
    private final TrackerClient trackerclient;
    private final ShutdownListener listener;

    public SnarkShutdown(Storage storage, PeerCoordinator coordinator, ConnectionAcceptor acceptor, TrackerClient trackerclient, ShutdownListener listener) {
        this.storage = storage;
        this.coordinator = coordinator;
        this.acceptor = acceptor;
        this.trackerclient = trackerclient;
        this.listener = listener;
    }

    public void run() {
        Snark.debug("Shutting down...", 3);
        Snark.debug("Halting ConnectionAcceptor...", 4);
        if (this.acceptor != null) {
            this.acceptor.halt();
        }
        Snark.debug("Halting TrackerClient...", 4);
        if (this.trackerclient != null) {
            this.trackerclient.halt();
        }
        Snark.debug("Halting PeerCoordinator...", 4);
        if (this.coordinator != null) {
            this.coordinator.halt();
        }
        Snark.debug("Closing Storage...", 4);
        if (this.storage != null) {
            try {
                this.storage.close();
            }
            catch (IOException ioe) {
                I2PSnarkUtil.instance().debug("Couldn't properly close storage", 1, ioe);
                throw new RuntimeException("b0rking");
            }
        }
        try {
            Snark.debug("Waiting 5 seconds...", 4);
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.listener.shutdown();
    }
}

