/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import net.i2p.crypto.SHA1;
import org.klomp.snark.BitField;
import org.klomp.snark.I2PSnarkUtil;
import org.klomp.snark.MetaInfo;
import org.klomp.snark.Snark;
import org.klomp.snark.SnarkManager;
import org.klomp.snark.StorageListener;

public class Storage {
    private MetaInfo metainfo;
    private long[] lengths;
    private RandomAccessFile[] rafs;
    private String[] names;
    private final StorageListener listener;
    private BitField bitfield;
    private int needed;
    int piece_size;
    int pieces;
    boolean changed;
    private static int MIN_PIECE_SIZE = 262144;
    private static int MAX_PIECE_SIZE = 0x100000;
    private static long MAX_PIECES = 5120L;

    public Storage(MetaInfo metainfo, StorageListener listener) throws IOException {
        this.metainfo = metainfo;
        this.listener = listener;
        this.needed = metainfo.getPieces();
        this.bitfield = new BitField(this.needed);
    }

    public Storage(File baseFile, String announce, StorageListener listener) throws IOException {
        this.listener = listener;
        this.getFiles(baseFile);
        long total = 0L;
        ArrayList<Long> lengthsList = new ArrayList<Long>();
        for (int i = 0; i < this.lengths.length; ++i) {
            long length = this.lengths[i];
            total += length;
            lengthsList.add(new Long(length));
        }
        this.piece_size = MIN_PIECE_SIZE;
        this.pieces = (int)((total - 1L) / (long)this.piece_size) + 1;
        while ((long)this.pieces > MAX_PIECES && this.piece_size < MAX_PIECE_SIZE) {
            this.piece_size *= 2;
            this.pieces = (int)((total - 1L) / (long)this.piece_size) + 1;
        }
        byte[] piece_hashes = new byte[20 * this.pieces];
        this.bitfield = new BitField(this.pieces);
        this.needed = 0;
        ArrayList files = new ArrayList();
        for (int i = 0; i < this.names.length; ++i) {
            ArrayList<String> file = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(this.names[i], File.separator);
            while (st.hasMoreTokens()) {
                String part = st.nextToken();
                file.add(part);
            }
            files.add(file);
        }
        String name = baseFile.getName();
        if (files.size() == 1) {
            files = null;
            lengthsList = null;
        }
        this.metainfo = new MetaInfo(announce, baseFile.getName(), null, files, lengthsList, this.piece_size, piece_hashes, total);
    }

    public void create() throws IOException {
        this.fast_digestCreate();
    }

    private void fast_digestCreate() throws IOException {
        SHA1 digest = new SHA1();
        byte[] piece_hashes = this.metainfo.getPieceHashes();
        byte[] piece = new byte[this.piece_size];
        for (int i = 0; i < this.pieces; ++i) {
            int length = this.getUncheckedPiece(i, piece);
            digest.update(piece, 0, length);
            byte[] hash = digest.digest();
            for (int j = 0; j < 20; ++j) {
                piece_hashes[20 * i + j] = hash[j];
            }
            this.bitfield.set(i);
            if (this.listener == null) continue;
            this.listener.storageChecked(this, i, true);
        }
        if (this.listener != null) {
            this.listener.storageAllChecked(this);
        }
        this.metainfo = this.metainfo.reannounce(this.metainfo.getAnnounce());
    }

    private void getFiles(File base) throws IOException {
        ArrayList files = new ArrayList();
        Storage.addFiles(files, base);
        int size = files.size();
        this.names = new String[size];
        this.lengths = new long[size];
        this.rafs = new RandomAccessFile[size];
        int i = 0;
        for (File f : files) {
            this.names[i] = f.getPath();
            if (base.isDirectory() && this.names[i].startsWith(base.getPath())) {
                this.names[i] = this.names[i].substring(base.getPath().length() + 1);
            }
            this.lengths[i] = f.length();
            this.rafs[i] = new RandomAccessFile(f, "r");
            ++i;
        }
    }

    private static void addFiles(List l, File f) {
        if (!f.isDirectory()) {
            l.add(f);
        } else {
            File[] files = f.listFiles();
            if (files == null) {
                Snark.debug("WARNING: Skipping '" + f + "' not a normal file.", 2);
                return;
            }
            for (int i = 0; i < files.length; ++i) {
                Storage.addFiles(l, files[i]);
            }
        }
    }

    public MetaInfo getMetaInfo() {
        return this.metainfo;
    }

    public int needed() {
        return this.needed;
    }

    public boolean complete() {
        return this.needed == 0;
    }

    public BitField getBitField() {
        return this.bitfield;
    }

    public void check(String rootDir) throws IOException {
        File base = new File(rootDir, Storage.filterName(this.metainfo.getName()));
        long savedTime = SnarkManager.instance().getSavedTorrentTime(this.metainfo);
        BitField savedBitField = SnarkManager.instance().getSavedTorrentBitField(this.metainfo);
        boolean useSavedBitField = savedTime > 0L && savedBitField != null;
        List files = this.metainfo.getFiles();
        if (files == null) {
            long lm;
            Snark.debug("Creating/Checking file: " + base, 3);
            if (!base.createNewFile() && !base.exists()) {
                throw new IOException("Could not create file " + base);
            }
            this.lengths = new long[1];
            this.rafs = new RandomAccessFile[1];
            this.names = new String[1];
            this.lengths[0] = this.metainfo.getTotalLength();
            if (useSavedBitField && ((lm = base.lastModified()) <= 0L || lm > savedTime)) {
                useSavedBitField = false;
            }
            this.rafs[0] = base.exists() && (useSavedBitField && savedBitField.complete() || !base.canWrite()) ? new RandomAccessFile(base, "r") : new RandomAccessFile(base, "rw");
            this.names[0] = base.getName();
        } else {
            Snark.debug("Creating/Checking directory: " + base, 3);
            if (!base.mkdir() && !base.isDirectory()) {
                throw new IOException("Could not create directory " + base);
            }
            List ls = this.metainfo.getLengths();
            int size = files.size();
            long total = 0L;
            this.lengths = new long[size];
            this.rafs = new RandomAccessFile[size];
            this.names = new String[size];
            for (int i = 0; i < size; ++i) {
                long lm;
                File f = this.createFileFromNames(base, (List)files.get(i));
                this.lengths[i] = (Long)ls.get(i);
                total += this.lengths[i];
                if (useSavedBitField && ((lm = base.lastModified()) <= 0L || lm > savedTime)) {
                    useSavedBitField = false;
                }
                this.rafs[i] = f.exists() && (useSavedBitField && savedBitField.complete() || !f.canWrite()) ? new RandomAccessFile(f, "r") : new RandomAccessFile(f, "rw");
                this.names[i] = f.getName();
            }
            long metalength = this.metainfo.getTotalLength();
            if (total != metalength) {
                throw new IOException("File lengths do not add up " + total + " != " + metalength);
            }
        }
        if (useSavedBitField) {
            this.bitfield = savedBitField;
            this.needed = this.metainfo.getPieces() - this.bitfield.count();
            Snark.debug("Found saved state and files unchanged, skipping check", 3);
        } else {
            this.checkCreateFiles();
            SnarkManager.instance().saveTorrentStatus(this.metainfo, this.bitfield);
        }
    }

    public void reopen(String rootDir) throws IOException {
        File base = new File(rootDir, Storage.filterName(this.metainfo.getName()));
        List files = this.metainfo.getFiles();
        if (files == null) {
            Snark.debug("Reopening file: " + base, 3);
            if (!base.exists()) {
                throw new IOException("Could not reopen file " + base);
            }
            this.rafs[0] = this.complete() || !base.canWrite() ? new RandomAccessFile(base, "r") : new RandomAccessFile(base, "rw");
        } else {
            Snark.debug("Reopening directory: " + base, 3);
            if (!base.isDirectory()) {
                throw new IOException("Could not reopen directory " + base);
            }
            int size = files.size();
            for (int i = 0; i < size; ++i) {
                File f = Storage.getFileFromNames(base, (List)files.get(i));
                if (!f.exists()) {
                    throw new IOException("Could not reopen file " + f);
                }
                this.rafs[i] = this.complete() || !f.canWrite() ? new RandomAccessFile(f, "r") : new RandomAccessFile(f, "rw");
            }
        }
    }

    private static String filterName(String name) {
        return name.replace(File.separatorChar, '_');
    }

    private File createFileFromNames(File base, List names) throws IOException {
        File f = null;
        Iterator it = names.iterator();
        while (it.hasNext()) {
            String name = Storage.filterName((String)it.next());
            if (it.hasNext()) {
                f = new File(base, name);
                if (!f.mkdir() && !f.isDirectory()) {
                    throw new IOException("Could not create directory " + f);
                }
                base = f;
                continue;
            }
            f = new File(base, name);
            if (f.createNewFile() || f.exists()) continue;
            throw new IOException("Could not create file " + f);
        }
        return f;
    }

    public static File getFileFromNames(File base, List names) {
        Iterator it = names.iterator();
        while (it.hasNext()) {
            String name = Storage.filterName((String)it.next());
            base = new File(base, name);
        }
        return base;
    }

    private void checkCreateFiles() throws IOException {
        boolean resume = false;
        for (int i = 0; i < this.rafs.length; ++i) {
            long length = this.rafs[i].length();
            if (length == this.lengths[i]) {
                if (this.listener != null) {
                    this.listener.storageAllocated(this, length);
                }
                resume = true;
                continue;
            }
            if (length == 0L) {
                this.allocateFile(i);
                continue;
            }
            Snark.debug("File '" + this.names[i] + "' exists, but has wrong length - repairing corruption", 1);
            this.rafs[i].setLength(this.lengths[i]);
        }
        if (resume) {
            this.pieces = this.metainfo.getPieces();
            byte[] piece = new byte[this.metainfo.getPieceLength(0)];
            for (int i = 0; i < this.pieces; ++i) {
                int length = this.getUncheckedPiece(i, piece);
                boolean correctHash = this.metainfo.checkPiece(i, piece, 0, length);
                if (correctHash) {
                    this.bitfield.set(i);
                    --this.needed;
                }
                if (this.listener == null) continue;
                this.listener.storageChecked(this, i, correctHash);
            }
        }
        if (this.listener != null) {
            this.listener.storageAllChecked(this);
            if (this.needed <= 0) {
                this.listener.storageCompleted(this);
            }
        }
    }

    private void allocateFile(int nr) throws IOException {
        this.listener.storageCreateFile(this, this.names[nr], this.lengths[nr]);
        int ZEROBLOCKSIZE = this.metainfo.getPieceLength(0);
        byte[] zeros = new byte[ZEROBLOCKSIZE];
        int i = 0;
        while ((long)i < this.lengths[nr] / (long)ZEROBLOCKSIZE) {
            this.rafs[nr].write(zeros);
            if (this.listener != null) {
                this.listener.storageAllocated(this, ZEROBLOCKSIZE);
            }
            ++i;
        }
        int size = (int)(this.lengths[nr] - (long)(i * ZEROBLOCKSIZE));
        this.rafs[nr].write(zeros, 0, size);
        if (this.listener != null) {
            this.listener.storageAllocated(this, size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.rafs == null) {
            return;
        }
        for (int i = 0; i < this.rafs.length; ++i) {
            try {
                RandomAccessFile randomAccessFile = this.rafs[i];
                synchronized (randomAccessFile) {
                    this.rafs[i].close();
                    continue;
                }
            }
            catch (IOException ioe) {
                I2PSnarkUtil.instance().debug("Error closing " + this.rafs[i], 1, ioe);
            }
        }
        this.changed = false;
    }

    public byte[] getPiece(int piece, int off, int len) throws IOException {
        byte[] bs;
        if (!this.bitfield.get(piece)) {
            return null;
        }
        try {
            bs = new byte[len];
        }
        catch (OutOfMemoryError oom) {
            I2PSnarkUtil.instance().debug("Out of memory, can't honor request for piece " + piece, 2, oom);
            return null;
        }
        this.getUncheckedPiece(piece, bs, off, len);
        return bs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putPiece(int piece, byte[] ba) throws IOException {
        int len;
        long start;
        boolean complete;
        byte[] bs = (byte[])ba.clone();
        int length = bs.length;
        boolean correctHash = this.metainfo.checkPiece(piece, bs, 0, length);
        if (this.listener != null) {
            this.listener.storageChecked(this, piece, correctHash);
        }
        if (!correctHash) {
            return false;
        }
        BitField bitField = this.bitfield;
        synchronized (bitField) {
            if (this.bitfield.get(piece)) {
                return true;
            }
            this.bitfield.set(piece);
            --this.needed;
            complete = this.needed == 0;
        }
        int i = 0;
        long raflen = this.lengths[i];
        for (start = (long)piece * (long)this.metainfo.getPieceLength(0); start > raflen; start -= raflen) {
            raflen = this.lengths[++i];
        }
        int off = 0;
        for (int written = 0; written < length; written += len) {
            int need = length - written;
            len = start + (long)need < raflen ? need : (int)(raflen - start);
            RandomAccessFile randomAccessFile = this.rafs[i];
            synchronized (randomAccessFile) {
                this.rafs[i].seek(start);
                this.rafs[i].write(bs, off + written, len);
                continue;
            }
        }
        this.changed = true;
        if (complete) {
            this.needed = this.metainfo.getPieces();
            this.bitfield = new BitField(this.needed);
            this.checkCreateFiles();
            if (this.needed > 0) {
                this.listener.setWantedPieces(this);
                Snark.debug("WARNING: Not really done, missing " + this.needed + " pieces", 2);
            } else {
                SnarkManager.instance().saveTorrentStatus(this.metainfo, this.bitfield);
            }
        }
        return true;
    }

    private int getUncheckedPiece(int piece, byte[] bs) throws IOException {
        return this.getUncheckedPiece(piece, bs, 0, this.metainfo.getPieceLength(piece));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getUncheckedPiece(int piece, byte[] bs, int off, int length) throws IOException {
        int len;
        long start;
        int i = 0;
        long raflen = this.lengths[i];
        for (start = (long)piece * (long)this.metainfo.getPieceLength(0) + (long)off; start > raflen; start -= raflen) {
            raflen = this.lengths[++i];
        }
        for (int read = 0; read < length; read += len) {
            int need = length - read;
            len = start + (long)need < raflen ? need : (int)(raflen - start);
            RandomAccessFile randomAccessFile = this.rafs[i];
            synchronized (randomAccessFile) {
                this.rafs[i].seek(start);
                this.rafs[i].readFully(bs, read, len);
                continue;
            }
        }
        return length;
    }
}

