/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark.web;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import net.i2p.util.FileUtil;
import org.klomp.snark.I2PSnarkUtil;
import org.klomp.snark.MetaInfo;
import org.klomp.snark.SnarkManager;

class FetchAndAdd
implements Runnable {
    private SnarkManager _manager;
    private String _url;

    public FetchAndAdd(SnarkManager mgr, String url) {
        this._manager = mgr;
        this._url = url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block20: {
            this._url = this._url.trim();
            File file = I2PSnarkUtil.instance().get(this._url, false, 3);
            try {
                if (file != null && file.exists() && file.length() > 0L) {
                    this._manager.addMessage("Torrent fetched from " + this._url);
                    FileInputStream in = null;
                    try {
                        in = new FileInputStream(file);
                        MetaInfo info = new MetaInfo(in);
                        String name = info.getName();
                        name = name.replace('/', '_');
                        name = name.replace('\\', '_');
                        name = name.replace('&', '+');
                        name = name.replace('\'', '_');
                        name = name.replace('\"', '_');
                        name = name.replace('`', '_');
                        name = name + ".torrent";
                        File torrentFile = new File(this._manager.getDataDir(), name);
                        String canonical = torrentFile.getCanonicalPath();
                        if (torrentFile.exists()) {
                            if (this._manager.getTorrent(canonical) != null) {
                                this._manager.addMessage("Torrent already running: " + name);
                            } else {
                                this._manager.addMessage("Torrent already in the queue: " + name);
                            }
                        } else {
                            FileUtil.copy(file.getAbsolutePath(), canonical, true);
                            this._manager.addTorrent(canonical);
                        }
                        break block20;
                    }
                    catch (IOException ioe) {
                        this._manager.addMessage("Torrent at " + this._url + " was not valid: " + ioe.getMessage());
                        break block20;
                    }
                    finally {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                this._manager.addMessage("Torrent was not retrieved from " + this._url);
            }
            finally {
                if (file != null) {
                    file.delete();
                }
            }
        }
    }
}

