/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.sam;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.i2p.data.DataFormatException;
import net.i2p.data.Destination;
import net.i2p.sam.SAMException;
import net.i2p.sam.SAMHandler;
import net.i2p.sam.SAMHandlerFactory;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;

public class SAMBridge
implements Runnable {
    private static final Log _log = new Log(SAMBridge.class);
    private ServerSocket serverSocket;
    private Properties i2cpProps;
    private String persistFilename;
    private Map nameToPrivKeys;
    private boolean acceptConnections;
    private static final int SAM_LISTENPORT = 7656;
    public static final String DEFAULT_SAM_KEYFILE = "sam.keys";

    private SAMBridge() {
        this.acceptConnections = true;
    }

    public SAMBridge(String listenHost, int listenPort, Properties i2cpProps, String persistFile) {
        block6: {
            this.acceptConnections = true;
            this.persistFilename = persistFile;
            this.nameToPrivKeys = new HashMap(8);
            this.loadKeys();
            try {
                if (listenHost != null && !"0.0.0.0".equals(listenHost)) {
                    this.serverSocket = new ServerSocket(listenPort, 0, InetAddress.getByName(listenHost));
                    if (_log.shouldLog(10)) {
                        _log.debug("SAM bridge listening on " + listenHost + ":" + listenPort);
                    }
                } else {
                    this.serverSocket = new ServerSocket(listenPort);
                    if (_log.shouldLog(10)) {
                        _log.debug("SAM bridge listening on 0.0.0.0:" + listenPort);
                    }
                }
            }
            catch (Exception e) {
                if (!_log.shouldLog(40)) break block6;
                _log.error("Error starting SAM bridge on " + (listenHost == null ? "0.0.0.0" : listenHost) + ":" + listenPort, e);
            }
        }
        this.i2cpProps = i2cpProps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Destination getDestination(String name) {
        Map map = this.nameToPrivKeys;
        synchronized (map) {
            String val = (String)this.nameToPrivKeys.get(name);
            if (val == null) {
                return null;
            }
            try {
                Destination d = new Destination();
                d.fromBase64(val);
                return d;
            }
            catch (DataFormatException dfe) {
                _log.error("Error retrieving the destination from " + name, dfe);
                this.nameToPrivKeys.remove(name);
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getKeystream(String name) {
        Map map = this.nameToPrivKeys;
        synchronized (map) {
            String val = (String)this.nameToPrivKeys.get(name);
            if (val == null) {
                return null;
            }
            return val;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addKeystream(String name, String stream) {
        Map map = this.nameToPrivKeys;
        synchronized (map) {
            this.nameToPrivKeys.put(name, stream);
        }
        this.storeKeys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadKeys() {
        Map map = this.nameToPrivKeys;
        synchronized (map) {
            this.nameToPrivKeys.clear();
            FileInputStream in = null;
            try {
                in = new FileInputStream(this.persistFilename);
                BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    int eq = line.indexOf(61);
                    String name = line.substring(0, eq);
                    String privKeys = line.substring(eq + 1);
                    this.nameToPrivKeys.put(name, privKeys);
                }
            }
            catch (FileNotFoundException fnfe) {
                _log.warn("Key file does not exist at " + this.persistFilename);
            }
            catch (IOException ioe) {
                _log.error("Unable to read the keys from " + this.persistFilename, ioe);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeKeys() {
        Map map = this.nameToPrivKeys;
        synchronized (map) {
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(this.persistFilename);
                for (String name : this.nameToPrivKeys.keySet()) {
                    String privKeys = (String)this.nameToPrivKeys.get(name);
                    out.write(name.getBytes());
                    out.write(61);
                    out.write(privKeys.getBytes());
                    out.write(10);
                }
            }
            catch (IOException ioe) {
                _log.error("Error writing out the SAM keys to " + this.persistFilename, ioe);
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public static void main(String[] args) {
        String keyfile = DEFAULT_SAM_KEYFILE;
        int port = 7656;
        String host = "0.0.0.0";
        Properties opts = null;
        if (args.length > 0) {
            keyfile = args[0];
            int portIndex = 1;
            try {
                port = Integer.parseInt(args[portIndex]);
            }
            catch (NumberFormatException nfe) {
                host = args[1];
                ++portIndex;
                try {
                    port = Integer.parseInt(args[portIndex]);
                }
                catch (NumberFormatException nfe1) {
                    SAMBridge.usage();
                    return;
                }
            }
            opts = SAMBridge.parseOptions(args, portIndex + 1);
        }
        SAMBridge bridge = new SAMBridge(host, port, opts, keyfile);
        I2PThread t = new I2PThread(bridge, "SAMListener");
        if (Boolean.valueOf(System.getProperty("sam.shutdownOnOOM", "false")).booleanValue()) {
            I2PThread.addOOMEventListener(new I2PThread.OOMEventListener(){

                public void outOfMemory(OutOfMemoryError err) {
                    err.printStackTrace();
                    System.err.println("OOMed, die die die");
                    System.exit(-1);
                }
            });
        }
        t.start();
    }

    private static Properties parseOptions(String[] args, int startArgs) {
        Properties props = new Properties();
        for (int i = startArgs; i < args.length; ++i) {
            int eq = args[i].indexOf(61);
            if (eq <= 0 || eq >= args[i].length() - 1) continue;
            String key = args[i].substring(0, eq);
            String val = args[i].substring(eq + 1);
            key = key.trim();
            val = val.trim();
            if (key.length() <= 0 || val.length() <= 0) continue;
            props.setProperty(key, val);
        }
        return props;
    }

    private static void usage() {
        System.err.println("Usage: SAMBridge [keyfile [listenHost] listenPortNum[ name=val]*]");
        System.err.println(" keyfile: location to persist private keys (default sam.keys)");
        System.err.println(" listenHost: interface to listen on (0.0.0.0 for all interfaces)");
        System.err.println(" listenPort: port to listen for SAM connections on (default 7656)");
        System.err.println(" name=val: options to pass when connecting via I2CP, such as ");
        System.err.println("           i2cp.host=localhost and i2cp.port=7654");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        if (this.serverSocket == null) {
            return;
        }
        try {
            while (this.acceptConnections) {
                Socket s = this.serverSocket.accept();
                if (_log.shouldLog(10)) {
                    _log.debug("New connection from " + s.getInetAddress().toString() + ":" + s.getPort());
                }
                try {
                    SAMHandler handler = SAMHandlerFactory.createSAMHandler(s, this.i2cpProps);
                    if (handler == null) {
                        if (_log.shouldLog(10)) {
                            _log.debug("SAM handler has not been instantiated");
                        }
                        try {
                            s.close();
                            continue;
                        }
                        catch (IOException e) {
                            continue;
                        }
                    }
                    handler.setBridge(this);
                    handler.startHandling();
                }
                catch (SAMException e) {
                    block30: {
                        if (_log.shouldLog(40)) {
                            _log.error("SAM error: " + e.getMessage(), e);
                        }
                        try {
                            String reply = "HELLO REPLY RESULT=I2P_ERROR MESSAGE=\"" + e.getMessage() + "\"\n";
                            s.getOutputStream().write(reply.getBytes("ISO-8859-1"));
                        }
                        catch (IOException ioe) {
                            if (!_log.shouldLog(40)) break block30;
                            _log.error("SAM Error sending error reply", ioe);
                        }
                    }
                    try {
                        s.close();
                    }
                    catch (IOException ioe) {
                    }
                }
                catch (Exception ee) {
                    try {
                        s.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    _log.log(50, "Unexpected error handling SAM connection", ee);
                }
            }
            return;
        }
        catch (Exception e) {
            if (!_log.shouldLog(40)) return;
            _log.error("Unexpected error while listening for connections", e);
            return;
        }
        finally {
            try {
                if (_log.shouldLog(10)) {
                    _log.debug("Shutting down, closing server socket");
                }
                if (this.serverSocket != null) {
                    this.serverSocket.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

