/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.sam;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.sam.client.SAMEventHandler;
import net.i2p.sam.client.SAMReader;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;

public class TestSwarm {
    private I2PAppContext _context;
    private Log _log;
    private String _samHost;
    private String _samPort;
    private String _destFile;
    private String[] _peerDestFiles;
    private String _conOptions;
    private Socket _samSocket;
    private OutputStream _samOut;
    private InputStream _samIn;
    private SAMReader _reader;
    private boolean _dead;
    private SAMEventHandler _eventHandler;
    private Map _remotePeers;

    public static void main(String[] args) {
        if (args.length < 3) {
            System.err.println("Usage: TestSwarm samHost samPort myDestFile [peerDestFile ]*");
            return;
        }
        I2PAppContext ctx = new I2PAppContext();
        String[] files = new String[args.length - 3];
        System.arraycopy(args, 3, files, 0, files.length);
        TestSwarm swarm = new TestSwarm(ctx, args[0], args[1], args[2], files);
        swarm.startup();
    }

    public TestSwarm(I2PAppContext ctx, String samHost, String samPort, String destFile, String[] peerDestFiles) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(TestSwarm.class);
        this._dead = false;
        this._samHost = samHost;
        this._samPort = samPort;
        this._destFile = destFile;
        this._peerDestFiles = peerDestFiles;
        this._conOptions = "";
        this._eventHandler = new SwarmEventHandler(this._context);
        this._remotePeers = new HashMap();
    }

    public void startup() {
        this._log.debug("Starting up");
        boolean ok = this.connect();
        this._log.debug("Connected: " + ok);
        if (ok) {
            this._reader = new SAMReader(this._context, this._samIn, this._eventHandler);
            this._reader.startReading();
            this._log.debug("Reader created");
            String ourDest = this.handshake();
            this._log.debug("Handshake complete.  we are " + ourDest);
            if (ourDest != null) {
                boolean written = this.writeDest(ourDest);
                this._log.debug("Dest written");
                if (written) {
                    this.connectWithPeers();
                    this._log.debug("connected with peers");
                }
            }
        }
    }

    private boolean connect() {
        try {
            this._samSocket = new Socket(this._samHost, Integer.parseInt(this._samPort));
            this._samOut = this._samSocket.getOutputStream();
            this._samIn = this._samSocket.getInputStream();
            return true;
        }
        catch (Exception e) {
            this._log.error("Unable to connect to SAM at " + this._samHost + ":" + this._samPort, e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String handshake() {
        OutputStream outputStream = this._samOut;
        synchronized (outputStream) {
            try {
                this._samOut.write("HELLO VERSION MIN=1.0 MAX=1.0\n".getBytes());
                this._samOut.flush();
                this._log.debug("Hello sent");
                boolean ok = this._eventHandler.waitForHelloReply();
                this._log.debug("Hello reply found: " + ok);
                if (!ok) {
                    throw new IOException("wtf, hello failed?");
                }
                String req = "SESSION CREATE STYLE=STREAM DESTINATION=" + this._destFile + " " + this._conOptions + "\n";
                this._samOut.write(req.getBytes());
                this._samOut.flush();
                this._log.debug("Session create sent");
                ok = this._eventHandler.waitForSessionCreateReply();
                this._log.debug("Session create reply found: " + ok);
                req = "NAMING LOOKUP NAME=ME\n";
                this._samOut.write(req.getBytes());
                this._samOut.flush();
                this._log.debug("Naming lookup sent");
                String destination = this._eventHandler.waitForNamingReply("ME");
                this._log.debug("Naming lookup reply found: " + destination);
                if (destination == null) {
                    this._log.error("No naming lookup reply found!");
                    return null;
                }
                this._log.info(this._destFile + " is located at " + destination);
                return destination;
            }
            catch (Exception e) {
                this._log.error("Error handshaking", e);
                return null;
            }
        }
    }

    private boolean writeDest(String dest) {
        try {
            FileOutputStream fos = new FileOutputStream(this._destFile);
            fos.write(dest.getBytes());
            fos.close();
            return true;
        }
        catch (Exception e) {
            this._log.error("Error writing to " + this._destFile, e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectWithPeers() {
        if (this._peerDestFiles != null) {
            for (int i = 0; i < this._peerDestFiles.length; ++i) {
                try {
                    FileInputStream fin = new FileInputStream(this._peerDestFiles[i]);
                    byte[] dest = new byte[1024];
                    int read = DataHelper.read(fin, dest);
                    String remDest = new String(dest, 0, read);
                    int con = 0;
                    Flooder flooder = null;
                    Map map = this._remotePeers;
                    synchronized (map) {
                        con = this._remotePeers.size() + 1;
                        flooder = new Flooder(con, remDest);
                        this._remotePeers.put(new Integer(con), flooder);
                    }
                    byte[] msg = ("STREAM CONNECT ID=" + con + " DESTINATION=" + remDest + "\n").getBytes();
                    OutputStream outputStream = this._samOut;
                    synchronized (outputStream) {
                        this._samOut.write(msg);
                        this._samOut.flush();
                    }
                    I2PThread flood = new I2PThread(flooder, "Flood " + con);
                    flood.start();
                    this._log.debug("Starting flooder with peer from " + this._peerDestFiles[i] + ": " + con);
                    continue;
                }
                catch (IOException ioe) {
                    this._log.error("Unable to read the peer from " + this._peerDestFiles[i]);
                }
            }
        }
    }

    private class Flooder
    implements Runnable {
        private int _connectionId;
        private String _remoteDestination;
        private boolean _closed;
        private long _started;
        private long _totalSent;
        private long _totalReceived;
        private long _lastReceived;
        private long _lastReceivedOn;
        private boolean _outOfSync;

        public Flooder(int conId, String remDest) {
            this._connectionId = conId;
            this._remoteDestination = remDest;
            this._closed = false;
            this._outOfSync = false;
            this._lastReceived = -1L;
            this._lastReceivedOn = TestSwarm.this._context.clock().now();
            TestSwarm.this._context.statManager().createRateStat("swarm." + conId + ".totalReceived", "Data size received", "swarm", new long[]{30000L, 60000L, 300000L});
            TestSwarm.this._context.statManager().createRateStat("swarm." + conId + ".totalSent", "Data size sent", "swarm", new long[]{30000L, 60000L, 300000L});
            TestSwarm.this._context.statManager().createRateStat("swarm." + conId + ".started", "When we start", "swarm", new long[]{300000L});
            TestSwarm.this._context.statManager().createRateStat("swarm." + conId + ".lifetime", "How long we talk to a peer", "swarm", new long[]{300000L});
        }

        public int getConnectionId() {
            return this._connectionId;
        }

        public String getDestination() {
            return this._remoteDestination;
        }

        public void closed() {
            this._closed = true;
            long lifetime = TestSwarm.this._context.clock().now() - this._started;
            TestSwarm.this._context.statManager().addRateData("swarm." + this._connectionId + ".lifetime", lifetime, lifetime);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this._started = TestSwarm.this._context.clock().now();
            TestSwarm.this._context.statManager().addRateData("swarm." + this._connectionId + ".started", 1L, 0L);
            byte[] data = new byte[32768];
            long value = 0L;
            long lastSend = TestSwarm.this._context.clock().now();
            while (!this._closed) {
                byte[] msg = ("STREAM SEND ID=" + this._connectionId + " SIZE=" + data.length + "\n").getBytes();
                DataHelper.toLong(data, 0, 4, value);
                try {
                    OutputStream outputStream = TestSwarm.this._samOut;
                    synchronized (outputStream) {
                        TestSwarm.this._samOut.write(msg);
                        TestSwarm.this._samOut.write(data);
                        TestSwarm.this._samOut.flush();
                    }
                }
                catch (IOException ioe) {
                    TestSwarm.this._log.error("Error talking to SAM", ioe);
                    return;
                }
                this._totalSent += (long)data.length;
                TestSwarm.this._context.statManager().addRateData("swarm." + this._connectionId + ".totalSent", this._totalSent, 0L);
                ++value;
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                long now = TestSwarm.this._context.clock().now();
                TestSwarm.this._log.debug("Sending " + value + " on " + this._connectionId + " after " + (now - lastSend));
                lastSend = now;
            }
        }

        public void received(int len, long value) {
            this._totalReceived += (long)len;
            if (!this._outOfSync && len % 32 * 1024 != 0) {
                this._outOfSync = true;
                if (TestSwarm.this._log.shouldLog(40)) {
                    TestSwarm.this._log.error("Out of sync (len=" + len + " after " + (this._totalReceived - (long)len) + ")");
                }
            }
            TestSwarm.this._context.statManager().addRateData("swarm." + this.getConnectionId() + ".totalReceived", this._totalReceived, 0L);
            if (value != this._lastReceived + 1L) {
                if (!this._outOfSync) {
                    TestSwarm.this._log.error("Received " + value + " when expecting " + (this._lastReceived + 1L) + " on " + this._connectionId + " with " + this._remoteDestination.substring(0, 6));
                } else {
                    TestSwarm.this._log.debug("(out of sync) Received " + value + " when expecting " + (this._lastReceived + 1L) + " on " + this._connectionId + " with " + this._remoteDestination.substring(0, 6));
                }
            } else {
                TestSwarm.this._log.debug("Received " + value + " on " + this._connectionId + " after " + (TestSwarm.this._context.clock().now() - this._lastReceivedOn) + "ms with " + this._remoteDestination.substring(0, 6));
            }
            this._lastReceived = value;
            this._lastReceivedOn = TestSwarm.this._context.clock().now();
        }
    }

    private class SwarmEventHandler
    extends SAMEventHandler {
        public SwarmEventHandler(I2PAppContext ctx) {
            super(ctx);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void streamClosedReceived(String result, int id, String message) {
            Flooder flooder = null;
            Map map = TestSwarm.this._remotePeers;
            synchronized (map) {
                flooder = (Flooder)TestSwarm.this._remotePeers.remove(new Integer(id));
            }
            if (flooder != null) {
                flooder.closed();
                TestSwarm.this._log.debug("Connection " + flooder.getConnectionId() + " closed to " + flooder.getDestination());
            } else {
                TestSwarm.this._log.error("wtf, not connected to " + id + " but we were just closed?");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void streamDataReceived(int id, byte[] data, int offset, int length) {
            Flooder flooder = null;
            Map map = TestSwarm.this._remotePeers;
            synchronized (map) {
                flooder = (Flooder)TestSwarm.this._remotePeers.get(new Integer(id));
            }
            long value = DataHelper.fromLong(data, 0, 4);
            if (flooder != null) {
                flooder.received(length, value);
            } else {
                TestSwarm.this._log.error("wtf, not connected to " + id + " but we received " + value + "?");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void streamConnectedReceived(String dest, int id) {
            TestSwarm.this._log.debug("Connection " + id + " received from " + dest);
            Flooder flooder = new Flooder(id, dest);
            Map map = TestSwarm.this._remotePeers;
            synchronized (map) {
                TestSwarm.this._remotePeers.put(new Integer(id), flooder);
            }
            I2PThread t = new I2PThread(flooder, "Flood " + id);
            t.start();
        }
    }
}

