/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DOMElementWriter {
    private static String lSep = System.getProperty("line.separator");
    protected String[] knownEntities;

    public void write(Element element, OutputStream outputStream) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF8");
        outputStreamWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        this.write(element, outputStreamWriter, 0, "  ");
        ((Writer)outputStreamWriter).flush();
    }

    public void write(Element element, Writer writer, int n, String string) throws IOException {
        Object object;
        int n2 = 0;
        while (n2 < n) {
            writer.write(string);
            ++n2;
        }
        writer.write("<");
        writer.write(element.getTagName());
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n3 = 0;
        while (n3 < namedNodeMap.getLength()) {
            object = (Attr)namedNodeMap.item(n3);
            writer.write(" ");
            writer.write(object.getName());
            writer.write("=\"");
            writer.write(this.encode(object.getValue()));
            writer.write("\"");
            ++n3;
        }
        writer.write(">");
        n3 = 0;
        object = element.getChildNodes();
        int n4 = 0;
        while (n4 < object.getLength()) {
            Node node = object.item(n4);
            switch (node.getNodeType()) {
                case 1: {
                    if (n3 == 0) {
                        writer.write(lSep);
                        n3 = 1;
                    }
                    this.write((Element)node, writer, n + 1, string);
                    break;
                }
                case 3: {
                    writer.write(this.encode(node.getNodeValue()));
                    break;
                }
                case 8: {
                    writer.write("<!--");
                    writer.write(this.encode(node.getNodeValue()));
                    writer.write("-->");
                    break;
                }
                case 4: {
                    writer.write("<![CDATA[");
                    writer.write(this.encodedata(((Text)node).getData()));
                    writer.write("]]>");
                    break;
                }
                case 5: {
                    writer.write(38);
                    writer.write(node.getNodeName());
                    writer.write(59);
                    break;
                }
                case 7: {
                    writer.write("<?");
                    writer.write(node.getNodeName());
                    String string2 = node.getNodeValue();
                    if (string2 != null && string2.length() > 0) {
                        writer.write(32);
                        writer.write(string2);
                    }
                    writer.write("?>");
                    break;
                }
            }
            ++n4;
        }
        if (n3 != 0) {
            n4 = 0;
            while (n4 < n) {
                writer.write(string);
                ++n4;
            }
        }
        writer.write("</");
        writer.write(element.getTagName());
        writer.write(">");
        writer.write(lSep);
        writer.flush();
    }

    public String encode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    break;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    break;
                }
                case '\'': {
                    stringBuffer.append("&apos;");
                    break;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    break;
                }
                case '&': {
                    int n3 = string.indexOf(";", n2);
                    if (n3 < 0 || !this.isReference(string.substring(n2, n3 + 1))) {
                        stringBuffer.append("&amp;");
                        break;
                    }
                    stringBuffer.append('&');
                    break;
                }
                default: {
                    if (!this.isLegalCharacter(c)) break;
                    stringBuffer.append(c);
                }
            }
            ++n2;
        }
        return stringBuffer.substring(0);
    }

    public String encodedata(String string) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            n = string.charAt(n3);
            if (this.isLegalCharacter((char)n)) {
                stringBuffer.append((char)n);
            }
            ++n3;
        }
        String string2 = stringBuffer.substring(0);
        n = string2.indexOf("]]>");
        while (n != -1) {
            stringBuffer.setLength(n);
            stringBuffer.append("&#x5d;&#x5d;&gt;").append(string2.substring(n + 3));
            string2 = stringBuffer.substring(0);
            n = string2.indexOf("]]>");
        }
        return string2;
    }

    public boolean isReference(String string) {
        if (string.charAt(0) != '&' || !string.endsWith(";")) {
            return false;
        }
        if (string.charAt(1) == '#') {
            if (string.charAt(2) == 'x') {
                try {
                    Integer.parseInt(string.substring(3, string.length() - 1), 16);
                    return true;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
            try {
                Integer.parseInt(string.substring(2, string.length() - 1));
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        String string2 = string.substring(1, string.length() - 1);
        int n = 0;
        while (n < this.knownEntities.length) {
            if (string2.equals(this.knownEntities[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isLegalCharacter(char c) {
        if (c == '\t' || c == '\n' || c == '\r') {
            return true;
        }
        if (c < ' ') {
            return false;
        }
        if (c <= '\ud7ff') {
            return true;
        }
        if (c < '\ue000') {
            return false;
        }
        return c <= '\ufffd';
    }

    private final /* synthetic */ void this() {
        this.knownEntities = new String[]{"gt", "amp", "lt", "apos", "quot"};
    }

    public DOMElementWriter() {
        this.this();
    }
}

