/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.BOB;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import net.i2p.BOB.NamedDB;
import net.i2p.BOB.TCPtoI2P;
import net.i2p.client.I2PSession;
import net.i2p.client.I2PSessionException;
import net.i2p.client.streaming.I2PServerSocket;
import net.i2p.client.streaming.I2PSocketManager;
import net.i2p.util.Log;

public class TCPlistener
implements Runnable {
    private NamedDB info;
    private NamedDB database;
    private Log _log;
    private int tgwatch;
    public I2PSocketManager socketManager;
    public I2PServerSocket serverSocket;
    private ServerSocket listener;

    TCPlistener(ServerSocket listener, I2PSocketManager S, NamedDB info, NamedDB database, Log _log) {
        this.database = database;
        this.info = info;
        this._log = _log;
        this.socketManager = S;
        this.listener = listener;
        this.tgwatch = 1;
    }

    public void run() {
        block12: {
            boolean g = false;
            boolean spin = true;
            this.database.getReadLock();
            this.info.getReadLock();
            if (this.info.exists("OUTPORT")) {
                this.tgwatch = 2;
            }
            try {
                Socket server = new Socket();
                this.listener.setSoTimeout(1000);
                this.info.releaseReadLock();
                this.database.releaseReadLock();
                while (spin) {
                    this.database.getReadLock();
                    this.info.getReadLock();
                    spin = this.info.get("RUNNING").equals(Boolean.TRUE);
                    this.info.releaseReadLock();
                    this.database.releaseReadLock();
                    try {
                        server = this.listener.accept();
                        g = true;
                    }
                    catch (SocketTimeoutException ste) {
                        g = false;
                    }
                    if (!g) continue;
                    TCPtoI2P conn_c = new TCPtoI2P(this.socketManager, server, this.info, this.database);
                    Thread t = new Thread((Runnable)conn_c, "BOBTCPtoI2P");
                    t.start();
                    g = false;
                }
                this.listener.close();
            }
            catch (IOException ioe) {
                this.database.getReadLock();
                this.info.getReadLock();
                spin = this.info.get("RUNNING").equals(Boolean.TRUE);
                this.info.releaseReadLock();
                this.database.releaseReadLock();
                if (!spin) break block12;
                this.database.getWriteLock();
                this.info.getWriteLock();
                this.info.add("STOPPING", new Boolean(true));
                this.info.add("RUNNING", new Boolean(false));
                this.info.releaseWriteLock();
                this.database.releaseWriteLock();
            }
        }
        while (Thread.activeCount() > this.tgwatch) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e) {}
        }
        I2PSession session = this.socketManager.getSession();
        if (session != null) {
            try {
                session.destroySession();
            }
            catch (I2PSessionException ex) {
                // empty catch block
            }
        }
    }
}

