/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import net.i2p.I2PAppContext;
import net.i2p.I2PException;
import net.i2p.client.I2PSessionException;
import net.i2p.client.streaming.ByteCollector;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.client.streaming.I2PSocketManagerImpl;
import net.i2p.client.streaming.I2PSocketOptions;
import net.i2p.data.Destination;
import net.i2p.util.Clock;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;

class I2PSocketImpl
implements I2PSocket {
    private static final Log _log = new Log(I2PSocketImpl.class);
    public static final int MAX_PACKET_SIZE = 32768;
    public static final int PACKET_DELAY = 100;
    private I2PSocketManagerImpl manager;
    private Destination local;
    private Destination remote;
    private String localID;
    private String remoteID;
    private Object remoteIDWaiter = new Object();
    private I2PInputStream in;
    private I2POutputStream out;
    private I2PSocket.SocketErrorListener _socketErrorListener;
    private boolean outgoing;
    private long _socketId;
    private static long __socketId = 0L;
    private long _bytesRead = 0L;
    private long _bytesWritten = 0L;
    private long _createdOn;
    private long _closedOn;
    private long _remoteIdSetTime;
    private I2PSocketOptions _options;
    private Object flagLock = new Object();
    private boolean closed = false;
    private boolean sendClose = true;
    private boolean closed2 = false;
    private static volatile long __runnerId = 0L;

    public I2PSocketImpl(Destination peer, I2PSocketManagerImpl mgr, boolean outgoing, String localID) {
        this.outgoing = outgoing;
        this.manager = mgr;
        this.remote = peer;
        this._socketId = ++__socketId;
        this.local = mgr.getSession().getMyDestination();
        String us = mgr.getSession().getMyDestination().calculateHash().toBase64().substring(0, 4);
        String name = us + (outgoing ? "->" : "<-") + peer.calculateHash().toBase64().substring(0, 4);
        this.in = new I2PInputStream(name + " in");
        I2PInputStream pin = new I2PInputStream(name + " out");
        this.out = new I2POutputStream(pin);
        new I2PSocketRunner(pin);
        this.localID = localID;
        this._createdOn = I2PAppContext.getGlobalContext().clock().now();
        this._remoteIdSetTime = -1L;
        this._closedOn = -1L;
        this._options = mgr.getDefaultOptions();
    }

    public String getLocalID() {
        return this.localID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRemoteID(String id) {
        Object object = this.remoteIDWaiter;
        synchronized (object) {
            this.remoteID = id;
            this._remoteIdSetTime = System.currentTimeMillis();
            this.remoteIDWaiter.notifyAll();
        }
    }

    public String getRemoteID(boolean wait) {
        try {
            return this.getRemoteID(wait, -1L);
        }
        catch (InterruptedIOException iie) {
            _log.error("wtf, we said we didn't want it to time out!  you smell", (Throwable)iie);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRemoteID(boolean wait, long maxWait) throws InterruptedIOException {
        long dieAfter = System.currentTimeMillis() + maxWait;
        Object object = this.remoteIDWaiter;
        synchronized (object) {
            if (wait) {
                if (this.remoteID == null) {
                    try {
                        if (maxWait >= 0L) {
                            this.remoteIDWaiter.wait(maxWait);
                        } else {
                            this.remoteIDWaiter.wait();
                        }
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                }
                long now = System.currentTimeMillis();
                if (maxWait >= 0L && now >= dieAfter) {
                    long waitedExcess = now - dieAfter;
                    throw new InterruptedIOException("Timed out waiting for remote ID (waited " + waitedExcess + "ms too long [" + maxWait + "ms, remId " + this.remoteID + ", remId set " + (now - this._remoteIdSetTime) + "ms ago])");
                }
                if (_log.shouldLog(10)) {
                    _log.debug("TIMING: RemoteID set to " + I2PSocketManagerImpl.getReadableForm(this.remoteID) + " for " + this.hashCode());
                }
            }
            return this.remoteID;
        }
    }

    public String getRemoteID() {
        return this.getRemoteID(false);
    }

    public void queueData(byte[] data) {
        this._bytesRead += (long)data.length;
        try {
            this.in.queueData(data, false);
        }
        catch (IOException ioe) {
            _log.log(50, "wtf, we said DONT block, how can we timeout?", (Throwable)ioe);
        }
    }

    public Destination getThisDestination() {
        return this.local;
    }

    public Destination getPeerDestination() {
        return this.remote;
    }

    public InputStream getInputStream() throws IOException {
        if (this.in == null) {
            throw new IOException("Not connected");
        }
        return this.in;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.out == null) {
            throw new IOException("Not connected");
        }
        return this.out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.flagLock;
        synchronized (object) {
            if (_log.shouldLog(10)) {
                _log.debug("Closing connection");
            }
            this.closed = true;
            this._closedOn = I2PAppContext.getGlobalContext().clock().now();
        }
        this.out.close();
        this.in.notifyClosed();
    }

    public boolean isClosed() {
        return this._closedOn > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalClose() {
        Object object = this.flagLock;
        synchronized (object) {
            this.closed = true;
            this.closed2 = true;
            this.sendClose = false;
            this._closedOn = I2PAppContext.getGlobalContext().clock().now();
        }
        this.out.close();
        this.in.notifyClosed();
    }

    private byte getMask(int add) {
        if (this.outgoing) {
            return (byte)(160 + (byte)add);
        }
        return (byte)(80 + (byte)add);
    }

    public void setOptions(I2PSocketOptions options) {
        this._options = options;
        this.in.setReadTimeout(options.getReadTimeout());
    }

    public I2PSocketOptions getOptions() {
        return this._options;
    }

    public long getReadTimeout() {
        return this._options.getReadTimeout();
    }

    public void setReadTimeout(long ms) {
        this._options.setReadTimeout(ms);
        this.in.setReadTimeout(ms);
    }

    public void setSocketErrorListener(I2PSocket.SocketErrorListener lsnr) {
        this._socketErrorListener = lsnr;
    }

    void errorOccurred() {
        if (this._socketErrorListener != null) {
            this._socketErrorListener.errorOccurred();
        }
    }

    public long getBytesSent() {
        return this._bytesWritten;
    }

    public long getBytesReceived() {
        return this._bytesRead;
    }

    public long getCreatedOn() {
        return this._createdOn;
    }

    public long getClosedOn() {
        return this._closedOn;
    }

    private String getPrefix() {
        return "[" + this._socketId + "]: ";
    }

    public String toString() {
        return "" + this.hashCode();
    }

    private class I2PSocketRunner
    extends I2PThread {
        public InputStream in;

        public I2PSocketRunner(InputStream in) {
            if (_log.shouldLog(10)) {
                _log.debug(I2PSocketImpl.this.getPrefix() + "Runner's input stream is: " + in.hashCode());
            }
            this.in = in;
            String peer = I2PSocketImpl.this.remote.calculateHash().toBase64();
            this.setName("SocketRunner " + ++__runnerId + "/" + I2PSocketImpl.this._socketId + " " + peer.substring(0, 4));
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean handleNextPacket(ByteCollector bc, byte[] buffer) throws IOException, I2PSessionException {
            if (_log.shouldLog(10)) {
                _log.debug(I2PSocketImpl.this.getPrefix() + ":" + Thread.currentThread().getName() + "handleNextPacket");
            }
            int len = this.in.read(buffer);
            int bcsize = 0;
            ByteCollector byteCollector = bc;
            synchronized (byteCollector) {
                bcsize = bc.getCurrentSize();
            }
            if (_log.shouldLog(10)) {
                _log.debug(I2PSocketImpl.this.getPrefix() + ":" + Thread.currentThread().getName() + "handleNextPacket len=" + len + " bcsize=" + bcsize);
            }
            if (len != -1) {
                byteCollector = bc;
                synchronized (byteCollector) {
                    bc.append(buffer, len);
                }
            } else if (bcsize == 0) {
                return false;
            }
            if (bcsize < 32768 && this.in.available() == 0) {
                if (_log.shouldLog(10)) {
                    _log.debug(I2PSocketImpl.this.getPrefix() + ":" + Thread.currentThread().getName() + "Runner Point d: " + ((Object)((Object)this)).hashCode());
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    _log.warn("wtf", (Throwable)e);
                }
            }
            if (bcsize >= 32768 || this.in.available() == 0) {
                byte[] data = null;
                ByteCollector byteCollector2 = bc;
                synchronized (byteCollector2) {
                    data = bc.startToByteArray(32768);
                }
                if (data.length > 0) {
                    boolean sent;
                    if (_log.shouldLog(10)) {
                        _log.debug(I2PSocketImpl.this.getPrefix() + ":" + Thread.currentThread().getName() + "Message size is: " + data.length);
                    }
                    if (!(sent = this.sendBlock(data))) {
                        if (_log.shouldLog(30)) {
                            _log.warn(I2PSocketImpl.this.getPrefix() + ":" + Thread.currentThread().getName() + "Error sending message to peer.  Killing socket runner");
                        }
                        I2PSocketImpl.this.errorOccurred();
                        return false;
                    }
                    if (_log.shouldLog(10)) {
                        _log.debug(I2PSocketImpl.this.getPrefix() + ":" + Thread.currentThread().getName() + "Message sent to peer");
                    }
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            byte[] buffer = new byte[32768];
            ByteCollector bc = new ByteCollector();
            boolean keepHandling = true;
            int packetsHandled = 0;
            try {
                boolean sc;
                while (keepHandling) {
                    keepHandling = this.handleNextPacket(bc, buffer);
                    ++packetsHandled;
                    if (!_log.shouldLog(10)) continue;
                    _log.debug(I2PSocketImpl.this.getPrefix() + ":" + Thread.currentThread().getName() + "Packets handled: " + packetsHandled);
                }
                if (_log.shouldLog(20)) {
                    _log.info(I2PSocketImpl.this.getPrefix() + ":" + Thread.currentThread().getName() + "After handling packets, we're done.  Packets handled: " + packetsHandled);
                }
                if (bc.getCurrentSize() > 0 && packetsHandled > 1 && _log.shouldLog(30)) {
                    _log.warn(I2PSocketImpl.this.getPrefix() + "We lost some data queued up due to a network send error (input stream: " + this.in.hashCode() + "; " + "queue size: " + bc.getCurrentSize() + ")");
                }
                Object object = I2PSocketImpl.this.flagLock;
                synchronized (object) {
                    I2PSocketImpl.this.closed2 = true;
                }
                Object object2 = I2PSocketImpl.this.flagLock;
                synchronized (object2) {
                    sc = I2PSocketImpl.this.sendClose;
                }
                if (sc) {
                    if (_log.shouldLog(20)) {
                        _log.info(I2PSocketImpl.this.getPrefix() + ":" + Thread.currentThread().getName() + "Sending close packet: (we started? " + I2PSocketImpl.this.outgoing + ") after reading " + I2PSocketImpl.this._bytesRead + " and writing " + I2PSocketImpl.this._bytesWritten);
                    }
                    byte[] packet = I2PSocketManagerImpl.makePacket(I2PSocketImpl.this.getMask(2), I2PSocketImpl.this.remoteID, new byte[0]);
                    boolean sent = I2PSocketImpl.this.manager.getSession().sendMessage(I2PSocketImpl.this.remote, packet);
                    if (!sent) {
                        if (_log.shouldLog(30)) {
                            _log.warn(I2PSocketImpl.this.getPrefix() + ":" + Thread.currentThread().getName() + "Error sending close packet to peer");
                        }
                        I2PSocketImpl.this.errorOccurred();
                    }
                }
                I2PSocketImpl.this.manager.removeSocket(I2PSocketImpl.this);
                I2PSocketImpl.this.internalClose();
            }
            catch (InterruptedIOException ex) {
                _log.error(I2PSocketImpl.this.getPrefix() + "BUG! read() operations should not timeout!", (Throwable)ex);
            }
            catch (IOException ex) {
                _log.error(I2PSocketImpl.this.getPrefix() + "Error running - **INCONSISTENT STATE!!!**", (Throwable)ex);
            }
            catch (I2PException ex) {
                _log.error(I2PSocketImpl.this.getPrefix() + "Error running - **INCONSISTENT STATE!!!**", (Throwable)ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean sendBlock(byte[] data) throws I2PSessionException {
            if (_log.shouldLog(10)) {
                _log.debug(I2PSocketImpl.this.getPrefix() + "TIMING: Block to send for " + I2PSocketImpl.this.hashCode());
            }
            if (I2PSocketImpl.this.remoteID == null) {
                _log.error(I2PSocketImpl.this.getPrefix() + "NULL REMOTEID");
                return false;
            }
            byte[] packet = I2PSocketManagerImpl.makePacket(I2PSocketImpl.this.getMask(0), I2PSocketImpl.this.remoteID, data);
            Object object = I2PSocketImpl.this.flagLock;
            synchronized (object) {
                if (I2PSocketImpl.this.closed2) {
                    return false;
                }
            }
            boolean sent = I2PSocketImpl.this.manager.getSession().sendMessage(I2PSocketImpl.this.remote, packet);
            return sent;
        }
    }

    private class I2POutputStream
    extends OutputStream {
        public I2PInputStream sendTo;

        public I2POutputStream(I2PInputStream sendTo) {
            this.sendTo = sendTo;
        }

        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)b});
        }

        public void write(byte[] b, int off, int len) throws IOException {
            I2PSocketImpl.this._bytesWritten += len;
            this.sendTo.queueData(b, off, len, true);
        }

        public void close() {
            this.sendTo.notifyClosed();
        }
    }

    private class I2PInputStream
    extends InputStream {
        private String streamName;
        private ByteCollector bc = new ByteCollector();
        private boolean inStreamClosed = false;
        private long readTimeout = -1L;

        public I2PInputStream(String name) {
            this.streamName = name;
        }

        public long getReadTimeout() {
            return this.readTimeout;
        }

        private String getStreamPrefix() {
            return I2PSocketImpl.this.getPrefix() + this.streamName + ": ";
        }

        public void setReadTimeout(long ms) {
            this.readTimeout = ms;
        }

        public int read() throws IOException {
            byte[] b = new byte[1];
            int res = this.read(b);
            if (res == 1) {
                return b[0] & 0xFF;
            }
            if (res == -1) {
                return -1;
            }
            throw new RuntimeException("Incorrect read() result");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(byte[] b, int off, int len) throws IOException {
            if (_log.shouldLog(10)) {
                _log.debug(this.getStreamPrefix() + "Read called for " + len + " bytes (avail=" + this.bc.getCurrentSize() + "): " + this.hashCode());
            }
            if (len == 0) {
                return 0;
            }
            long dieAfter = System.currentTimeMillis() + this.readTimeout;
            byte[] read = null;
            ByteCollector byteCollector = this.bc;
            synchronized (byteCollector) {
                read = this.bc.startToByteArray(len);
                this.bc.notifyAll();
            }
            boolean timedOut = false;
            while (read.length == 0 && !this.inStreamClosed) {
                Object object = I2PSocketImpl.this.flagLock;
                synchronized (object) {
                    if (I2PSocketImpl.this.closed) {
                        if (_log.shouldLog(10)) {
                            _log.debug(this.getStreamPrefix() + "Closed is set after reading " + I2PSocketImpl.this._bytesRead + " and writing " + I2PSocketImpl.this._bytesWritten + ", so closing stream: " + this.hashCode());
                        }
                        return -1;
                    }
                }
                try {
                    object = this;
                    synchronized (object) {
                        if (this.readTimeout >= 0L) {
                            this.wait(this.readTimeout);
                        } else {
                            this.wait();
                        }
                    }
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                if (this.readTimeout >= 0L && System.currentTimeMillis() >= dieAfter) {
                    throw new InterruptedIOException(this.getStreamPrefix() + "Timeout reading from I2PSocket (" + this.readTimeout + " msecs)");
                }
                object = this.bc;
                synchronized (object) {
                    read = this.bc.startToByteArray(len);
                    this.bc.notifyAll();
                }
            }
            if (read.length > len) {
                throw new RuntimeException("BUG");
            }
            if (this.inStreamClosed && read.length <= 0) {
                return -1;
            }
            System.arraycopy(read, 0, b, off, read.length);
            if (_log.shouldLog(10)) {
                _log.debug(this.getStreamPrefix() + "Read from I2PInputStream " + this.hashCode() + " returned " + read.length + " bytes");
            }
            return read.length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int available() {
            ByteCollector byteCollector = this.bc;
            synchronized (byteCollector) {
                return this.bc.getCurrentSize();
            }
        }

        void queueData(byte[] data, boolean allowBlock) throws InterruptedIOException, IOException {
            this.queueData(data, 0, data.length, allowBlock);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void queueData(byte[] data, int off, int len, boolean allowBlock) throws InterruptedIOException, IOException {
            if (_log.shouldLog(10)) {
                _log.debug(this.getStreamPrefix() + "Insert " + len + " bytes into queue: " + this.hashCode());
            }
            Clock clock = I2PAppContext.getGlobalContext().clock();
            long endAfter = clock.now() + I2PSocketImpl.this._options.getWriteTimeout();
            Object object = this.bc;
            synchronized (object) {
                if (allowBlock && I2PSocketImpl.this._options.getMaxBufferSize() > 0) {
                    while (this.bc.getCurrentSize() > I2PSocketImpl.this._options.getMaxBufferSize()) {
                        long timeLeft;
                        if (_log.shouldLog(10)) {
                            _log.debug(this.getStreamPrefix() + "Buffer size exceeded: pending " + this.bc.getCurrentSize() + " limit " + I2PSocketImpl.this._options.getMaxBufferSize());
                        }
                        if (I2PSocketImpl.this._options.getWriteTimeout() > 0L && (timeLeft = endAfter - clock.now()) <= 0L) {
                            long waited = I2PSocketImpl.this._options.getWriteTimeout() - timeLeft;
                            throw new InterruptedIOException(this.getStreamPrefix() + "Waited too long (" + waited + "ms) to write " + len + " with a buffer at " + this.bc.getCurrentSize());
                        }
                        if (this.inStreamClosed) {
                            throw new IOException(this.getStreamPrefix() + "Stream closed while writing");
                        }
                        if (I2PSocketImpl.this._closedOn > 0L) {
                            throw new IOException(this.getStreamPrefix() + "I2PSocket closed while writing");
                        }
                        try {
                            this.bc.wait(1000L);
                        }
                        catch (InterruptedException ie) {}
                    }
                }
                this.bc.append(data, off, len);
            }
            object = this;
            synchronized (object) {
                this.notifyAll();
            }
            if (_log.shouldLog(10)) {
                _log.debug(this.getStreamPrefix() + "After insert " + len + " bytes into queue: " + this.hashCode());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyClosed() {
            I2PInputStream i2PInputStream = this;
            synchronized (i2PInputStream) {
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            super.close();
            this.notifyClosed();
            ByteCollector byteCollector = this.bc;
            synchronized (byteCollector) {
                this.inStreamClosed = true;
                this.bc.notifyAll();
            }
            if (_log.shouldLog(10)) {
                _log.debug(this.getStreamPrefix() + "After close");
            }
        }
    }
}

