/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.util.Properties;
import java.util.Random;
import net.i2p.I2PAppContext;
import net.i2p.I2PException;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.client.streaming.I2PSocketManager;
import net.i2p.client.streaming.I2PSocketManagerFactory;
import net.i2p.data.DataFormatException;
import net.i2p.data.Destination;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;

public class StreamSinkClient {
    private Log _log;
    private int _sendSize;
    private int _writeDelay;
    private String _peerDestFile;
    private String _i2cpHost;
    private int _i2cpPort;

    public StreamSinkClient(int sendSize, int writeDelayMs, String serverDestFile) {
        this(null, -1, sendSize, writeDelayMs, serverDestFile);
    }

    public StreamSinkClient(String i2cpHost, int i2cpPort, int sendSize, int writeDelayMs, String serverDestFile) {
        this._i2cpHost = i2cpHost;
        this._i2cpPort = i2cpPort;
        this._sendSize = sendSize;
        this._writeDelay = writeDelayMs;
        this._peerDestFile = serverDestFile;
        this._log = I2PAppContext.getGlobalContext().logManager().getLog(StreamSinkClient.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runClient() {
        I2PSocketManager mgr = null;
        mgr = this._i2cpHost != null ? I2PSocketManagerFactory.createManager(this._i2cpHost, this._i2cpPort, new Properties()) : I2PSocketManagerFactory.createManager();
        Destination peer = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(this._peerDestFile);
            peer = new Destination();
            peer.readBytes((InputStream)fis);
        }
        catch (IOException ioe) {
            this._log.error("Error finding the peer destination to contact in " + this._peerDestFile, (Throwable)ioe);
            return;
        }
        catch (DataFormatException dfe) {
            this._log.error("Peer destination is not valid in " + this._peerDestFile, (Throwable)dfe);
            return;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ioe) {}
            }
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Send " + this._sendSize + "KB to " + peer.calculateHash().toBase64());
        }
        while (true) {
            try {
                while (true) {
                    I2PSocket sock = mgr.connect(peer);
                    byte[] buf = new byte[Math.min(32768, this._sendSize * 1024)];
                    Random rand = new Random();
                    OutputStream out = sock.getOutputStream();
                    long beforeSending = System.currentTimeMillis();
                    for (int i = 0; this._sendSize < 0 || i < this._sendSize; i += buf.length / 1024) {
                        rand.nextBytes(buf);
                        out.write(buf);
                        if (this._log.shouldLog(10)) {
                            this._log.debug("Wrote " + (1 + i * buf.length) / 1024 + "/" + this._sendSize + "KB");
                        }
                        if (this._writeDelay <= 0) continue;
                        try {
                            Thread.sleep(this._writeDelay);
                            continue;
                        }
                        catch (InterruptedException ie) {
                            // empty catch block
                        }
                    }
                    sock.close();
                    long afterSending = System.currentTimeMillis();
                    if (!this._log.shouldLog(10)) continue;
                    this._log.debug("Sent " + this._sendSize + "KB in " + (afterSending - beforeSending) + "ms");
                }
            }
            catch (InterruptedIOException iie) {
                this._log.error("Timeout connecting to the peer", (Throwable)iie);
                continue;
            }
            catch (NoRouteToHostException nrthe) {
                this._log.error("Unable to connect to the peer", (Throwable)nrthe);
                continue;
            }
            catch (ConnectException ce) {
                this._log.error("Connection already dropped", (Throwable)ce);
                continue;
            }
            catch (I2PException ie) {
                this._log.error("Error connecting to the peer", (Throwable)ie);
                return;
            }
            catch (IOException ioe) {
                this._log.error("IO error sending", (Throwable)ioe);
                return;
            }
            break;
        }
    }

    public static void main(String[] args) {
        StreamSinkClient client = null;
        int sendSizeKB = -1;
        int writeDelayMs = -1;
        int concurrent = 1;
        switch (args.length) {
            case 3: 
            case 4: {
                try {
                    sendSizeKB = Integer.parseInt(args[0]);
                }
                catch (NumberFormatException nfe) {
                    System.err.println("Send size invalid [" + args[0] + "]");
                    return;
                }
                try {
                    writeDelayMs = Integer.parseInt(args[1]);
                }
                catch (NumberFormatException nfe) {
                    System.err.println("Write delay ms invalid [" + args[1] + "]");
                    return;
                }
                if (args.length == 4) {
                    try {
                        concurrent = Integer.parseInt(args[3]);
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                }
                client = new StreamSinkClient(sendSizeKB, writeDelayMs, args[2]);
                break;
            }
            case 5: 
            case 6: {
                try {
                    int port = Integer.parseInt(args[1]);
                    sendSizeKB = Integer.parseInt(args[2]);
                    writeDelayMs = Integer.parseInt(args[3]);
                    client = new StreamSinkClient(args[0], port, sendSizeKB, writeDelayMs, args[4]);
                }
                catch (NumberFormatException nfe) {
                    System.err.println("arg error");
                }
                if (args.length != 6) break;
                try {
                    concurrent = Integer.parseInt(args[5]);
                }
                catch (NumberFormatException nfe) {}
                break;
            }
            default: {
                System.out.println("Usage: StreamSinkClient [i2cpHost i2cpPort] sendSizeKB writeDelayMs serverDestFile [concurrentSends]");
            }
        }
        if (client != null) {
            for (int i = 0; i < concurrent; ++i) {
                new I2PThread((Runnable)new Runner(client), "Client " + i).start();
            }
        }
    }

    private static class Runner
    implements Runnable {
        private StreamSinkClient _client;

        public Runner(StreamSinkClient client) {
            this._client = client;
        }

        public void run() {
            this._client.runClient();
        }
    }
}

