/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming;

import java.util.ArrayList;
import java.util.List;
import net.i2p.I2PAppContext;
import net.i2p.client.I2PSession;
import net.i2p.client.I2PSessionException;
import net.i2p.client.I2PSessionListener;
import net.i2p.client.streaming.ConnectionManager;
import net.i2p.client.streaming.I2PSocketManager;
import net.i2p.client.streaming.Packet;
import net.i2p.util.Log;

public class MessageHandler
implements I2PSessionListener {
    private ConnectionManager _manager;
    private I2PAppContext _context;
    private Log _log;
    private List _listeners;

    public MessageHandler(I2PAppContext ctx, ConnectionManager mgr) {
        this._manager = mgr;
        this._context = ctx;
        this._listeners = new ArrayList(1);
        this._log = ctx.logManager().getLog(MessageHandler.class);
        this._context.statManager().createRateStat("stream.packetReceiveFailure", "When do we fail to decrypt or otherwise receive a packet sent to us?", "Stream", new long[]{3600000L, 86400000L});
    }

    public void messageAvailable(I2PSession session, int msgId, long size) {
        block6: {
            byte[] data = null;
            try {
                data = session.receiveMessage(msgId);
            }
            catch (I2PSessionException ise) {
                this._context.statManager().addRateData("stream.packetReceiveFailure", 1L, 0L);
                if (this._log.shouldLog(30)) {
                    this._log.warn("Error receiving the message", (Throwable)ise);
                }
                return;
            }
            if (data == null) {
                return;
            }
            Packet packet = new Packet();
            try {
                packet.readPacket(data, 0, data.length);
                this._manager.getPacketHandler().receivePacket(packet);
            }
            catch (IllegalArgumentException iae) {
                this._context.statManager().addRateData("stream.packetReceiveFailure", 1L, 0L);
                if (!this._log.shouldLog(30)) break block6;
                this._log.warn("Received an invalid packet", (Throwable)iae);
            }
        }
    }

    public void reportAbuse(I2PSession session, int severity) {
        if (this._log.shouldLog(40)) {
            this._log.error("Abuse reported with severity " + severity);
        }
        this._manager.disconnectAllHard();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnected(I2PSession session) {
        if (this._log.shouldLog(40)) {
            this._log.error("I2PSession disconnected");
        }
        this._manager.disconnectAllHard();
        ArrayList listeners = null;
        List list = this._listeners;
        synchronized (list) {
            listeners = new ArrayList(this._listeners);
            this._listeners.clear();
        }
        for (int i = 0; i < listeners.size(); ++i) {
            I2PSocketManager.DisconnectListener lsnr = (I2PSocketManager.DisconnectListener)listeners.get(i);
            lsnr.sessionDisconnected();
        }
    }

    public void errorOccurred(I2PSession session, String message, Throwable error) {
        if (this._log.shouldLog(30)) {
            this._log.warn("error occurred: " + message + "- " + error.getMessage());
        }
        if (this._log.shouldLog(30)) {
            this._log.warn("cause", error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDisconnectListener(I2PSocketManager.DisconnectListener lsnr) {
        List list = this._listeners;
        synchronized (list) {
            this._listeners.add(lsnr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDisconnectListener(I2PSocketManager.DisconnectListener lsnr) {
        List list = this._listeners;
        synchronized (list) {
            this._listeners.remove(lsnr);
        }
    }
}

