/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming;

import java.util.Arrays;
import net.i2p.I2PAppContext;
import net.i2p.data.Base64;
import net.i2p.data.ByteArray;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.data.Signature;
import net.i2p.data.SigningPrivateKey;
import net.i2p.util.Log;

public class Packet {
    private long _sendStreamId;
    private long _receiveStreamId;
    private long _sequenceNum;
    private long _ackThrough;
    private long[] _nacks;
    private int _resendDelay;
    private int _flags;
    private ByteArray _payload;
    private Signature _optionSignature;
    private Destination _optionFrom;
    private int _optionDelay;
    private int _optionMaxSize;
    public static final long STREAM_ID_UNKNOWN = 0L;
    public static final long MAX_STREAM_ID = 0xFFFFFFFFL;
    public static final int FLAG_SYNCHRONIZE = 1;
    public static final int FLAG_CLOSE = 2;
    public static final int FLAG_RESET = 4;
    public static final int FLAG_SIGNATURE_INCLUDED = 8;
    public static final int FLAG_SIGNATURE_REQUESTED = 16;
    public static final int FLAG_FROM_INCLUDED = 32;
    public static final int FLAG_DELAY_REQUESTED = 64;
    public static final int FLAG_MAX_PACKET_SIZE_INCLUDED = 128;
    public static final int FLAG_PROFILE_INTERACTIVE = 256;
    public static final int FLAG_ECHO = 512;
    public static final int FLAG_NO_ACK = 1024;
    public static final int DEFAULT_MAX_SIZE = 32768;
    private static final int MAX_DELAY_REQUEST = 65535;
    private boolean _sendStreamIdSet = false;
    private boolean _receiveStreamIdSet = false;
    public static final int MAX_PAYLOAD_SIZE = 32768;

    public long getSendStreamId() {
        return this._sendStreamId;
    }

    public void setSendStreamId(long id) {
        if (this._sendStreamIdSet && this._sendStreamId > 0L) {
            throw new RuntimeException("Send stream ID already set [" + this._sendStreamId + ", " + id + "]");
        }
        this._sendStreamIdSet = true;
        this._sendStreamId = id;
    }

    public long getReceiveStreamId() {
        return this._receiveStreamId;
    }

    public void setReceiveStreamId(long id) {
        if (this._receiveStreamIdSet && this._receiveStreamId > 0L) {
            throw new RuntimeException("Receive stream ID already set [" + this._receiveStreamId + ", " + id + "]");
        }
        this._receiveStreamIdSet = true;
        this._receiveStreamId = id;
    }

    public long getSequenceNum() {
        return this._sequenceNum;
    }

    public void setSequenceNum(long num) {
        this._sequenceNum = num;
    }

    public long getAckThrough() {
        if (this.isFlagSet(1024)) {
            return -1L;
        }
        return this._ackThrough;
    }

    public void setAckThrough(long id) {
        if (id < 0L) {
            this.setFlag(1024);
        }
        this._ackThrough = id;
    }

    public long[] getNacks() {
        return this._nacks;
    }

    public void setNacks(long[] nacks) {
        this._nacks = nacks;
    }

    public int getResendDelay() {
        return this._resendDelay;
    }

    public void setResendDelay(int numSeconds) {
        this._resendDelay = numSeconds;
    }

    public ByteArray getPayload() {
        return this._payload;
    }

    public void setPayload(ByteArray payload) {
        this._payload = payload;
        if (payload != null && payload.getValid() > 32768) {
            throw new IllegalArgumentException("Too large payload: " + payload.getValid());
        }
    }

    public int getPayloadSize() {
        return this._payload == null ? 0 : this._payload.getValid();
    }

    public void releasePayload() {
    }

    public ByteArray acquirePayload() {
        ByteArray old = this._payload;
        this._payload = new ByteArray(new byte[32768]);
        return this._payload;
    }

    public boolean isFlagSet(int flag) {
        return 0 != (this._flags & flag);
    }

    public void setFlag(int flag) {
        this._flags |= flag;
    }

    public void setFlag(int flag, boolean set) {
        this._flags = set ? (this._flags |= flag) : (this._flags &= ~flag);
    }

    public void setFlags(int flags) {
        this._flags = flags;
    }

    public Signature getOptionalSignature() {
        return this._optionSignature;
    }

    public void setOptionalSignature(Signature sig) {
        this.setFlag(8, sig != null);
        this._optionSignature = sig;
    }

    public Destination getOptionalFrom() {
        return this._optionFrom;
    }

    public void setOptionalFrom(Destination from) {
        this.setFlag(32, from != null);
        if (from == null) {
            throw new RuntimeException("from is null!?");
        }
        this._optionFrom = from;
    }

    public int getOptionalDelay() {
        return this._optionDelay;
    }

    public void setOptionalDelay(int delayMs) {
        this._optionDelay = delayMs > 65535 ? 65535 : (delayMs < 0 ? 0 : delayMs);
    }

    public int getOptionalMaxSize() {
        return this._optionMaxSize;
    }

    public void setOptionalMaxSize(int numBytes) {
        this.setFlag(128, numBytes > 0);
        this._optionMaxSize = numBytes;
    }

    public int writePacket(byte[] buffer, int offset) throws IllegalStateException {
        return this.writePacket(buffer, offset, true);
    }

    private int writePacket(byte[] buffer, int offset, boolean includeSig) throws IllegalStateException {
        int cur = offset;
        DataHelper.toLong((byte[])buffer, (int)cur, (int)4, (long)(this._sendStreamId >= 0L ? this._sendStreamId : 0L));
        DataHelper.toLong((byte[])buffer, (int)(cur += 4), (int)4, (long)(this._receiveStreamId >= 0L ? this._receiveStreamId : 0L));
        DataHelper.toLong((byte[])buffer, (int)(cur += 4), (int)4, (long)(this._sequenceNum > 0L ? this._sequenceNum : 0L));
        DataHelper.toLong((byte[])buffer, (int)(cur += 4), (int)4, (long)(this._ackThrough > 0L ? this._ackThrough : 0L));
        cur += 4;
        if (this._nacks != null) {
            DataHelper.toLong((byte[])buffer, (int)cur, (int)1, (long)this._nacks.length);
            ++cur;
            for (int i = 0; i < this._nacks.length; ++i) {
                DataHelper.toLong((byte[])buffer, (int)cur, (int)4, (long)this._nacks[i]);
                cur += 4;
            }
        } else {
            DataHelper.toLong((byte[])buffer, (int)cur, (int)1, (long)0L);
            ++cur;
        }
        DataHelper.toLong((byte[])buffer, (int)cur, (int)1, (long)(this._resendDelay > 0 ? (long)this._resendDelay : 0L));
        DataHelper.toLong((byte[])buffer, (int)(++cur), (int)2, (long)this._flags);
        cur += 2;
        int optionSize = 0;
        if (this.isFlagSet(64)) {
            optionSize += 2;
        }
        if (this.isFlagSet(32)) {
            optionSize += this._optionFrom.size();
        }
        if (this.isFlagSet(128)) {
            optionSize += 2;
        }
        if (this.isFlagSet(8)) {
            optionSize += 40;
        }
        DataHelper.toLong((byte[])buffer, (int)cur, (int)2, (long)optionSize);
        cur += 2;
        if (this.isFlagSet(64)) {
            DataHelper.toLong((byte[])buffer, (int)cur, (int)2, (long)(this._optionDelay > 0 ? (long)this._optionDelay : 0L));
            cur += 2;
        }
        if (this.isFlagSet(32)) {
            cur += this._optionFrom.writeBytes(buffer, cur);
        }
        if (this.isFlagSet(128)) {
            DataHelper.toLong((byte[])buffer, (int)cur, (int)2, (long)(this._optionMaxSize > 0 ? (long)this._optionMaxSize : 32768L));
            cur += 2;
        }
        if (this.isFlagSet(8)) {
            if (includeSig) {
                System.arraycopy(this._optionSignature.getData(), 0, buffer, cur, 40);
            } else {
                Arrays.fill(buffer, cur, cur + 40, (byte)0);
            }
            cur += 40;
        }
        if (this._payload != null) {
            try {
                System.arraycopy(this._payload.getData(), this._payload.getOffset(), buffer, cur, this._payload.getValid());
            }
            catch (ArrayIndexOutOfBoundsException aioobe) {
                System.err.println("payload.length: " + this._payload.getValid() + " buffer.length: " + buffer.length + " cur: " + cur);
                throw aioobe;
            }
            cur += this._payload.getValid();
        }
        return cur - offset;
    }

    public int writtenSize() throws IllegalStateException {
        int size = 0;
        size += 4;
        size += 4;
        size += 4;
        size += 4;
        if (this._nacks != null) {
            ++size;
            size += 4 * this._nacks.length;
        } else {
            ++size;
        }
        ++size;
        size += 2;
        if (this.isFlagSet(64)) {
            size += 2;
        }
        if (this.isFlagSet(32)) {
            size += this._optionFrom.size();
        }
        if (this.isFlagSet(128)) {
            size += 2;
        }
        if (this.isFlagSet(8)) {
            size += 40;
        }
        size += 2;
        if (this._payload != null) {
            size += this._payload.getValid();
        }
        return size;
    }

    public void readPacket(byte[] buffer, int offset, int length) throws IllegalArgumentException {
        if (buffer.length - offset < length) {
            throw new IllegalArgumentException("len=" + buffer.length + " off=" + offset + " length=" + length);
        }
        if (length < 22) {
            throw new IllegalArgumentException("Too small: len=" + buffer.length);
        }
        int cur = offset;
        this.setSendStreamId(DataHelper.fromLong((byte[])buffer, (int)cur, (int)4));
        this.setReceiveStreamId(DataHelper.fromLong((byte[])buffer, (int)(cur += 4), (int)4));
        this.setSequenceNum(DataHelper.fromLong((byte[])buffer, (int)(cur += 4), (int)4));
        this.setAckThrough(DataHelper.fromLong((byte[])buffer, (int)(cur += 4), (int)4));
        int numNacks = (int)DataHelper.fromLong((byte[])buffer, (int)(cur += 4), (int)1);
        ++cur;
        if (length < 22 + numNacks * 4) {
            throw new IllegalArgumentException("Too small with " + numNacks + " nacks: " + length);
        }
        if (numNacks > 0) {
            long[] nacks = new long[numNacks];
            for (int i = 0; i < numNacks; ++i) {
                nacks[i] = DataHelper.fromLong((byte[])buffer, (int)cur, (int)4);
                cur += 4;
            }
            this.setNacks(nacks);
        } else {
            this.setNacks(null);
        }
        this.setResendDelay((int)DataHelper.fromLong((byte[])buffer, (int)cur, (int)1));
        this.setFlags((int)DataHelper.fromLong((byte[])buffer, (int)(++cur), (int)2));
        int optionSize = (int)DataHelper.fromLong((byte[])buffer, (int)(cur += 2), (int)2);
        cur += 2;
        if (length < 22 + numNacks * 4 + optionSize) {
            throw new IllegalArgumentException("Too small with " + numNacks + " nacks and " + optionSize + " options: " + length);
        }
        int payloadBegin = cur + optionSize;
        int payloadSize = length - payloadBegin;
        if (payloadSize < 0 || payloadSize > 32768) {
            throw new IllegalArgumentException("length: " + length + " offset: " + offset + " begin: " + payloadBegin);
        }
        this._payload = new ByteArray(buffer, payloadBegin, payloadSize);
        if (this.isFlagSet(64)) {
            this.setOptionalDelay((int)DataHelper.fromLong((byte[])buffer, (int)cur, (int)2));
            cur += 2;
        }
        if (this.isFlagSet(32)) {
            Destination optionFrom = new Destination();
            try {
                cur += optionFrom.readBytes(buffer, cur);
                this.setOptionalFrom(optionFrom);
            }
            catch (DataFormatException dfe) {
                throw new IllegalArgumentException("Bad from field: " + dfe.getMessage());
            }
        }
        if (this.isFlagSet(128)) {
            this.setOptionalMaxSize((int)DataHelper.fromLong((byte[])buffer, (int)cur, (int)2));
            cur += 2;
        }
        if (this.isFlagSet(8)) {
            Signature optionSignature = new Signature();
            byte[] buf = new byte[40];
            System.arraycopy(buffer, cur, buf, 0, 40);
            optionSignature.setData(buf);
            this.setOptionalSignature(optionSignature);
            cur += 40;
        }
    }

    public boolean verifySignature(I2PAppContext ctx, Destination from, byte[] buffer) {
        Log l;
        int written;
        if (!this.isFlagSet(8)) {
            return false;
        }
        if (this._optionSignature == null) {
            return false;
        }
        int size = this.writtenSize();
        if (buffer == null) {
            buffer = new byte[size];
        }
        if ((written = this.writePacket(buffer, 0, false)) != size) {
            ctx.logManager().getLog(Packet.class).error("Written " + written + " size " + size + " for " + this.toString(), (Throwable)new Exception("moo"));
            return false;
        }
        boolean ok = ctx.dsa().verifySignature(this._optionSignature, buffer, 0, size, from.getSigningPublicKey());
        if (!ok && (l = ctx.logManager().getLog(Packet.class)).shouldLog(30)) {
            l.warn("Signature failed on " + this.toString(), (Throwable)new Exception("moo"));
        }
        return ok;
    }

    public int writeSignedPacket(byte[] buffer, int offset, I2PAppContext ctx, SigningPrivateKey key) throws IllegalStateException {
        this.setFlag(8);
        int size = this.writePacket(buffer, offset, false);
        this._optionSignature = ctx.dsa().sign(buffer, offset, size, key);
        int signatureOffset = offset + 4 + 4 + 4 + 4 + (this._nacks != null ? 4 * this._nacks.length + 1 : 1) + 1 + 2 + 2 + (this.isFlagSet(64) ? 2 : 0) + (this.isFlagSet(32) ? this._optionFrom.size() : 0) + (this.isFlagSet(128) ? 2 : 0);
        System.arraycopy(this._optionSignature.getData(), 0, buffer, signatureOffset, 40);
        return size;
    }

    public String toString() {
        StringBuffer str = this.formatAsString();
        return str.toString();
    }

    protected StringBuffer formatAsString() {
        StringBuffer buf = new StringBuffer(64);
        buf.append(Packet.toId(this._sendStreamId));
        buf.append(Packet.toId(this._receiveStreamId)).append(": #").append(this._sequenceNum);
        if (this._sequenceNum < 10L) {
            buf.append(" \t");
        } else {
            buf.append('\t');
        }
        buf.append(this.toFlagString());
        buf.append(" ACK ").append(this.getAckThrough());
        if (this._nacks != null) {
            buf.append(" NACK");
            for (int i = 0; i < this._nacks.length; ++i) {
                buf.append(" ").append(this._nacks[i]);
            }
        }
        if (this._payload != null && this._payload.getValid() > 0) {
            buf.append(" data: ").append(this._payload.getValid());
        }
        return buf;
    }

    static final String toId(long id) {
        return Base64.encode((byte[])DataHelper.toLong((int)4, (long)id));
    }

    private final String toFlagString() {
        StringBuffer buf = new StringBuffer(32);
        if (this.isFlagSet(2)) {
            buf.append(" CLOSE");
        }
        if (this.isFlagSet(64)) {
            buf.append(" DELAY ").append(this._optionDelay);
        }
        if (this.isFlagSet(512)) {
            buf.append(" ECHO");
        }
        if (this.isFlagSet(32)) {
            buf.append(" FROM");
        }
        if (this.isFlagSet(128)) {
            buf.append(" MS ").append(this._optionMaxSize);
        }
        if (this.isFlagSet(256)) {
            buf.append(" INTERACTIVE");
        }
        if (this.isFlagSet(4)) {
            buf.append(" RESET");
        }
        if (this.isFlagSet(8)) {
            buf.append(" SIG");
        }
        if (this.isFlagSet(16)) {
            buf.append(" SIGREQ");
        }
        if (this.isFlagSet(1)) {
            buf.append(" SYN");
        }
        return buf.toString();
    }
}

