/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming;

import net.i2p.client.streaming.I2PSocketManagerFull;
import net.i2p.client.streaming.StreamSinkClient;
import net.i2p.client.streaming.StreamSinkSend;
import net.i2p.client.streaming.StreamSinkServer;

public class StreamSinkTest {
    private static String HOST1 = "localhost";
    private static String HOST2 = "localhost";
    private static String PORT1 = "10001";
    private static String PORT2 = "11001";

    public static void main(String[] args) {
        boolean old = false;
        int hops = 0;
        int kb = 32768;
        if (args.length > 0 && "old".equals(args[0])) {
            old = true;
        }
        if (args.length > 1) {
            try {
                hops = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException nfe) {
                hops = 0;
            }
        }
        if (args.length > 2) {
            try {
                kb = Integer.parseInt(args[2]);
            }
            catch (NumberFormatException nfe) {
                kb = 32768;
            }
        }
        if (!old) {
            System.setProperty("i2p.streaming.manager", I2PSocketManagerFull.class.getName());
        }
        System.setProperty("tunnels.depthInbound", "" + hops);
        new Thread(new Runnable(){

            public void run() {
                StreamSinkServer.main((String[])new String[]{HOST1, PORT1, "streamSinkTestDir", "streamSinkTestServer.key"});
            }
        }, "server").start();
        try {
            Thread.sleep(60000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        StreamSinkTest.run(kb, 1);
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        System.out.println("Shutting down");
        System.exit(0);
    }

    private static void run(final int kb, final int msBetweenWrites) {
        Thread t = new Thread(new Runnable(){

            public void run() {
                StreamSinkClient.main((String[])new String[]{HOST2, PORT2, kb + "", msBetweenWrites + "", "streamSinkTestServer.key"});
            }
        });
        t.start();
        System.out.println("client and server started: size = " + kb + "KB, delay = " + msBetweenWrites);
        try {
            t.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static void run(final String filename, final int msBetweenWrites) {
        Thread t = new Thread(new Runnable(){

            public void run() {
                StreamSinkSend.main((String[])new String[]{filename, msBetweenWrites + "", "streamSinkTestServer.key"});
            }
        });
        t.start();
        System.out.println("client and server started: file " + filename + ", delay = " + msBetweenWrites);
        try {
            t.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

