/***************************************************************************
                          chatwindowinterface.h  -  description
                             -------------------
    begin                : Tue Apr 23 2002
    copyright            : (C) 2002 by Mike K. Bennett
    email                : mkb137b@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CHATWINDOWINTERFACE_H
#define CHATWINDOWINTERFACE_H

#include <qwidget.h>
#include <kmainwindow.h>

// forward declarations
class KActionMenu;
class KConfig;
class KHelpMenu;
class KPopupMenu;
class KToggleAction;
class KToolBarButton;
class KToolBarPopupAction;


/**The interface for the chat window, defining the menus.
  *@author Mike K. Bennett
  */

class ChatWindowInterface : public KMainWindow
{
  Q_OBJECT

  public:
    // The constructor
                     ChatWindowInterface(QWidget *parent=0, const char *name=0);
    // The destructor
                    ~ChatWindowInterface();

  protected: // Protected methods
    // Restore the window properties (called by KMainWindow)
    virtual void     readProperties(KConfig *config);
    // Save the window properties (called by KMainWindow)
    virtual void     saveProperties(KConfig *config);

  protected slots: // Protected slots
    // put the marked text/object into the clipboard and remove
    //	it from the document
    virtual void     editCut();
    // put the marked text/object into the clipboard
    virtual void     editCopy();
    // Bring up a dialog to change the message font color.
    virtual void     editFontColor();
    // Bring up a dialog to change the message font color.
    virtual void     editFont();
    // paste the clipboard into the document
    virtual void     editPaste();
    // enlarge the text size
    virtual void     editZoomIn();
    // decrease the text size
    virtual void     editZoomOut();
    // The emoticon button was pressed.
    virtual void     emoticonButtonPressed();
    // "Show status bar" was toggled.
    virtual void     showStatusBar();
    // Start GnomeMeeting with a contact.
    virtual void     startMeeting();
    // Change the status bar message.
    virtual void     statusMessage(QString message);
    // Called when the "use emoticons" action is called.
    virtual void     toggleEmoticons(bool useEmoticons);
    // Called when the "show sidebar" action is called.
    virtual void     toggleSidebar();
    // Called when the "use spell checking" action is called.
    virtual void     toggleSpellCheck(bool useSpellCheck);
    // Send a nudge
    virtual void     slotSendNudge();
    // Send a file to a contact.
    virtual void     slotStartFileTransfer( QStringList uriList = QStringList() );
    // Save the chat according to the user's request
    virtual void     saveChat();
    //Voice conversation
    virtual void     startConversation();

  protected: // Protected attributes
    // The list of invitable contacts
    KPopupMenu      *inviteMenu_;
    // The emoticon toggle
    KToggleAction   *emoticonAction_;
    // The emoticon chooser button
    KToolBarButton  *emoticonButton_;
    // Toggle actions for showing and hiding the toolbars and statusbars.
    KToggleAction   *showStatusBar_, *showToolBar_;
    // The sidebar toggle
    KAction         *sidebarAction_;
    // The spell checking toggle
    KToggleAction   *spellCheckAction_;


  private: // Private methods
    // Initialize the connect menu.
    void             initChatMenu();
    // Initialize the settings menu.
    void             initEditMenu();
    // Initialize the help menu.
    void             initHelpMenu();
    // Create the menus.
    void             initMenus();
    // Initialize the settings menu.
    void             initSettingsMenu();

  private slots: // Private slots
    // Show the "about KMess" message.
    void             aboutKMess();
    // Show the "about KDE" message.
    void             aboutKDE();
    // Close the chat window
    void             fileClose();
     // Show the user manual for KMess.
    void             helpContents();
    // "Show toolbar" was toggled.
    void             showToolBar();

  private: // private attributes
    // The help menu launcher
    KHelpMenu       *helpMenu_;

};
#endif
