/***************************************************************************
                          websidebar.h -  description
                             -------------------
    begin                : Sat Oct 8 2005
    copyright            : (C) 2005 by Diederik van der Boor
    email                : vdboor --at-- codingdomain.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef WEBSIDEBAR_H
#define WEBSIDEBAR_H

#include <qwidget.h>
#include <kparts/browserextension.h>

class KHTMLPart;
class KURL;
class MsnAppDirectoryService;

/**
 * A sidebar with web-based content.
 * @author Diederik van der Boor
 */
class WebSidebar : public QWidget
{
  Q_OBJECT

  public:
    // The constructor
                               WebSidebar(QWidget *parent=0, const char *name=0);
    // The destructor
    virtual                   ~WebSidebar();
    // Initialize the sidebar
    bool                       initialize();

  private slots:
    // Open a new url in the khtml widget
    void                       slotOpenURLRequest(const KURL &url, const KParts::URLArgs &args);
    // A request to the msn appdir finished
    void                       slotRequestFinished();

  private:
    // Request the list of games from the msn server
    void                       requestGameList();

  private:
    // The connection to the appdir server
    MsnAppDirectoryService     *appdirService_;
    // The embedded khtml part
    KHTMLPart                  *khtml_;
};

#endif
