/***************************************************************************
                          kmessinterface.h  -  description
                             -------------------
    begin                : Sun Dec 29 2002
    copyright            : (C) 2002 by Mike K. Bennett
    email                : mkb137b@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KMESSINTERFACE_H
#define KMESSINTERFACE_H

#include <qwidget.h>

#include <kapp.h>
#include <kmainwindow.h>
#include "kmessdebug.h"

// Forward declarations
class QHBox;
class QLabel;
class KActionMenu;
class KConfig;
class KHelpMenu;
class KMessTest;
class KPopupMenu;
class KSelectAction;
class KToggleAction;
class SystemTrayWidget;

/**
 * @brief User interface of the KMess class.
 *
 * This is the user interface of the KMess class, providing the menu items,
 * virtual implementations of some functions, and implementations of windowing-specific functions.
 *
 * @author Mike K. Bennett
 * @ingroup Root
 */
class KMessInterface : public KMainWindow
{
  Q_OBJECT

  public: // Public methods

    // Message Types shown in the Status Bar
    enum ConnectionStatus
    {
      TYPE_MESSAGE,
      TYPE_WARNING,
      TYPE_ERROR
    };

    friend class     KMessTest;
    // The constructor
                     KMessInterface(QWidget *parent=0, const char *name=0);
    // The destructor
    virtual         ~KMessInterface();

  protected: // Protected methods
    // The application is closing, after queryExit() was approved
    virtual void     applicationClosing();
    // Enable/disable menus based on whether or not the application is
    //  connected to the server.
    virtual void     enableMenus(bool connected);
    // Initialize the class
    virtual bool     initialize();

    // Restore the window properties (called by KMainWindow)
    virtual void     readProperties(KConfig *config);
    // Save the window properties (called by KMainWindow)
    virtual void     saveProperties(KConfig *config);

  protected slots: // Protected slots
    // "Add a new contact" was selected from the menu.
    virtual void     addNewContact();
    // "Add a new group" was selected from the menu.
    virtual void     addNewGroup();
    // A status was selected from the menu.
    virtual void     changeStatus(const QString &statusName);
    // A view mode has been selected from the menu.
    virtual void     changeViewMode(int mode);
    // Request to display the network window has been made
    virtual void     showNetworkWindow();
    // Request to display the transfer manager.
    virtual void     showTransferWindow();
    // "Add new account" has been selected from the menu.
    virtual void     createNewAccount();
    // Disconnect was selected from the menu.
    virtual void     disconnectClicked();
    // Show the user's MSN profile.
    virtual void     showUserProfile();
    // Change the status bar message.
    virtual void     statusMessage(QString message, KMessInterface::ConnectionStatus connectStatus = TYPE_ERROR );
    // The "show display pictures" menu item has been toggled.
    virtual void     toggleDisplayPictures(bool show);
    // The "show allowed contacts" menu item has been toggled.
    virtual void     toggleShowAllowed(bool show);
    // The "show offline contacts" menu item has been toggled.
    virtual void     toggleShowOffline(bool show);
    // The "Show removed contacts" menu item has been toggled.
    virtual void     toggleShowRemoved(bool show);
    // Increment and update the online timer.
    void             updateOnlineTimer();

  protected: // Protected attributes
    // The menu for "connect..." with a profile
    KActionMenu     *connectActionMenu_;
    // The "disconnect" menu item
    KAction         *disconnect_;
    KAction         *configureNotifications_;
    // The menu for "settings..." with a profile
    KActionMenu     *settingsActionMenu_;
    // Toggle actions for showing allowed, offline, and removed contacts.
    KToggleAction   *showAllowedAction_, *showOfflineAction_, *showRemovedAction_;
    // Show the network window
    KAction         *showNetworkAction_;
    // Toggle actions for showing display pictures in contact list.
    KToggleAction *showPicturesAction_;
    // Show the transfer manager
    KAction         *showTransferAction_;
    // The select action for the user's status
    KSelectAction   *status_;
    // The system tray widget
    SystemTrayWidget *systemTrayWidget_;
    // The menu for selecting the view mode.
    KSelectAction   *viewMode_;

  private: // Private methods
    // Create the "Actions" menu
    void             createActionsMenu();
    // Create the "Connect" menu
    void             createConnectMenu();
    // Create the "Help" menu
    void             createHelpMenu();
    // Create the menus
    void             createMenus();
    // Create the "View" menu
    void             createViewMenu();
    // Initialize the system tray widget
    bool             initSystemTrayWidget();
    // Reject quitting unless the quit menu was pressed
    bool             queryExit();
    // Tell the user that KMess hides in the systray
    bool             queryClose();

  private slots: // Private slots
    // Show the "about KMess" message.
    void             aboutKMess();
    // Show the "about KDE" message.
    void             aboutKDE();
    // Show the notifications dialog
    void             configureNotifications();
    // Show the user manual for KMess.
    void             helpContents();
    // Close has been selected from the menu.
    void             menuClose();
    // Quit was selected from the menu.
    void             menuQuit();
    // Open up the URL for hotmail's contact search page.
    void             searchForContact();
    // Open up the URL to MSN's "search by interest" page.
    void             searchForContactByInterest();
    // "Show status bar" was toggled.
    void             showStatusBar();
    // "Show toolbar" was toggled.
    void             showToolBar();

  private: // Private attributes
    // The current connection state
    ConnectionStatus connectState_;
    // The help menu launcher
    KHelpMenu       *helpMenu_;
    // Whether or not the object was initialized
    bool             initialized_;
    // Some action menus that the child doesn't need, but need to be
    //  made visible/invisible
    KAction         *newContact_, *newGroup_, *showProfile_;
    // Minutes online
    unsigned int     onlineTime_;
    // Online interval timer
    QTimer          *onlineTimer_;
    // Toggle actions for showing and hiding the toolbars and statusbars.
    KToggleAction   *showStatusBar_, *showToolBar_;
    // Status messages
    QLabel          *statusLabel_;
    // Online timer
    QLabel          *statusTimer_;
    // The view menu - stored here because it needs to be enabled/disabled
    KPopupMenu      *viewMenu_;
};

#endif
