/***************************************************************************
   Copyright (C) 2007
   by Marco Gulino <marco@kmobiletools.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/
#ifndef SMSLIST_H
#define SMSLIST_H

#include <qptrlist.h>
#include "sms.h"

/**
@author Marco Gulino
*/

class SMSList : public QObject, public QPtrList<SMS>
{
    Q_OBJECT
public:
    SMSList(const char *enginename=0);

    ~SMSList();
    void append(SMSList *sublist, bool sync=false);
    void append(SMS *sms);
    int find(const QCString &uid);
    void sync (SMSList *compList);
    void dump();
    void calcSMSNumber();
    int count(int smsType, int memSlot);
    uint count() { return QPtrList<SMS>::count(); }
    void resetCount()
    {i_unread_phone=i_unread_sim=i_read_phone=i_read_sim=i_unsent_phone=i_unsent_sim=i_sent_phone=i_sent_sim=0;}
    void setEngineName(const QString &enginename) { s_enginename=enginename; }
    QString engineName() const { return s_enginename; }
    protected:
        int compareItems( QPtrCollection::Item item1, QPtrCollection::Item item2);
    private:
        int i_unread_phone, i_unread_sim;
        int i_read_phone, i_read_sim;
        int i_sent_phone, i_sent_sim;
        int i_unsent_phone, i_unsent_sim;
        QString s_enginename;

    signals:
        void removed(const QCString&);
        void added(const QCString&);
        void modified(const QCString&);
        void updated();
public slots:
    void saveToMailBox(const QString &engineName);
    void saveToMailBox();
    int saveToCSV(const QString &engineName);
    int saveToCSV();
};

#endif
