/***************************************************************************
   Copyright (C) 2006
   by Marco Gulino <marco@kmobiletools.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/

#ifndef BLUEDEVICE_H
#define BLUEDEVICE_H

#include <qobject.h>
#include <qstring.h>
#include <qvaluelist.h>

#include "btservice.h"

/**
	@author Marco Gulino <marco@kmobiletools.org>
*/
class BlueDevice
{
public:
    BlueDevice();
    BlueDevice(const QString &devName, const QString &address);

    ~BlueDevice();
    void setDevName(const QString &name) { s_name=name.stripWhiteSpace(); }
    void setAddress(const QString &addr) { s_address=addr.stripWhiteSpace(); }
    QString devName() const { return s_name; }
    QString address() const { return s_address; }
    BTServices *serviceList() { return &btSvcList; }
    friend inline bool operator==( BlueDevice a, BlueDevice b ) { return (a.address() == b.address() ); }
    private:
        QString s_address;
        QString s_name;
        BTServices btSvcList;
};


class BlueDevices : public QValueList<BlueDevice>
{
    public:
        BlueDevices();
        ~BlueDevices();
        void append(BlueDevice item);
};

#endif
