/***************************************************************************
   Copyright (C) 2006
   by Marco Gulino <marco@kmobiletools.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/

#ifndef BTSERVICE_H
#define BTSERVICE_H

#include <qstring.h>
#include <qvaluelist.h>

/**
	@author Marco Gulino <marco@kmobiletools.org>
*/
class BTService
{
public:
    BTService();
    BTService(const QString &svcName, int channel);
    ~BTService();
    int channel() const { return i_channel; }
    QString svcName() const { return s_name; }
    void setSvcName(const QString &name) { s_name=name.stripWhiteSpace(); }
    void setChannel(int channel) { i_channel=channel; }
    private:
        int i_channel;
        QString s_name;
};

class BTServices : public QValueList<BTService>
{
    public:
        BTServices();
        ~BTServices();
};

#endif
