/***************************************************************************
   Copyright (C) 2006
   by Marco Gulino <marco@kmobiletools.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/



#ifndef _KBLUETOOTHPAIRINGWIZARD_H_
#define _KBLUETOOTHPAIRINGWIZARD_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <klistview.h>

#include "bluedevice.h"
#include "btservice.h"
#include "kbluetoothpairingwizardwidgetbase.h"
#include <klocale.h>

/**
 * @short Application Main Window
 * @author Marco Gulino <marco@kmobiletools.org>
 * @version 0.1
 */
class QProcess;
class QTimer;
class KProgressDialog;
class KBluetoothPairingWizard : public KBluetoothPairingWizardWidgetBase
{
    Q_OBJECT
public:
    /**
     * Default Constructor
     */
    KBluetoothPairingWizard();

    /**
     * Default Destructor
     */
    virtual ~KBluetoothPairingWizard();
    private:
        QTimer *scanTimer;
        QProcess *hcitool;
        QProcess *sdptool;
        BlueDevices devicesList;
        KProgressDialog *progressDialog;
        BlueDevice *curDevice;
        BTService *curSVC;
        QString exenotfoundmsg;
        QString exitedErrorMsg;
        bool discoverycancelled;
    public slots:
    void scanDevices();
    void scanServices();
    void advanceScan();
    void devicesFound();
    void servicesFound();
    void selected(const QString &);
    void currentChanged ( QListViewItem * );
    void fileChanged (const QString &);
protected slots:
    void done ( int r );
};

class BlueListViewItem : public KListViewItem
{
    public:
        BlueListViewItem( const BlueDevice &device, QListView *parent):KListViewItem(parent){
            setText(0, device.devName() );
            setText(1, device.address() );
            b_device=device;
        }
        BlueDevice *device() { return &b_device; }
    private:
        BlueDevice b_device;
};

class ServiceListViewItem : public KListViewItem
{
    public:
        ServiceListViewItem( const BTService &svc, QListView *parent):KListViewItem(parent){
            setText(0, svc.svcName() );
            setText(1, QString::number(svc.channel() ) );
            b_service=svc;
        }
        BTService *service() { return &b_service; }
    private:
        BTService b_service;
};

#endif // _KBLUETOOTHPAIRINGWIZARD_H_
