/***************************************************************************
   Copyright (C) 2006
   by Marco Gulino <marco@kmobiletools.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/



#include "kbluetoothpairingwizard.h"
#include <kapplication.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>
#include <kuser.h>
#include <kdebug.h>
#include <unistd.h>
#include <kstandarddirs.h>
#include <sys/types.h>
#include <kprocess.h>
#include <stdlib.h>

static const char description[] =
    I18N_NOOP("A KDE KPart Application");

static const char version[] = "0.1";

static KCmdLineOptions options[] =
{
//    { "+[URL]", I18N_NOOP( "Document to open" ), 0 },
    KCmdLineLastOption
};

bool sudoRun(KCmdLineArgs *args)
{
    QString thisAppName=KStandardDirs::findExe(args->appName());
    kdDebug() << "Trying to start " << thisAppName << endl;
    KProcess process;
    process << "kdesu" << "-t" << KProcess::quote(thisAppName);
    if(process.start( KProcess::Block ) && process.exitStatus()==0 ) return true;
    process.clearArguments();
    process << "gksu" << "-d" << KProcess::quote(thisAppName);
    if(process.start( KProcess::Block ) && process.exitStatus()==0 ) return true;
    return false;
}

int main(int argc, char **argv)
{
    KAboutData about("kbluetoothpairingwizard", I18N_NOOP("KBluetoothPairingWizard"), version, description,
                     KAboutData::License_GPL, "(C) 2006 Marco Gulino", 0, 0, "marco@kmobiletools.org");
    about.addAuthor( "Marco Gulino", 0, "marco@kmobiletools.org" );
    KCmdLineArgs::init(argc, argv, &about);
    KCmdLineArgs::addCmdLineOptions( options );
    KApplication app;
    KBluetoothPairingWizard *mainWin = 0;

//     if (app.isRestored())
//     {
// //         RESTORE(KBluetoothPairingWizard);
//     }
//     else
//     {
        // no session.. just start up normally
    KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
    if( /*false && */! KUser(getuid() ).isSuperUser() )
    {
        if (sudoRun(args)) return 0; else return -1;
    }
    else kdDebug() << "We're ROOT! Yuppie!\n";

    mainWin = new KBluetoothPairingWizard();
    app.setMainWidget( mainWin );
    mainWin->show();

    args->clear();
//     }

    // mainWin has WDestructiveClose flag by default, so it will delete itself.
    return app.exec();
}

