/***************************************************************************
   Copyright (C) 2007
   by Marco Gulino <marco@kmobiletools.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/
 
#include "addressdetails.h"

#include <kabc/addressee.h>
#include <kabc/phonenumber.h>
#include <kiconloader.h>
#include <klocale.h>
#include <qstylesheet.h>
#include <kglobalsettings.h>
#include <kdebug.h>

#include "kmobiletoolshelper.h"
#include "kmobiletoolsengine.h"
#include "kmobiletools_devices.h"


#include "popupnumber.h"
#include "popupaddressee.h"

addressDetails::addressDetails(QWidget *parentWidget, const char *widgetname,QObject *parent, const char *name)
 : KHTMLPart(parentWidget, widgetname, parent, name)
{
    connect(this, SIGNAL(popupMenu(const QString &,const QPoint &)), SLOT(popupMenu ( const QString &, const QPoint &) ) );
    connect( browserExtension(), SIGNAL( openURLRequest(const KURL &, const KParts::URLArgs &) ), this, SLOT( openURLRequest(const KURL &) ) );
    p_addressee=0;
    showHP();
}


addressDetails::~addressDetails()
{
}


#include "addressdetails.moc"

const QString addressDetails::getTemplate()
{
    return  KMobiletoolsHelper::getTemplate()
            .arg( KMobiletoolsHelper::getFooterLink( i18n("Add new contact", "Add new"), "wizard", "contact:add" ) )
            .arg( KMobiletoolsHelper::getFooterLink( i18n("Fetch phonebook from the mobile", "Reload"), "reload", "contact:refresh" ) )
            .arg( KMobiletoolsHelper::getFooterLink( i18n("Import phonebook", "Import"), "revert", "contact:import" ) )
            .arg( KMobiletoolsHelper::getFooterLink( i18n("Export phonebook", "Export"), "fileexport", "contact:export" ) );
}
/*!
    \fn addressDetails::showAddressee(KABC::Addressee &addressee)
 */
void addressDetails::showAddressee(KABC::Addressee *addressee, bool readOnly)
{
    if(!addressee) return;
    ro=readOnly;
    QString htmlData; // ="<img src=\"%1\" align=\"middle\"> <b><i>%2</b>";
//     htmlData=htmlData.arg( KGlobal::iconLoader()->iconPath("personal", KIcon::Desktop, false) ).arg( addressee->formattedName() );
    /*="<div style=\"border-bottom-style : hidden; border-bottom-width : 10; border-left-style : hidden;\
        border-left-width : 5; border-right-style : hidden; border-right-width : 5; border-spacing : 5; border-top-style :\
        hidden; border-top-width : 10;background-color: %1; color: %2\">\
    <img src=\"%3\" align=\"middle\"> <b><i>%4</b></i></div>\n\n";*/
    QString renderData=getTemplate().arg( KGlobal::iconLoader()->iconPath("personal", -KIcon::SizeHuge, false) )
            .arg( addressee->formattedName() );
    if(readOnly) renderData=renderData.arg(QString::null).arg(QString::null);
    else renderData=renderData
            .arg( KMobiletoolsHelper::getFooterLink( i18n("Edit Contact", "Edit") , "edit", "contact:edit" ) )
            .arg( KMobiletoolsHelper::getFooterLink( i18n("Delete Contact", "Delete") , "editdelete", "contact:del" ) );
    /*
    htmlData = htmlData
                .arg( KGlobalSettings::activeTitleColor().name() )
                .arg( KGlobalSettings::activeTextColor().name() )
                .arg( KGlobal::iconLoader()->iconPath("personal", KIcon::Desktop, false) ).arg( addressee->formattedName() );
    */
    KABC::PhoneNumber::List numberList = addressee->phoneNumbers();
    for ( KABC::PhoneNumber::List::Iterator it = numberList.begin(); it != numberList.end(); it++ )
    {
        htmlData += QString("<p><b>%1:</b> <a href=\"number:").arg( (*it).label() );
        htmlData+=KURL::encode_string_no_slash( (*it).number() )
                + "\">" +QStyleSheet::escape( (*it).number() ) + "</a></p>\n";
    }
    htmlData+=i18n("<p>Stored on: <b>%1</b></p>");
    switch( addressee->custom("KMobileTools","memslot").toInt() ){
        case kmobiletoolsEngine::PB_SIM:
            htmlData=htmlData.arg( PB_SIM_TEXT );
            break;
        case kmobiletoolsEngine::PB_Phone:
            htmlData=htmlData.arg( PB_PHONE_TEXT );
            break;
        case kmobiletoolsEngine::PB_DataCard:
            htmlData=htmlData.arg( PB_DATACARD_TEXT );
            break;
        default:
            htmlData=htmlData.arg( i18n("not available") );
    }
/*    htmlData+=QString("<div style=\"border-bottom-style : hidden; border-bottom-width : 10; border-left-style : hidden;\
            border-left-width : 5; border-right-style : hidden; border-right-width : 5; border-spacing : 5; border-top-style :\
            hidden; border-top-width : 10; position: absolute; bottom: 10px; left: 10px; right: 10px; background-color: %3; color: %4\" align=\"right\"><a href=\"contact:edit\">%1</a>&nbsp;&nbsp;&nbsp;&nbsp;<a href=\"contact:refresh\">%2</a></div>")
            .arg( i18n("Edit contact") ).arg(i18n ("Reload list") )
            .arg( KGlobalSettings::activeTitleColor().name() )
            .arg( KGlobalSettings::activeTextColor().name() );*/
    renderData=renderData.arg(htmlData );
    begin();
    write( renderData );
    end();
    p_addressee=addressee;
}


/*!
    \fn addressDetails::popupMenu ( const QString &url, const QPoint &point)
 */
void addressDetails::popupMenu ( const QString &url, const QPoint &point)
{
    KURL kurl(url);
    KPopupMenu *popup=0;
    if(kurl.protocol()=="number")
        popup=new popupNumber(kurl.path(), 0, name() );
    if( url.isNull() )
    {
        if(!p_addressee) return;
        popup=new popupAddressee(p_addressee, 0, name(), ro );
        connect(popup, SIGNAL( editClicked(KABC::Addressee *) ), this, SIGNAL(editClicked(KABC::Addressee* ) ) );
        connect(popup, SIGNAL( delContact() ), this, SIGNAL(delContact() ) );
    }
    if(!popup) return;
    popup->exec(point);
}


void addressDetails::openURLRequest(const KURL &url)
{
    if(url.path() == "refresh") emit refreshClicked();
    if(url.path() == "edit") emit editClicked(p_addressee);
    if(url.path() == "add" ) emit addContact();
    if(url.path() == "del" ) emit delContact();
    if(url.path() == "import") emit importPB();
    if(url.path() == "export") emit exportPB();
    if(url.protocol() == "number") emit dial(url.path() );
}


/*!
    \fn addressDetails::showHP()
 */
void addressDetails::showHP()
{
    begin();
    write( getTemplate().arg(KGlobal::iconLoader()->iconPath("kontact_contacts", -KIcon::SizeHuge, false) )
            .arg( i18n("%1 AddressBook").arg( DeviceConfigInstance(name() )->devicename() ) )
            .arg("")            .arg("")
            .arg( i18n("<p><i>Click a contact on the left list to see details, or \"Reload\" to update the contacts list.</i></p>") )
         );
    end();
    p_addressee=0;
}
