/***************************************************************************
   Copyright (C) 2007
   by Marco Gulino <marco@kmobiletools.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/
#include "smspart.h"
#include <klocale.h>
#include <kiconloader.h>
#include <qstylesheet.h>
#include <kpopupmenu.h>
#include <khtmlview.h>
#include <kstdaction.h>
#include <kaction.h>
#include <stdio.h> ///@TODO remove after testing.

#include "kmobiletoolshelper.h"
#include "popupnumber.h"
#include "sms.h"

#define strBegin QString("<a href=\"smsctl:refresh\">%1</a> %2").arg(i18n("Click here") ).arg(i18n("to fetch all SMS from the phone") )

using namespace KMobileTools;
smsPart::smsPart(QWidget *parentWidget, const char *widgetname, QObject *parent, const char *name, GUIProfile prof)
    : KHTMLPart(parentWidget, widgetname, parent, name, prof), p_sms(0)
{
//     begin();
//     write(strBegin);
//     end();
    writeHome();
    setEncoding( "utf16", true );
    setCharset( "utf16", true );
    connect(browserExtension(), SIGNAL(openURLRequest(const KURL &, const KParts::URLArgs &) ), this, SLOT(openURLRequest(const KURL& ) ) );
    connect(this, SIGNAL(popupMenu( const QString&, const QPoint& )), this, SLOT(slotPopupMenu( const QString&, const QPoint& )) );
//     connect(browserExtension(), SIGNAL(selectionInfo(const QString & )), this, SLOT(slotSelectedText( const QString& )) );
    setJScriptEnabled(true);
}


smsPart::~smsPart()
{
}


#include "smspart.moc"

const QString smsPart::getTemplate()
{
    return  KMobiletoolsHelper::getTemplate()
            .arg( KMobiletoolsHelper::getFooterLink( i18n("Write a new SMS", "Write new"), "wizard", "sms:add" ) )
            .arg( KMobiletoolsHelper::getFooterLink( i18n("Reload SMS List", "Reload"), "reload", "sms:refresh" ) )
            .arg(/* KMobiletoolsHelper::getFooterLink( i18n("Import SMSList", "Import"), "revert", "sms:import" )*/ "&nbsp;" )
            .arg( KMobiletoolsHelper::getFooterLink( i18n("Export SMSList", "Export"), "fileexport", "sms:export" ) );
}


/*!
    \fn smsPart::openURLRequest(const KURL &url)
 */
void smsPart::openURLRequest(const KURL &url)
{
    if( url.protocol() == "sms" )
    {
        if(url.path() == "refresh" ) emit getSMSList();
        if(url.path() == "add" ) emit writeNew();
        if(url.path() == "import") emit importList();
        if(url.path() == "export") emit exportList();
        if(url.path() == "exportToCSV") emit exportListToCSV();
        if(!p_sms) return;
        if(url.path() == "reply") slotReply();
        if(url.path() == "delete") slotRemove();
        if(url.path() == "send") emit send( p_sms );
    }
}

void smsPart::slotRemove() { if(p_sms) emit remove( p_sms ); }
void smsPart::slotReply() { if(p_sms && p_sms->isIncoming() ) emit reply( p_sms->getFrom() ); }

void smsPart::show( SMS *sms)
{
    setSMS( sms );
    QString text=getTemplate()
            .arg( KGlobal::iconLoader()->iconPath("smslist", -KIcon::SizeHuge, false) );
    if ( sms->type() & SMS::Unread || sms->type() & SMS::Read )
    {
        text=text
                .arg( i18n("From: <a href=\"number:%1\" title=\"%2\">%3</a><br>Received Date: %4")
                .arg( sms->getFrom() )
                .arg( QStyleSheet::escape( sms->getFrom() ) )
                .arg( QStyleSheet::escape( KMobiletoolsHelper::translateNumber( sms->getFrom() ) ) )
                .arg( QStyleSheet::escape( sms->getDate() ) )
                )
                .arg( KMobiletoolsHelper::getFooterLink( i18n("Reply to this SMS", "Reply"), "mail_reply", "sms:reply" )  )
                .arg( KMobiletoolsHelper::getFooterLink( i18n("Delete this SMS", "Remove"), "cancel", "sms:delete" )  );
    } else
    {
        QString receivers;
        QStringList sl_receivers=sms->getTo();
        QStringList::Iterator it;
        for(it=sl_receivers.begin(); it!=sl_receivers.end(); ++it)
        {
            if( it!=sl_receivers.begin() ) receivers+=", ";
            receivers+=i18n("<a href=\"number:%1\" title=\"%2\">%3</a>")
                    .arg(*it)
                    .arg( QStyleSheet::escape( *it ) )
                    .arg( QStyleSheet::escape( KMobiletoolsHelper::translateNumber( *it ) ));
        }
        text=text
                .arg( i18n("To: %1<br>Stored Date: %2")
                .arg( receivers )
                .arg( QStyleSheet::escape( sms->getDate()) )
                    );
        if( sms->type() & SMS::Unsent )
            text=text.arg( KMobiletoolsHelper::getFooterLink( i18n("Send this SMS", "Send"), "mail_send", "sms:send" )  );
        else text=text.arg( KMobiletoolsHelper::getFooterLink( i18n("Resend this SMS", "Resend"), "mail_send", "sms:send" )  );
        text=text.arg( KMobiletoolsHelper::getFooterLink( i18n("Delete this SMS", "Remove"), "cancel", "sms:delete" )  );
    }/*
    QString testString="prova ";
    for (uint i=0; i<8; i++) testString+=testString;*/ // Long sms emulation
    text=text.arg( QStyleSheet::convertFromPlainText( sms->getText() , QStyleSheetItem::WhiteSpaceNormal) );
//     kdDebug() << text << endl;
    begin();
    write(text);
//     kdDebug() << "------------------------------ SMS Part ----------------------------------\n";
//     printf( text.latin1());
//     kdDebug() << "\n------------------------------ End SMS ----------------------------------\n";
    end();
}

void smsPart::writeHome()
{
    begin();
    write( getTemplate().arg(KGlobal::iconLoader()->iconPath("smslist", -KIcon::SizeHuge, false) )
            .arg( i18n("%1 SMS List").arg(name() ) )
            .arg("")            .arg("")
            .arg( i18n("<p><i>Click a SMS on the list to view it, or \"Reload\" to update the SMS list.</i></p>") )
         );
    end();
    p_sms=0;
}


/*!
    \fn smsPart::popupMenu(const QString &url, const QPoint &point)
 */
void smsPart::slotPopupMenu(const QString &url, const QPoint &point)
{
    if(!p_sms) return;
    KPopupMenu *menu=0;
    KURL kurl(url);
    if(kurl.protocol()=="number")
    {
        menu=new popupNumber(kurl.path(), 0, name() );
        menu->exec(point);
        return;
    }

    menu=new KPopupMenu ( view(), name() );
    KAction *copy=KStdAction::copy( browserExtension(), SLOT(copy() ), actionCollection(), "copy" );
    copy->setEnabled( ! selectedText().isNull() );
    copy->plug(menu);
    if( p_sms->isIncoming())
        (new KAction(i18n("Reply to this SMS", "Reply"), QIconSet(SmallIcon("mail_reply")), KShortcut(), this, SLOT(slotReply() ), actionCollection() ))
                ->plug(menu);
    (new KAction(i18n("Delete this SMS", "Remove"), QIconSet(SmallIcon("cancel")), KShortcut(), this, SLOT(slotRemove() ), actionCollection() ))
            ->plug(menu);

//     menu->insertItem(url);
    menu->exec( point );
}

