/***************************************************************************
   Copyright (C) 2007
   by Marco Gulino <marco@kmobiletools.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/
#ifndef DEVICEINTERFACE_H
#define DEVICEINTERFACE_H

#include <qobject.h>
#include <qstringlist.h>

#include <dcopobject.h>


/**
@author Marco Gulino
*/
class DeviceIFace : virtual public DCOPObject
{
K_DCOP
k_dcop:
//     virtual void callNumber(QString) = 0;
//     virtual void dial_Clicked() = 0;
    virtual bool isConnected() = 0;
    virtual QStringList encodings()=0;
    virtual void stopDevice()=0;
    virtual void resumeDevice()=0;
    virtual void switch2filesystem()=0;
    virtual QString deviceVendor() = 0;
    virtual QString deviceModel() = 0;
    virtual void raiseDevice() = 0;
    virtual const QString friendlyName() = 0;
    virtual void sendSMS(const QString&, const QString& )=0;
    virtual void storeSMS(const QString&, const QString& )=0;
    virtual void slotFetchPhonebook()=0;
    virtual void slotFetchCalendar()=0;
    virtual void slotExportSMSList()=0;
    virtual void slotNewSMS()=0;
    virtual void slotNewSMS(const QString &)=0;
    virtual void slotDialNumber(const QString &)=0;
    virtual void raisePage(int)=0;
    virtual QString currentDeviceName() const=0;
};

#endif
