/***************************************************************************
   Copyright (C) 2007
   by Marco Gulino <marco@kmobiletools.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/
#include "engineslist.h"
#include "kmobiletools_devices.h"

#include "kmobiletoolsengine.h"

#include <ktrader.h>
#include <kplugininfo.h>

EnginesList *EnginesList::p_instance=0;

EnginesList::EnginesList()
    : QObject(0, "enginesList") , QPtrList<kmobiletoolsEngine>()
{
    p_instance=this;
    setAutoDelete(false);
    b_closing=false;
}


EnginesList::~EnginesList()
{
    kdDebug() << "EnginesList::~EnginesList()\n";
}

#include "engineslist.moc"

void EnginesList::queryClose()
{
    b_closing=true;
    kmobiletoolsEngine *tempDevice;
    QStringList out;
    QPtrListIterator<kmobiletoolsEngine> it (*this);
    while( (( tempDevice=it.current()) != 0) && !this->isEmpty()  )
    {
        ++it;
        if(tempDevice)
        {
//             tempDevice->disconnect(tempDevice, 0, 0, 0);
            tempDevice->queryClose();
        }
    }
    ThreadWeaver::Weaver::deleteInstance();
}

void EnginesList::append( const kmobiletoolsEngine* item )
{
    emit engineAdded( item );
    connect(item, SIGNAL(phoneBookUpdated()), this, SIGNAL(phonebookUpdated() ));
    QPtrList<kmobiletoolsEngine>::append(item);
}

void EnginesList::remove( const kmobiletoolsEngine* item )
{
    emit engineRemoved( item );
    disconnect(item, SIGNAL(phoneBookUpdated()), this, SIGNAL(phonebookUpdated() ));
    QPtrList<kmobiletoolsEngine>::remove(item);
}
/*
void EnginesList::emitPhonebookUpdated()
{
    kdDebug() << "EnginesList::emitPhonebookUpdated()\n";
    emit phonebookUpdated();
}*/

void EnginesList::dump()
{
    kdDebug() << "EnginesList::dump()\n";
}

const QStringList EnginesList::namesList(bool friendlyNames)
{
    kmobiletoolsEngine *tempDevice;
    QStringList out;
    QPtrListIterator<kmobiletoolsEngine> it (*this);
    while( (( tempDevice=it.current()) != 0) && !this->isEmpty()  )
    {
        ++it;
        if(friendlyNames) out+= DeviceConfigInstance(tempDevice->name() )->devicename();
        else out+=tempDevice->name();
    }
    return out;
}

kmobiletoolsEngine *EnginesList::find( const QString &name, bool friendlyName)
{
    kmobiletoolsEngine *tempDevice;
    QPtrListIterator<kmobiletoolsEngine> it (*this);
    while( (( tempDevice=it.current()) != 0) && !this->isEmpty()  )
    {
        ++it;
        if(friendlyName)
        {
            if ( DeviceConfigInstance(tempDevice->name() )->devicename() == name ) return tempDevice;
        }
        else
            if( tempDevice->name() == name ) return tempDevice;
    }
    return 0;
}

QValueList<KPluginInfo *> EnginesList::availEngines()
{
    KTrader* trader=KTrader::self();
    return KPluginInfo::fromServices(trader->query("KMobileTools/Engine") );
}

KPluginInfo *EnginesList::engineInfo(const QString &s, bool searchByLibrary)
{
    QValueList<KPluginInfo *> l_engines=availEngines();
    for(QValueList<KPluginInfo *>::iterator it=l_engines.begin(); it!=l_engines.end(); it++)
        if( ( (!searchByLibrary) && s==(*it)->name() ) ||
                (searchByLibrary && s==(*it)->service()->library() ) ) return (*it);
    return NULL;
}

