/***************************************************************************
   Copyright (C) 2007
   by Marco Gulino <marco@kmobiletools.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/
#ifndef ENGINESLIST_H
#define ENGINESLIST_H

#include <qptrlist.h>
#include <qstringlist.h>
#include <qobject.h>

/**
	@author Marco Gulino <marco@kmobiletools.org>
*/
class kmobiletoolsEngine;
class KPluginInfo;
class EnginesList : public QObject, public QPtrList<kmobiletoolsEngine>
{
    Q_OBJECT
public:
    EnginesList();

    ~EnginesList();
    static EnginesList *instance(){ return p_instance; }
    const QStringList namesList(bool friendlyNames=false);
    kmobiletoolsEngine *find( const QString &name, bool friendlyName=false);
    void queryClose();
    void append ( const kmobiletoolsEngine* item );
    void remove ( const kmobiletoolsEngine* item );
    bool closing() { return b_closing; }
    bool locked(const QString &device) { return (bool) s_locklist.contains(device); }
    const QStringList locklist() { return s_locklist; }
    bool lock(const QString &device) { if(locked(device)) return false; s_locklist+=device; return true; }
    void unlock(const QString &device) { s_locklist.remove(device); }
    QValueList<KPluginInfo *> availEngines();
    KPluginInfo* engineInfo(const QString &s, bool searchByLibrary=true);

    private:
        static EnginesList *p_instance;
        QStringList s_locklist;
        bool b_closing;
    public slots:
        void dump();
//         void emitPhonebookUpdated();
    signals:
        void phonebookUpdated(); /// Emitted when one of the engines has updated internal phonebook;
        void engineAdded(const kmobiletoolsEngine *);
        void engineRemoved(const kmobiletoolsEngine *);

};

#endif
