/***************************************************************************
   Copyright (C) 2007
   by Marco Gulino <marco@kmobiletools.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/
#ifndef KEYCOMBOBOX_H
#define KEYCOMBOBOX_H

#include <kcombobox.h>

/**
	@author Marco Gulino <marco@kmobiletools.org>
*/
class KeyComboBoxPrivate;
class KeyComboBox : public KComboBox
{
Q_OBJECT
Q_PROPERTY( QString currentKeyword READ currentKeyword WRITE setCurrentKeyword DESIGNABLE true )
public:
    KeyComboBox(bool rw, QWidget* parent, const char* name);
    
    KeyComboBox(QWidget* parent, const char* name);

    ~KeyComboBox();

    void insertItem(const QString &text, const QString &keyword);
    QString currentKeyword() const;
    QString keyword(int index) const;
    void setCurrentKeyword(const QString &keyword);
    void setKeyword(int index, const QString &keyword);
private:
    KeyComboBoxPrivate *d;
};

#endif
